/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MRequestUpdate;
import org.compiere.model.MStatus;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class RequestOrder
extends SvrProcess {
    private int requestID = 0;
    private int pListID = 0;
    private int posID = 0;
    private int docTypeID = 0;
    private MInvoice m_invoice = null;
    private int m_linecount = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("M_PriceList_ID")) {
                this.pListID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_POS_ID")) {
                this.posID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_DocType_ID")) {
                this.docTypeID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.requestID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MOrder order;
        String message = "";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        MRequest req = new MRequest(this.getCtx(), this.requestID, this.get_TrxName());
        MPriceList list = new MPriceList(this.getCtx(), this.pListID, this.get_TrxName());
        int bpLocationID = 0;
        MRequestType type = MRequestType.get(this.getCtx(), req.getR_RequestType_ID());
        MStatus status = MStatus.get(this.getCtx(), req.getR_Status_ID());
        if (!status.isClosed()) {
            throw new AdempiereException("La solicitud no est\u00e1 cerrada");
        }
        if (!type.isInvoiced()) {
            throw new AdempiereException("El tipo de solicitud no es facturable");
        }
        Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        MOrg org = new MOrg(this.getCtx(), req.getAD_Org_ID(), this.get_TrxName());
        MOrgInfo info = org.getInfo();
        if (info.getM_Warehouse_ID() <= 0) {
            throw new AdempiereException("La organizaci\u00f3n " + org.getName() + " no tiene almac\u00e9n definido");
        }
        if (req.getC_BPartner_ID() <= 0) {
            throw new AdempiereException("La solicitud no tiene socio de negocio");
        }
        MBPartnerLocation[] locations = MBPartnerLocation.getForBPartner(this.getCtx(), req.getC_BPartner_ID(), this.get_TrxName());
        if (locations.length > 0) {
            bpLocationID = locations[0].getC_BPartner_Location_ID();
        }
        try {
            order = new MOrder(this.getCtx(), 0, this.get_TrxName());
            order.setC_DocTypeTarget_ID(this.docTypeID);
            order.setDateOrdered(today);
            order.setC_BPartner_ID(req.getC_BPartner_ID());
            order.setDeliveryRule("A");
            order.setDeliveryViaRule("P");
            order.setM_Warehouse_ID(info.getM_Warehouse_ID());
            order.setSalesRep_ID(Env.getAD_User_ID(this.getCtx()));
            order.setPaymentRule("S");
            order.setC_POS_ID(this.posID);
            order.setM_PriceList_ID(this.pListID);
            order.setC_Currency_ID(list.getC_Currency_ID());
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            String sql = "SELECT r_requestupdate_id FROM r_requestupdate WHERE r_request_id = " + this.requestID + " AND m_productspent_id > 0";
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MRequestUpdate update = new MRequestUpdate(this.getCtx(), rs.getInt("r_requestupdate_id"), this.get_TrxName());
                MProduct prod = new MProduct(this.getCtx(), update.getM_ProductSpent_ID(), this.get_TrxName());
                MOrderLine line = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
                line.setC_Order_ID(order.get_ID());
                line.setC_BPartner_ID(order.getC_BPartner_ID());
                if (bpLocationID > 0) {
                    line.setC_BPartner_Location_ID(bpLocationID);
                }
                line.setDateOrdered(order.getDateOrdered());
                line.setM_Product_ID(update.getM_ProductSpent_ID());
                line.setM_Warehouse_ID(order.getM_Warehouse_ID());
                line.setC_UOM_ID(prod.getC_UOM_ID());
                line.setQtyEntered(update.getQtyInvoiced());
                line.setQtyOrdered(update.getQtyInvoiced());
                line.setC_Currency_ID(order.getC_Currency_ID());
                line.saveEx();
            }
            req.setC_Order_ID(order.get_ID());
            req.saveEx();
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "@Created@ @C_Order_ID@ " + order.getDocumentNo();
    }
}

