/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.adempiere.core.domains.models.I_C_Order;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequest;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.process.RequestCreditNoteAbstract;

public class RequestCreditNote
extends RequestCreditNoteAbstract {
    private boolean IsFromInvoice;
    private int count = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice invoice = null;
        MOrder order = null;
        if (!this.isSameData() && this.getComments() == null) {
            throw new AdempiereException("ERROR: Debe ingresar datos para proveedor o marcar check 'Misma Info Proveedor'");
        }
        if (this.getPercent().compareTo(Env.ZERO) == 0) {
            throw new AdempiereException("ERROR: Debe ingresar porcentaje para proveedor");
        }
        if (this.getTable_ID() == MInvoice.Table_ID) {
            this.IsFromInvoice = true;
            invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            if (!invoice.isSOTrx()) {
                throw new AdempiereException("ERROR: El proceso se debe ejecutar desde un DxC");
            }
            if (!invoice.getDocStatus().equals("CO") && !invoice.getDocStatus().equals("CL")) {
                throw new AdempiereException("ERROR: El documento no est\u00e1 Completo");
            }
            this.executeFromInvoice(invoice);
        } else {
            this.IsFromInvoice = false;
            order = new MOrder(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            if (!order.isSOTrx()) {
                throw new AdempiereException("ERROR: El proceso se debe ejecutar desde una OV");
            }
            if (!order.getDocStatus().equals("CO") && !order.getDocStatus().equals("CL")) {
                throw new AdempiereException("ERROR: El documento no est\u00e1 Completo");
            }
            MOrderLine[] oLines = order.getLines(" AND QtyInvoiced = 0", "");
            if (oLines.length > 0) {
                throw new AdempiereException("ERROR: La OV no tiene ninguna linea facturada");
            }
            this.executeFromOrder(order);
        }
        String message = "Solicitudes Generadas = " + this.count;
        return message;
    }

    public void executeFromInvoice(MInvoice invoice) {
        Object sql = "";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql = "select distinct o.c_order_id, o.link_order_id from c_order o join c_orderline ol on o.c_order_id = ol.c_order_id join c_invoiceline il on ol.c_orderline_id = il.c_orderline_id join c_invoice i on il.c_invoice_id = i.c_invoice_id and o.docstatus in ('CO','CL') and i.c_invoice_id = " + invoice.get_ID();
        try {
            this.createRequestInvoice(invoice, null);
            pstmt = DB.prepareStatement((String)sql, invoice.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int linkOrderID = rs.getInt("Link_Order_ID");
                if (linkOrderID <= 0) continue;
                MOrder linkOrder = new MOrder(invoice.getCtx(), linkOrderID, invoice.get_TrxName());
                this.executeFromLinkOrder(linkOrder);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    public void executeFromOrder(MOrder order) {
        Object sql = "";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql = "select i.c_invoice_id, o.link_order_id from c_invoiceline il join c_invoice i on il.c_invoice_id = i.c_invoice_id join c_orderline ol on il.c_orderline_id = ol.c_orderline_id join c_order o on ol.c_order_id = o.c_order_id where i.docstatus in ('CO','CL') and ol.c_order_id = " + order.get_ID() + " group by i.c_invoice_id, o.link_order_id order by i.c_invoice_id, o.link_order_id";
        try {
            pstmt = DB.prepareStatement((String)sql, order.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int invoiceID = rs.getInt("C_Invoice_ID");
                int linkOrderID = rs.getInt("Link_Order_ID");
                if (invoiceID > 0) {
                    MInvoice invoice = new MInvoice(order.getCtx(), invoiceID, order.get_TrxName());
                    this.createRequestInvoice(invoice, order);
                }
                if (linkOrderID <= 0) continue;
                MOrder linkOrder = new MOrder(order.getCtx(), linkOrderID, order.get_TrxName());
                this.executeFromLinkOrder(linkOrder);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void executeFromLinkOrder(MOrder order) {
        Object sql = "";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean existsInvoice = false;
        sql = "select c_invoice_id from c_invoice where issotrx = 'N' and c_order_id = " + order.get_ID() + " and docstatus in ('CO','CL')";
        try {
            pstmt = DB.prepareStatement((String)sql, order.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                existsInvoice = true;
                int invoiceID = rs.getInt("C_Invoice_ID");
                MInvoice invoice = new MInvoice(order.getCtx(), invoiceID, order.get_TrxName());
                this.createRequestInvoice(invoice, order);
            }
            if (!existsInvoice) {
                order.set_ValueOfColumn("IsInDispute", (Object)true);
                order.saveEx();
                this.createRequestOrder(order);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    public void createRequestInvoice(MInvoice invoice, MOrder order) {
        try {
            Timestamp today = new Timestamp(System.currentTimeMillis());
            MRequest request = new MRequest(invoice.getCtx(), 0, invoice.get_TrxName());
            request.setC_Invoice_ID(invoice.get_ID());
            request.setC_Project_ID(invoice.getC_Project_ID());
            request.setC_BPartner_ID(invoice.getC_BPartner_ID());
            request.setDateStartPlan(today);
            if (invoice.isSOTrx()) {
                request.setR_RequestType_ID(1000004);
                request.setSubject("NOTA DE CREDITO CLIENTE");
                request.setSummary(this.getSummary());
                request.setRequestAmt(this.getRequestAmt());
                request.set_ValueOfColumn("Percentage", (Object)this.getPercentage());
            } else {
                request.setR_RequestType_ID(1000005);
                request.setSubject("NOTA DE CREDITO PROVEEDOR");
                if (this.isSameData()) {
                    request.setSummary(this.getSummary());
                } else {
                    request.setSummary(this.getComments());
                }
                request.set_ValueOfColumn("Percentage", (Object)this.getPercent());
                request.setRequestAmt(order.getGrandTotal().multiply(this.getPercent().divide(Env.ONEHUNDRED, RoundingMode.HALF_UP)));
            }
            if (this.IsFromInvoice) {
                request.setAD_Table_ID(I_C_Invoice.Table_ID);
                request.setRecord_ID(invoice.get_ID());
                request.setAD_Org_ID(invoice.getAD_Org_ID());
            } else {
                request.setAD_Table_ID(I_C_Order.Table_ID);
                request.setRecord_ID(order.get_ID());
                request.setAD_Org_ID(order.getAD_Org_ID());
                request.setC_Order_ID(order.get_ID());
            }
            request.saveEx();
            ++this.count;
            if (!invoice.isSOTrx()) {
                invoice.setIsInDispute(true);
                invoice.saveEx();
            }
            DB.executeUpdateEx("update r_request set salesrep_id = " + this.getSalesRepId() + " where r_request_id = " + request.get_ID(), invoice.get_TrxName());
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    public void createRequestOrder(MOrder order) {
        try {
            Timestamp today = new Timestamp(System.currentTimeMillis());
            MRequest request = new MRequest(order.getCtx(), 0, order.get_TrxName());
            request.setC_Project_ID(order.getC_Project_ID());
            request.setC_BPartner_ID(order.getC_BPartner_ID());
            request.setDateStartPlan(today);
            if (order.isSOTrx()) {
                request.setR_RequestType_ID(1000004);
                request.setSubject("NOTA DE CREDITO CLIENTE");
                request.setSummary(this.getSummary());
                request.setRequestAmt(this.getRequestAmt());
                request.set_ValueOfColumn("Percentage", (Object)this.getPercentage());
            } else {
                request.setR_RequestType_ID(1000005);
                request.setSubject("NOTA DE CREDITO PROVEEDOR");
                if (this.isSameData()) {
                    request.setSummary(this.getSummary());
                } else {
                    request.setSummary(this.getComments());
                }
                request.set_ValueOfColumn("Percentage", (Object)this.getPercent());
                request.setRequestAmt(order.getGrandTotal().multiply(this.getPercent().divide(Env.ONEHUNDRED, RoundingMode.HALF_UP)));
            }
            request.setAD_Table_ID(I_C_Order.Table_ID);
            request.setRecord_ID(order.get_ID());
            request.setAD_Org_ID(order.getAD_Org_ID());
            request.setC_Order_ID(order.get_ID());
            request.saveEx();
            ++this.count;
            DB.executeUpdateEx("update r_request set salesrep_id = " + this.getSalesRepId() + " where r_request_id = " + request.get_ID(), order.get_TrxName());
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }
}

