/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MSequence;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.openup.core.model.MUYMoldeRecognition;
import org.openup.core.process.RUnbilledRecognitionAbstract;

public class RUnbilledRecognition
extends RUnbilledRecognitionAbstract {
    private static final String TABLA_MOLDE = "UY_Molde_Recognition";
    private Timestamp p_StatementDate = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        Object select = "";
        String insert = "";
        String where = " AND o.issotrx = '" + (this.isSOTrx() ? "Y" : "N") + "'";
        this.deleteOldData();
        if (this.getOrgId() > 0) {
            where = where + " AND l.AD_Org_ID =" + this.getOrgId();
        }
        if (this.getUser1Id() > 0) {
            where = where + " AND o.User1_ID =" + this.getUser1Id();
        }
        if (this.getDateOrdered() != null) {
            where = where + " AND o.DateOrdered >= '" + this.getDateOrdered() + "'";
        }
        if (this.getDateOrderedTo() != null) {
            where = where + " AND o.DateOrdered <= '" + this.getDateOrderedTo() + "'";
        }
        if (this.getBPartnerId() > 0) {
            where = where + " AND o.C_BPartner_ID =" + this.getBPartnerId();
        }
        if (this.getContractId() > 0) {
            where = where + " AND c.S_Contract_ID =" + this.getContractId();
        }
        if (this.getProjectId() > 0) {
            where = where + " AND pj.C_Project_ID =" + this.getProjectId();
        }
        if (this.getCurrencyId() > 0) {
            where = where + " AND o.C_Currency_ID =" + this.getCurrencyId();
        }
        if (this.getDocTypeTargetId() > 0) {
            where = where + " AND o.C_DocTypeTarget_ID =" + this.getDocTypeTargetId();
        }
        if (this.getUser1Id() > 0) {
            where = where + " AND o.User1_ID =" + this.getUser1Id();
        }
        if (!this.isSplitDocuments()) {
            where = where + " AND d.IsShipConfirm = 'N'";
        }
        this.p_StatementDate = this.getStatementDate() != null ? this.getStatementDate() : TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        MSequence sequence = MSequence.get(this.getCtx(), TABLA_MOLDE, this.get_TrxName());
        String IsSelected = this.isSelected() ? "Y" : "N";
        String IsSelectionColumn = this.isSelectionColumn() ? "Y" : "N";
        String IsSplitDocuments = this.isSplitDocuments() ? "Y" : "N";
        insert = "INSERT INTO UY_Molde_Recognition (UY_Molde_Recognition_ID, ad_client_id, ad_org_id, isactive, created, createdby, updated,  updatedby, c_order_id, user1_id, docstatus, c_doctypetarget_id, dropship_bpartner_id, c_bpartner_id,  c_currency_id, issotrx, c_project_id, c_orderline_id, dateordered, m_product_id, priceentered,  s_contract_id, user4_id, linenetamt, amtinvoiced, amttoinvoice, totalinvoicedamt, c_projectcategory_id,  recognizedamt, amttorecognize, recognizednotinvoiced, invoicednotrecognized, recognizedamtacct,  c_invoice_id, c_currency_id_to, currencyrate, amtinvoicedacct, isselected, isselectioncolumn, issplitdocuments)";
        select = "SELECT nextID(" + sequence.get_ID() + ", 'N'), x.ad_client_id, x.ad_org_id, 'Y', now(),\n" + this.getAD_User_ID() + ", now()," + this.getAD_User_ID() + ",\n    x.c_order_id,\n    x.user1_id,\n    x.docstatus,\n    x.c_doctypetarget_id,\n    x.dropship_bpartner_id,\n    x.c_bpartner_id,\n    x.c_currency_id,\n    x.issotrx,\n    x.c_project_id,\n    x.c_orderline_id,\n    x.dateordered,\n    x.m_product_id,\n    x.priceentered,\n    x.s_contract_id,\n    x.user4_id,\n    x.linenetamt,\n    COALESCE(x.amtinvoiced, 0::numeric) - COALESCE(x.amtinvoiced_nc, 0::numeric) AS amtinvoiced,\n    COALESCE(x.qtytoinvoice * x.priceentered, 0::numeric) AS amttoinvoice,\n    x.totalinvoicedamt,\n    x.c_projectcategory_id,\n    x.recognizedamt,\n    x.amttorecognize,\n    x.recognizednotinvoiced,\n    x.invoicednotrecognized,\n    x.recognizedamtacct,\n    x.c_invoice_id,\n    x.c_currency_id_to, \n    x.currencyrate,\n        CASE\n            WHEN x.c_invoice_id > 0::numeric and (x.c_currency_id_to is null or x.c_currency_id_to = x.c_currency_id) THEN ( SELECT currencyconvert(x.totalinvoicedamt, x.c_currency_id, 142::numeric, inv.dateinvoiced::timestamp with time zone, inv.c_conversiontype_id, x.ad_client_id, x.ad_org_id) AS currencyconvert\n               FROM c_invoice inv\n              WHERE inv.c_invoice_id = x.c_invoice_id)\n            WHEN x.c_invoice_id > 0::numeric and (x.c_currency_id_to is not null and x.c_currency_id_to <> x.c_currency_id) THEN (SELECT currencyconvert_receipt(x.totalinvoicedamt, x.currencyrate, x.c_currency_id, x.c_currency_id_to, x.ad_client_id, x.ad_org_id))\n            ELSE 0::numeric\n        END AS amtinvoicedacct,\n'" + IsSelected + "',\n'" + IsSelectionColumn + "',\n'" + IsSplitDocuments + "'\n   FROM ( SELECT l.ad_client_id,\n            o.ad_org_id,\n            l.isactive,\n            l.created,\n            l.createdby,\n            l.updated,\n            l.updatedby,\n            o.c_order_id,\n            o.user1_id,\n            o.docstatus,\n            o.c_doctypetarget_id,\n            o.dropship_bpartner_id,\n            o.c_bpartner_id,\n            o.c_currency_id,\n            o.issotrx,\n            pj.c_project_id,\n            l.c_orderline_id,\n            o.dateordered,\n            l.m_product_id,\n            l.priceentered,\n            l.qtyordered - l.qtydelivered AS qtytodeliver,\n            l.qtyordered - l.qtyinvoiced AS qtytoinvoice,\n            c.s_contract_id,\n            pj.user4_id,\n            l.linenetamt,\n                      ( SELECT sum(il.linenetamt) AS sum\n                   FROM c_invoiceline il\n                     JOIN c_invoice i ON il.c_invoice_id = i.c_invoice_id\n                     JOIN c_doctype d ON i.c_doctypetarget_id = d.c_doctype_id\n                  WHERE il.c_orderline_id = l.c_orderline_id AND (i.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar])) AND d.docbasetype = 'ARI'::bpchar) AS amtinvoiced,\n            ( SELECT sum(il.linenetamt) AS sum\n                   FROM c_invoiceline il\n                     JOIN c_invoice i ON il.c_invoice_id = i.c_invoice_id\n                     JOIN c_doctype d ON i.c_doctypetarget_id = d.c_doctype_id\n                  WHERE il.c_orderline_id = l.c_orderline_id AND (i.docstatus = ANY (ARRAY['CO'::bpchar, 'CL'::bpchar])) AND d.docbasetype = 'ARC'::bpchar) AS amtinvoiced_nc,\n            l.qtyinvoiced * l.priceentered AS totalinvoicedamt,    \n                CASE\n                    WHEN rrplan.c_revenuerecognition_plan_id IS NOT NULL THEN round(l.linenetamt - rrplan.recognizedamt, 2)\n                    ELSE 0::numeric\n                END AS amttorecognize,\n                CASE\n                    WHEN rrplan.c_revenuerecognition_plan_id IS NOT NULL AND (rrplan.recognizedamt - l.priceentered * l.qtyinvoiced) > 0::numeric THEN round(rrplan.recognizedamt - l.priceentered * l.qtyinvoiced, 2)\n                    ELSE 0::numeric\n                END AS recognizednotinvoiced,\n                CASE\n                    WHEN rrplan.c_revenuerecognition_plan_id IS NOT NULL AND (l.priceentered * l.qtyinvoiced - rrplan.recognizedamt) > 0::numeric THEN l.priceentered * l.qtyinvoiced - rrplan.recognizedamt\n                    ELSE 0::numeric\n                END AS invoicednotrecognized,\n            pj.c_projectcategory_id,\n            round(rrplan.recognizedamt, 2) AS recognizedamt,\n            rrplan.c_revenuerecognition_plan_id,\n            round(rrplan.recognizedamtacct, 2) AS recognizedamtacct,\n            firstinvoicefororder(o.c_order_id) AS c_invoice_id,\n            o.c_currency_id_to,\n            o.currencyrate\n           FROM c_order o\n             JOIN c_orderline l ON o.c_order_id = l.c_order_id\n             JOIN c_revenuerecognition_plan rrplan ON rrplan.c_orderline_id = l.c_orderline_id\n             JOIN c_doctype d ON o.c_doctypetarget_id = d.c_doctype_id\n             LEFT JOIN m_product p ON p.m_product_id = l.m_product_id\n             LEFT JOIN c_project pj ON o.c_project_id = pj.c_project_id\n             LEFT JOIN s_contract c ON pj.s_contract_id = c.s_contract_id\n          WHERE o.ad_client_id = 1000001::numeric\n          AND o.docstatus = 'CO'" + where + ") x";
        String sql = insert + (String)select;
        try {
            DB.executeUpdateEx(sql, this.get_TrxName());
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        this.updateData();
        return "";
    }

    private void deleteOldData() throws Exception {
        Object sql = "";
        sql = " DELETE FROM UY_Molde_Recognition WHERE createdby = " + this.getAD_User_ID();
        DB.executeUpdateEx((String)sql, null);
    }

    private void updateData() throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            sql = " SELECT UY_Molde_Recognition_ID, coalesce(RecognizedAmtAcct,0) as RecognizedAmtAcct, coalesce(AmtInvoicedAcct,0) as AmtInvoicedAcct, C_Invoice_ID, DateOrdered FROM UY_Molde_Recognition WHERE createdby = " + this.getAD_User_ID();
            pstmt = DB.prepareStatement((String)sql, 1004, 1007, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int invoiceID;
                int moldeID = rs.getInt("UY_Molde_Recognition_ID");
                BigDecimal RecognizedNotInvoicedAcct = Env.ZERO;
                BigDecimal InvoicedNotRecognizedAcct = Env.ZERO;
                RecognizedNotInvoicedAcct = rs.getBigDecimal("RecognizedAmtAcct").subtract(rs.getBigDecimal("AmtInvoicedAcct"));
                if (RecognizedNotInvoicedAcct == null) {
                    RecognizedNotInvoicedAcct = Env.ZERO;
                }
                if (this.isSelectionColumn()) {
                    if (RecognizedNotInvoicedAcct.compareTo(Env.ZERO) > 0) {
                        DB.executeUpdateEx("update UY_Molde_Recognition set RecognizedNotInvoicedAcct = " + RecognizedNotInvoicedAcct + " where UY_Molde_Recognition_ID = " + moldeID, this.get_TrxName());
                    }
                } else {
                    InvoicedNotRecognizedAcct = rs.getBigDecimal("AmtInvoicedAcct").subtract(rs.getBigDecimal("RecognizedAmtAcct"));
                    if (InvoicedNotRecognizedAcct == null) {
                        InvoicedNotRecognizedAcct = Env.ZERO;
                    }
                    if (InvoicedNotRecognizedAcct.compareTo(Env.ZERO) > 0) {
                        DB.executeUpdateEx("update UY_Molde_Recognition set InvoicedNotRecognizedAcct = " + InvoicedNotRecognizedAcct + " where UY_Molde_Recognition_ID = " + moldeID, this.get_TrxName());
                    }
                }
                DB.executeUpdateEx("update UY_Molde_Recognition set AmtAcctOpenBalance = " + RecognizedNotInvoicedAcct + " where UY_Molde_Recognition_ID = " + moldeID, this.get_TrxName());
                if (!this.isSelected()) continue;
                if (this.isSelectionColumn()) {
                    if (RecognizedNotInvoicedAcct.compareTo(Env.ZERO) <= 0) continue;
                    int DaysDue = DB.getSQLValueEx(this.get_TrxName(), "select (EXTRACT(epoch FROM ('" + this.p_StatementDate + "'::timestamp - '" + rs.getTimestamp("DateOrdered") + "'::timestamp )))/3600/24", new Object[0]);
                    this.setAging(DaysDue, RecognizedNotInvoicedAcct, moldeID);
                    continue;
                }
                if (InvoicedNotRecognizedAcct.compareTo(Env.ZERO) <= 0 || (invoiceID = rs.getInt("C_Invoice_ID")) <= 0) continue;
                MInvoice invoice = new MInvoice(this.getCtx(), invoiceID, this.get_TrxName());
                int DaysDue = DB.getSQLValueEx(this.get_TrxName(), "select (EXTRACT(epoch FROM ('" + this.p_StatementDate + "'::timestamp - '" + invoice.getDateInvoiced() + "'::timestamp )))/3600/24", new Object[0]);
                this.setAging(DaysDue, InvoicedNotRecognizedAcct, moldeID);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void setAging(int daysDue, BigDecimal amt, int moldeID) {
        MUYMoldeRecognition molde = new MUYMoldeRecognition(this.getCtx(), moldeID, this.get_TrxName());
        molde.setDaysDue(daysDue);
        if (daysDue <= 0) {
            if (daysDue >= -30) {
                molde.setDue0_30(molde.getDue0_30().add(amt));
            }
        } else {
            if (daysDue <= 30) {
                molde.setPastDue1_30(molde.getPastDue1_30().add(amt));
            }
            if (daysDue >= 31 && daysDue <= 60) {
                molde.setPastDue31_60(molde.getPastDue31_60().add(amt));
            }
            if (daysDue >= 61 && daysDue <= 90) {
                molde.setPastDue61_90(molde.getPastDue61_90().add(amt));
            }
            if (daysDue >= 91 && daysDue <= 120) {
                molde.setPastDue91_120(molde.getPastDue91_120().add(amt));
            }
            if (daysDue >= 121 && daysDue <= 180) {
                molde.setPastDue121_180(molde.getPastDue121_180().add(amt));
            }
            if (daysDue >= 181 && daysDue <= 365) {
                molde.setPastDue181_365(molde.getPastDue181_365().add(amt));
            }
            if (daysDue >= 365) {
                molde.setPastDue365(molde.getPastDue365().add(amt));
            }
        }
        molde.saveEx();
    }
}

