/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class RBillingProdGroup
extends SvrProcess {
    private Timestamp fechaDesde = null;
    private Timestamp fechaHasta = null;
    private int periodID = 0;
    private MPeriod period = null;
    private int partnerID = 0;
    private int selloID = 0;
    private int clientID = 0;
    private int orgID = 0;
    private int userID = 0;
    private static final String TABLA_MOLDE = "UY_Molde_BillingCustomProd";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("C_BPartner_ID") && para[i].getParameter() != null && para[i].getParameter() != null) {
                this.partnerID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_User_ID")) {
                this.userID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_Period_ID")) {
                this.periodID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("User4_ID")) {
                this.selloID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_Client_ID")) {
                this.clientID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (!name.equalsIgnoreCase("AD_Org_ID")) continue;
            this.orgID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
        this.period = new MPeriod(this.getCtx(), this.periodID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteInstanciasViejasReporte();
        this.getData();
        return "OK";
    }

    private void deleteInstanciasViejasReporte() {
        Object sql = "";
        try {
            sql = "DELETE FROM UY_Molde_BillingCustomProd WHERE ad_user_id = " + this.userID;
            DB.executeUpdateEx((String)sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private void getData() throws Exception {
        Object sql = "";
        String insert = "";
        Object where = "";
        insert = "INSERT INTO UY_Molde_BillingCustomProd (ad_client_id, ad_org_id, ad_user_id, c_period_id, c_bpartner_id, user4_id, m_product_group_id, title, amtacct, amt)";
        try {
            where = (String)where + " AND io.user4_id = " + this.selloID + " AND io.movementdate >= '" + this.period.getStartDate() + "' and io.movementdate <= '" + this.period.getEndDate() + "'";
            if (this.partnerID > 0) {
                where = (String)where + " AND io.c_bpartner_id = " + this.partnerID;
            }
            sql = "SELECT io.ad_client_id, io.ad_org_id, " + this.userID + "," + this.periodID + ", io.c_bpartner_id, io.user4_id, g.m_product_group_id, (select coalesce(name, null) from m_product_group where m_product_group_id = g.m_product_group_parent_id) as title, coalesce((select sum(ol.priceentered * iol.qtyentered) where o.c_currency_id = 142),0) as amtacct, coalesce((select sum(ol.priceentered * iol.qtyentered) where o.c_currency_id = 100),0) as amt FROM c_order o JOIN c_orderline ol ON o.c_order_id = ol.c_order_id JOIN m_inoutline iol ON ol.c_orderline_id = iol.c_orderline_id JOIN m_inout io ON iol.m_inout_id = io.m_inout_id JOIN m_product p ON iol.m_product_id = p.m_product_id JOIN m_product_group g ON p.m_product_group_id = g.m_product_group_id WHERE io.issotrx = 'Y'::bpchar AND io.docstatus in ('CO','CL') " + (String)where + " group by io.ad_client_id, io.ad_org_id, io.c_bpartner_id, o.c_currency_id, g.m_product_group_id, io.user4_id";
            DB.executeUpdateEx(insert + (String)sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }
}

