/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class RBillingCustomType
extends SvrProcess {
    private int periodID = 0;
    private MPeriod period = null;
    private int partnerID = 0;
    private int selloID = 0;
    private int contractID = 0;
    private int userID = 0;
    private static final String TABLA_MOLDE = "UY_Molde_BillingCustomProd";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("C_BPartner_ID") && para[i].getParameter() != null && para[i].getParameter() != null) {
                this.partnerID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_User_ID")) {
                this.userID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_Period_ID")) {
                this.periodID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("User4_ID")) {
                this.selloID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (!name.equalsIgnoreCase("S_Contract_ID") || para[i].getParameter() == null) continue;
            this.contractID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
        this.period = new MPeriod(this.getCtx(), this.periodID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteInstanciasViejasReporte();
        this.getData();
        return "OK";
    }

    private void deleteInstanciasViejasReporte() {
        Object sql = "";
        try {
            sql = "DELETE FROM UY_Molde_BillingCustomProd WHERE ad_user_id = " + this.userID;
            DB.executeUpdateEx((String)sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private void getData() throws Exception {
        String sql = "";
        String insert = "";
        Object whereFiltros = "";
        String where = "";
        insert = "INSERT INTO UY_Molde_BillingCustomProd (ad_client_id, ad_org_id, ad_user_id, c_bpartner_id,  c_period_id, title, amtacct, amt, amtentered, amount, amtinvoiced, invoicedamt, seqno, user4_id, s_contract_id)";
        try {
            whereFiltros = (String)whereFiltros + " AND io.user4_id = " + this.selloID + " AND io.movementdate >= '" + this.period.getStartDate() + "' and io.movementdate <= '" + this.period.getEndDate() + "'";
            if (this.partnerID > 0) {
                whereFiltros = (String)whereFiltros + " AND io.c_bpartner_id = " + this.partnerID;
            }
            if (this.contractID > 0) {
                whereFiltros = (String)whereFiltros + " AND io.s_contract_id = " + this.contractID;
            }
            where = " AND p.m_product_category_id not in (1000024, 1000025, 1000022) AND o.isdirectinvoice = 'N'";
            this.insertData("BILLINGS CARTESIS", "1", (String)whereFiltros + where, insert);
            where = " AND p.m_product_category_id not in (1000024, 1000025) AND o.isdirectinvoice = 'Y'";
            this.insertData("BILLINGS OUT", "2", (String)whereFiltros + where, insert);
            where = " AND p.m_product_category_id = 1000024";
            this.insertData("BILLINGS XAXIS", "3", (String)whereFiltros + where, insert);
            where = " AND p.m_product_category_id = 1000025";
            this.insertData("BILLINGS INVENTORY", "4", (String)whereFiltros + where, insert);
            where = " AND p.m_product_category_id = 1000022";
            this.insertData("CLIENT INCOME", "5", (String)whereFiltros + where, insert);
            where = " AND p.m_product_category_id = 1000021";
            this.insertData("REBATES", "6", (String)whereFiltros + where, insert);
            where = " AND p.value = '3309'";
            this.insertData("XAXIS REVENUE", "7", (String)whereFiltros + where, insert);
            where = " AND p.value = '3310'";
            this.insertData("INVENTORY REVENUE", "8", (String)whereFiltros + where, insert);
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private void insertData(String title, String seqNo, String where, String insert) {
        Object sql = "";
        sql = " SELECT io.ad_client_id, io.ad_org_id, " + this.userID + ", io.c_bpartner_id, " + this.periodID + ",'" + title + "' as title, coalesce((select sum(ol.priceentered * iol.qtyentered) where o.c_currency_id = 142),0) as amtacct, coalesce((select sum(ol.priceentered * iol.qtyentered) where o.c_currency_id = 100),0) as amt, coalesce((select sum(ol.linenetamt) where o.c_currency_id = 142),0) as amtentered, coalesce((select sum(ol.linenetamt) where o.c_currency_id = 100),0) as amount, coalesce((select sum(il.linenetamt) where o.c_currency_id = 142),0) as amtinvoiced, coalesce((select sum(il.linenetamt) where o.c_currency_id = 100),0) as invoicedamt," + seqNo + " as seqno, io.user4_id, io.s_contract_id FROM c_order o JOIN c_orderline ol ON o.c_order_id = ol.c_order_id JOIN m_inoutline iol ON ol.c_orderline_id = iol.c_orderline_id JOIN m_inout io ON iol.m_inout_id = io.m_inout_id JOIN m_product p ON iol.m_product_id = p.m_product_id LEFT JOIN m_product_group pg ON p.m_product_group_id = pg.m_product_group_id LEFT JOIN c_invoiceline il ON ol.c_orderline_id = il.c_orderline_id AND (EXISTS ( SELECT c_invoice.c_invoice_id FROM c_invoice WHERE c_invoice.c_invoice_id = il.c_invoice_id AND (c_invoice.docstatus = ANY (ARRAY['CO'::bpchar, 'IP'::bpchar])))) WHERE io.issotrx = 'Y'::bpchar AND io.docstatus in ('CO','CL') AND o.c_doctypetarget_id <> 1000128" + where + " GROUP BY io.ad_client_id, io.ad_org_id, io.isactive, io.c_bpartner_id, o.c_currency_id, io.user4_id, io.s_contract_id";
        DB.executeUpdateEx(insert + (String)sql, null);
    }
}

