/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class RBillingCustomProd
extends SvrProcess {
    private Timestamp fechaDesde = null;
    private Timestamp fechaHasta = null;
    private int periodID = 0;
    private MPeriod period = null;
    private int partnerID = 0;
    private int selloID = 0;
    private int clientID = 0;
    private int orgID = 0;
    private int userID = 0;
    private static final String TABLA_MOLDE = "UY_Molde_BillingCustomProd";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("C_BPartner_ID") && para[i].getParameter() != null && para[i].getParameter() != null) {
                this.partnerID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_User_ID")) {
                this.userID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_Period_ID")) {
                this.periodID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("User4_ID")) {
                this.selloID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_Client_ID")) {
                this.clientID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (!name.equalsIgnoreCase("AD_Org_ID")) continue;
            this.orgID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
        this.period = new MPeriod(this.getCtx(), this.periodID, this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteInstanciasViejasReporte();
        this.getData();
        return "OK";
    }

    private void deleteInstanciasViejasReporte() {
        Object sql = "";
        try {
            sql = "DELETE FROM UY_Molde_BillingCustomProd WHERE ad_user_id = " + this.userID;
            DB.executeUpdateEx((String)sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private void getData() throws Exception {
        String insert = "";
        String sql = "";
        Object whereFiltros = "";
        String where = "";
        insert = "INSERT INTO UY_Molde_BillingCustomProd (ad_client_id, ad_org_id, ad_user_id, c_bpartner_id,  c_period_id, title, clientvalue, amtacct, amt, seqno, user4_id)";
        try {
            whereFiltros = (String)whereFiltros + " AND io.user4_id = " + this.selloID + " AND io.movementdate >= '" + this.period.getStartDate() + "' and io.movementdate <= '" + this.period.getEndDate() + "'";
            if (this.partnerID > 0) {
                whereFiltros = (String)whereFiltros + " AND io.c_bpartner_id = " + this.partnerID;
            }
            where = " AND pg.m_product_group_parent_id = 1000052";
            this.insertData("Media", "TV / Cable Billings", "1", (String)whereFiltros + where, insert);
            where = " AND pg.m_product_group_parent_id = 1000054";
            this.insertData("Media", "Radio Billings", "2", (String)whereFiltros + where, insert);
            where = " AND pg.m_product_group_parent_id = 1000055";
            this.insertData("Media", "Press Billings", "3", (String)whereFiltros + where, insert);
            where = " AND pg.m_product_group_parent_id = 1000056";
            this.insertData("Media", "OOH Billings", "4", (String)whereFiltros + where, insert);
            where = " AND pg.m_product_group_parent_id = 100";
            this.insertData("Media", "Other Billings", "5", (String)whereFiltros + where, insert);
            where = " AND p.m_product_category_id <> 1000024";
            this.insertData("Media", "Digital Billing (sin Xaxis)", "6", (String)whereFiltros + where, insert);
            where = " AND p.m_product_category_id = 1000024";
            this.insertData("Media", "Xaxis Billings", "7", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id = 1000022 AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Search Billings", "8", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id in (1000014, 1000016) AND p.m_product_class_id <> 1000113 AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Programmatic Display Billings", "9", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id in (1000015, 1000017) AND p.m_product_class_id <> 1000275 AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Programmatic Video Billings", "10", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id = 1000014 AND p.m_product_class_id <> 1000113 AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Google Display Billings", "11", (String)whereFiltros + where, insert);
            where = " AND p.m_product_class_id = 1000099 AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Facebook Billings", "12", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id in (1000023, 1000024) AND p.m_product_class_id <> 1000099 AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Other Social Media Billings", "13", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id = 1000017 AND p.m_product_class_id = 1000275 AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Youtube Billings", "14", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id in (1000010, 1000011, 1000012, 1000013) AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Direct buying Billings", "15", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id = 1000021 AND p.m_product_class_id <> 1000275 AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Online Radio Billings", "16", (String)whereFiltros + where, insert);
            where = " AND p.m_product_group_id in (1000008, 1000009, 1000018, 1000019, 1000020, 1000025) AND p.m_product_category_id <> 1000024";
            this.insertData("Digital", "Others Digital Billing", "17", (String)whereFiltros + where, insert);
            where = " AND p.m_product_category_id = 1000024";
            this.insertData("Digital", "Xaxis Billings", "18", (String)whereFiltros + where, insert);
            where = " AND p.m_product_class_id = 1000376";
            this.insertData("Xaxis", "Xaxis Display", "19", (String)whereFiltros + where, insert);
            where = " AND p.m_product_class_id = 1000270";
            this.insertData("Xaxis", "Xaxis Mobile", "20", (String)whereFiltros + where, insert);
            where = " AND p.m_product_class_id = 1000274";
            this.insertData("Xaxis", "Xaxis Video", "21", (String)whereFiltros + where, insert);
            where = " AND p.m_product_class_id = 1000273";
            this.insertData("Xaxis", "Xaxis Social", "22", (String)whereFiltros + where, insert);
            where = " AND p.m_product_class_id = 1000271";
            this.insertData("Xaxis", "Xaxis Native", "23", (String)whereFiltros + where, insert);
            where = " AND p.m_product_class_id = 1000272";
            this.insertData("Xaxis", "Xaxis Radios Online", "24", (String)whereFiltros + where, insert);
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private void insertData(String title, String clientValue, String seqNo, String where, String insert) {
        Object sql = "";
        sql = " SELECT io.ad_client_id, io.ad_org_id, " + this.userID + ", io.c_bpartner_id, " + this.periodID + ",'" + title + "' as title,'" + clientValue + "' as clientvalue,coalesce((select sum(ol.priceentered * iol.qtyentered) where o.c_currency_id = 142),0) as amtacct,coalesce((select sum(ol.priceentered * iol.qtyentered) where o.c_currency_id = 100),0) as amt," + seqNo + " as seqno, io.user4_id   FROM c_order o     JOIN c_orderline ol ON o.c_order_id = ol.c_order_id     JOIN m_inoutline iol ON ol.c_orderline_id = iol.c_orderline_id     JOIN m_inout io ON iol.m_inout_id = io.m_inout_id     JOIN m_product p ON iol.m_product_id = p.m_product_id     LEFT JOIN m_product_group pg ON p.m_product_group_id = pg.m_product_group_id  WHERE io.issotrx = 'Y'::bpchar AND io.docstatus in ('CO','CL')" + where + "  group by io.ad_client_id, io.ad_org_id, io.isactive, io.c_bpartner_id, o.c_currency_id, io.user4_id";
        DB.executeUpdateEx(insert + (String)sql, null);
    }
}

