/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MInvoice;
import org.compiere.model.Query;
import org.compiere.util.Trx;
import org.openup.core.process.ProcessInvoiceFromTimeExpenseAbstract;

public class ProcessInvoiceFromTimeExpense
extends ProcessInvoiceFromTimeExpenseAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        String sqlQuery = "EXISTS (\n    SELECT 1\n    FROM C_InvoiceLine il\n    JOIN S_TimeExpenseLine tel ON il.C_InvoiceLine_ID=tel.C_InvoiceLine_ID\n    JOIN S_TimeExpense te ON tel.S_TimeExpense_ID=te.S_TimeExpense_ID\n    WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID\n    AND te.UY_InvoiceImport_ID=? \n) AND C_Invoice.DocStatus IN ('DR', 'IP', 'PR')";
        AtomicReference invoices = new AtomicReference();
        Trx.run(trxName -> invoices.set(new Query(this.getCtx(), "C_Invoice", sqlQuery, trxName).setParameters(this.getRecord_ID()).list()));
        AtomicInteger qtyOk = new AtomicInteger();
        int qtyErr = 0;
        if (invoices.get() != null) {
            for (MInvoice mInvoice : (List)invoices.get()) {
                try {
                    Trx.run(trxName -> {
                        mInvoice.set_TrxName(trxName);
                        mInvoice.processIt(this.getDocAction());
                        mInvoice.saveEx();
                        qtyOk.getAndIncrement();
                    });
                }
                catch (Exception e) {
                    this.addLog("@C_Invoice_ID@ " + mInvoice.getDocumentNo() + "(" + mInvoice.get_ID() + ") - Error: " + e.getMessage());
                    ++qtyErr;
                }
            }
        }
        return "@C_Invoice_ID@ | OK " + qtyOk + " | Error " + qtyErr;
    }
}

