/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.adempiere.core.domains.models.I_C_DunningRun;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.eevolution.services.dsl.ProcessBuilder;
import org.openup.core.process.PackDunningEntryPrintAbstract;

public class PackDunningEntryPrint
extends PackDunningEntryPrintAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<Object> dunningEntryIds = new ArrayList();
        String query = "C_DunningRun_ID=?";
        dunningEntryIds = new Query(this.getCtx(), "C_DunningRunEntry", query, this.get_TrxName()).setParameters(this.getRecord_ID()).getIDsAsList();
        File zipPackFile = File.createTempFile("PrintDunningEntryPack", ".zip");
        FileOutputStream fileOutputStream = new FileOutputStream(zipPackFile);
        ZipOutputStream zipPackOutputStream = new ZipOutputStream(fileOutputStream);
        zipPackOutputStream.setMethod(8);
        zipPackOutputStream.setLevel(9);
        zipPackOutputStream.setComment("adempiere");
        int acu = 0;
        for (Integer n : dunningEntryIds) {
            try {
                int len;
                ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(this.getADProcessId()).withTitle(PackDunningEntryPrint.getProcessName()).withParameter("C_DunningRunEntry_ID", n).execute();
                File pdf = processInfo.getPDFReport();
                FileInputStream fis = new FileInputStream(pdf);
                ZipEntry zipEntry = new ZipEntry(pdf.getName());
                zipPackOutputStream.putNextEntry(zipEntry);
                byte[] buffer = new byte[(int)pdf.length()];
                while ((len = fis.read(buffer)) > 0) {
                    zipPackOutputStream.write(buffer, 0, len);
                }
                zipPackOutputStream.closeEntry();
                ++acu;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new AdempiereException(exception);
            }
        }
        zipPackOutputStream.close();
        fileOutputStream.close();
        MAttachment attachment = MAttachment.get(this.getCtx(), I_C_DunningRun.Table_ID, this.getRecord_ID());
        if (attachment == null) {
            attachment = new MAttachment(this.getCtx(), this.getTable_ID(), this.getRecord_ID(), this.get_TrxName());
        }
        attachment.addEntry(zipPackFile);
        attachment.saveEx();
        return "@AD_Attachment_ID@ @Created@ - @Quantity@ @Attachment@ " + acu;
    }
}

