/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Trx;

public class PPost
extends SvrProcess {
    private int p_AD_Table_ID = 0;
    private MAcctSchema[] m_ass = null;
    private int clientID = 0;
    private String whereClause = "";
    private boolean rePost = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Table_ID")) {
                this.p_AD_Table_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Client_ID")) {
                this.clientID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("WhereClause")) {
                this.whereClause = para[i].getParameter().toString();
                continue;
            }
            if (name.equals("IsRePost")) {
                String repost = (String)para[i].getParameter();
                if (repost.equalsIgnoreCase("Y")) {
                    this.rePost = true;
                    continue;
                }
                this.rePost = false;
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.m_ass = MAcctSchema.getClientAcctSchema(this.getCtx(), this.clientID);
        this.post();
        return "OK";
    }

    private void post() {
        String TableName = "";
        try {
            Object sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE t.IsView='N'";
            if (this.p_AD_Table_ID > 0) {
                sql = (String)sql + " AND t.AD_Table_ID=" + this.p_AD_Table_ID;
            }
            sql = (String)sql + " AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND c.IsActive='Y')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(((String)sql).toString(), this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int AD_Table_ID = rs.getInt(1);
                    TableName = rs.getString(2);
                    this.processTable(AD_Table_ID, TableName);
                }
            }
            catch (Exception e) {
                try {
                    throw new AdempiereException(e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTable(int AD_Table_ID, String TableName) {
        try {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String error = "";
            String sql = "SELECT * FROM " + TableName + " WHERE ad_client_ID = " + this.clientID + " " + this.whereClause;
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                boolean ok = true;
                String innerTrxName = Trx.createTrxName("CAP");
                Trx innerTrx = Trx.get(innerTrxName, true);
                String postStatus = "N";
                Doc doc = Doc.get(this.m_ass, AD_Table_ID, rs, innerTrxName);
                try {
                    if (doc == null) {
                        this.log.severe(this.getName() + ": No Doc for " + TableName);
                        ok = false;
                        continue;
                    }
                    if (this.rePost) {
                        error = DocumentEngine.postImmediate(this.getCtx(), this.clientID, AD_Table_ID, doc.get_ID(), true, innerTrxName);
                        ok = error == null;
                        postStatus = doc.getPostStatus();
                        continue;
                    }
                    error = doc.post(false, false);
                    ok = error == null;
                    postStatus = doc.getPostStatus();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, this.getName() + ": " + TableName, e);
                    ok = false;
                }
                finally {
                    if (ok) {
                        innerTrx.commit();
                    } else {
                        innerTrx.rollback();
                        DB.executeUpdateEx("update " + TableName + " set posted = '" + postStatus + "', processing = 'N' where " + doc.get_TableName() + "_ID = " + doc.get_ID(), null);
                    }
                    innerTrx.close();
                    innerTrx = null;
                }
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }
}

