/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MUser;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.openup.core.process.PPaymentFromOutboundAbstract;

public class PPaymentFromOutbound
extends PPaymentFromOutboundAbstract {
    private boolean isNew = false;
    private MPayment payment = null;
    private BigDecimal remaining = Env.ZERO;
    private BigDecimal totalPayAmt = Env.ZERO;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0 && this.getBankAccountId() == 0 && this.getPayDate() == null) {
            throw new AdempiereException("@C_Payment_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        int count = 0;
        for (int invoiceId : this.getSelectionKeys()) {
            MInvoice invoice = new MInvoice(this.getCtx(), invoiceId, this.get_TrxName());
            BigDecimal openAmt = this.getSelectionAsBigDecimal(invoiceId, "INV_OpenAmt");
            BigDecimal payAmt = this.getSelectionAsBigDecimal(invoiceId, "INV_PayAmt");
            BigDecimal discountAmt = this.getSelectionAsBigDecimal(invoiceId, "INV_DiscountAmt");
            String tenderType = this.getSelectionAsString(invoiceId, "INV_TenderType");
            String checkNo = this.getSelectionAsString(invoiceId, "INV_CheckNo");
            this.createPayment(invoice.getC_BPartner_ID(), invoice.getC_Currency_ID(), payAmt, tenderType, checkNo);
            ++count;
            if (discountAmt == null) {
                discountAmt = Env.ZERO;
            }
            MPaymentAllocate invoicePayAllocate = new MPaymentAllocate(this.getCtx(), 0, this.get_TrxName());
            invoicePayAllocate.setC_Payment_ID(this.payment.getC_Payment_ID());
            invoicePayAllocate.setC_Invoice_ID(invoiceId);
            payAmt = payAmt.subtract(discountAmt);
            BigDecimal overUnderAmt = openAmt.subtract(payAmt);
            if (this.remaining.compareTo(Env.ZERO) > 0) {
                this.remaining = this.remaining.subtract(payAmt);
                if (this.remaining.compareTo(Env.ZERO) < 0) {
                    overUnderAmt = payAmt;
                    payAmt = payAmt.add(this.remaining);
                    overUnderAmt = overUnderAmt.subtract(payAmt);
                }
            }
            invoicePayAllocate.setInvoiceAmt(openAmt);
            invoicePayAllocate.setAmount(payAmt);
            invoicePayAllocate.setDiscountAmt(discountAmt);
            invoicePayAllocate.setOverUnderAmt(overUnderAmt);
            invoicePayAllocate.saveEx();
            if (overUnderAmt.compareTo(Env.ZERO) > 0) break;
            this.payment.load(this.get_TrxName());
            if (!this.payment.processIt("CO")) {
                throw new AdempiereException("@Error@ " + this.payment.getProcessMsg());
            }
            this.payment.saveEx();
            this.addLog(this.payment.getC_Payment_ID(), this.payment.getDateTrx(), null, this.payment.getDocumentNo());
        }
        return "@Created@ " + count;
    }

    private void createPayment(int businessPartnerId, int currencyId, BigDecimal payAmt, String tenderType, String checkNo) {
        this.payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        this.payment.setC_BPartner_ID(businessPartnerId);
        this.payment.setC_BankAccount_ID(this.getBankAccountId());
        this.payment.setDateTrx(this.getPayDate());
        this.payment.setDateAcct(this.getDateDoc());
        if (this.getDocTypeTargetId() > 0) {
            this.payment.setC_DocType_ID(this.getDocTypeTargetId());
        }
        this.payment.setPayAmt(payAmt);
        MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
        String userName = "";
        if (user != null) {
            userName = user.getName();
        }
        this.payment.setDescription(Msg.parseTranslation(Env.getCtx(), "@Created@ @from@") + " - " + userName + " - " + DisplayType.getDateFormat(15).format(this.getPayDate()));
        this.payment.setTenderType(tenderType);
        this.payment.setC_Currency_ID(currencyId);
        if (checkNo != null) {
            this.payment.setCheckNo(checkNo);
        }
        this.payment.saveEx();
    }
}

