/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_GL_Journal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MOrg;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PExchangeDifference
extends SvrProcess {
    private int p_C_AcctSchema_ID = 0;
    private int p_C_ConversionTypeReval_ID = 0;
    private int p_C_Currency_ID = 0;
    private Timestamp p_DateReval = null;
    private int p_C_DocTypeReval_ID = 0;
    private int p_AD_Org_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_ConversionTypeReval_ID")) {
                this.p_C_ConversionTypeReval_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("DateReval")) {
                this.p_DateReval = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("C_DocTypeReval_ID")) {
                this.p_C_DocTypeReval_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sql;
        int no;
        this.log.info("C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + ",C_ConversionTypeReval_ID=" + this.p_C_ConversionTypeReval_ID + ",DateReval=" + this.p_DateReval + ",C_Currency_ID=" + this.p_C_Currency_ID + ", C_DocType_ID=" + this.p_C_DocTypeReval_ID);
        if (this.p_DateReval == null) {
            this.p_DateReval = new Timestamp(System.currentTimeMillis());
        }
        if ((no = DB.executeUpdate(sql = "DELETE T_InvoiceGL WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) > 0) {
            this.log.info("Deleted #" + no);
        }
        String dateStr = DB.TO_DATE(this.p_DateReval, true);
        sql = "INSERT INTO T_InvoiceGL (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated,UpdatedBy, AD_PInstance_ID, Fact_Acct_ID, AmtSourceBalance, AmtAcctBalance,  AmtRevalDr, AmtRevalCr, C_DocTypeReval_ID, DateReval, C_ConversionTypeReval_ID,AmtRevalDrDiff, AmtRevalCrDiff, account_id)  SELECT fa.AD_Client_ID, fa.AD_Org_ID, fa.IsActive, fa.Created, fa.CreatedBy, fa.Updated, fa.UpdatedBy, " + this.getAD_PInstance_ID() + ", fa.Fact_Acct_ID, fa.AmtSourceDr-fa.AmtSourceCr, fa.AmtAcctDr-fa.AmtAcctCr, currencyConvert(fa.AmtSourceDr, fa.C_Currency_ID, a.C_Currency_ID, " + dateStr + ", " + this.p_C_ConversionTypeReval_ID + ", fa.AD_Client_ID, fa.AD_Org_ID), currencyConvert(fa.AmtSourceCr, fa.C_Currency_ID, a.C_Currency_ID, " + dateStr + ", " + this.p_C_ConversionTypeReval_ID + ", fa.AD_Client_ID, fa.AD_Org_ID)," + (this.p_C_DocTypeReval_ID == 0 ? "NULL" : String.valueOf(this.p_C_DocTypeReval_ID)) + "," + dateStr + ", " + this.p_C_ConversionTypeReval_ID + ", 0, 0, fa.account_id FROM Fact_Acct fa INNER JOIN C_AcctSchema a ON (fa.C_AcctSchema_ID=a.C_AcctSchema_ID) WHERE EXISTS (SELECT * FROM C_ElementValue ev WHERE ev.C_ElementValue_ID=fa.Account_ID AND ev.IsForeignCurrency = 'Y' AND (ev.AccountType='A' OR ev.AccountType='L' OR ev.AccountType='O')) AND fa.C_AcctSchema_ID = " + this.p_C_AcctSchema_ID + " AND fa.C_Currency_ID <> a.C_Currency_ID AND fa.C_Currency_ID = " + this.p_C_Currency_ID + " AND fa.DateAcct <= " + dateStr + " AND fa.ad_org_id = " + this.p_AD_Org_ID;
        no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 0) {
            this.log.info("Inserted #" + no);
        } else if (CLogMgt.isLevelFiner()) {
            this.log.warning("Inserted #" + no + " - " + sql);
        } else {
            this.log.warning("Inserted #" + no);
        }
        sql = "UPDATE T_InvoiceGL gl SET (AmtRevalDrDiff,AmtRevalCrDiff)=(SELECT gl.AmtRevalDr-fa.AmtAcctDr, gl.AmtRevalCr-fa.AmtAcctCr FROM Fact_Acct fa WHERE gl.Fact_Acct_ID=fa.Fact_Acct_ID) WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID();
        int noT = DB.executeUpdate(sql, this.get_TrxName());
        if (noT > 0) {
            this.log.config("Difference #" + noT);
        }
        String info = this.createGLJournal();
        return "#" + noT + info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createGLJournal() {
        String string;
        CPreparedStatement pstmt;
        ResultSet rs;
        block17: {
            String string2;
            String whereClause = "AD_PInstance_ID=?";
            List list = new Query(this.getCtx(), "T_InvoiceGL", "AD_PInstance_ID=?", this.get_TrxName()).setParameters(this.getAD_PInstance_ID()).setOrderBy("AD_Org_ID").list();
            if (list.size() == 0) {
                return " - No Records found";
            }
            MAcctSchema as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
            MAcctSchemaDefault asDefaultAccts = MAcctSchemaDefault.get(this.getCtx(), this.p_C_AcctSchema_ID);
            MGLCategory cat = MGLCategory.getDefaultSystem(this.getCtx());
            if (cat == null) {
                MDocType docType = MDocType.get(this.getCtx(), this.p_C_DocTypeReval_ID);
                cat = MGLCategory.get(this.getCtx(), docType.getGL_Category_ID());
            }
            MJournalBatch batch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
            batch.setDescription(this.getName());
            batch.setC_DocType_ID(this.p_C_DocTypeReval_ID);
            batch.setDateDoc(new Timestamp(System.currentTimeMillis()));
            batch.setDateAcct(this.p_DateReval);
            batch.setC_Currency_ID(this.p_C_Currency_ID);
            batch.set_ValueOfColumn("IsYearEndClosing", (Object)true);
            if (!batch.save()) {
                return " - Could not create Batch";
            }
            PO journal = null;
            BigDecimal drTotal = Env.ZERO;
            BigDecimal crTotal = Env.ZERO;
            int AD_Org_ID = 0;
            int i = 0;
            rs = null;
            pstmt = null;
            try {
                String sql = "select account_id, sum(amtrevaldrdiff) as dr, sum(amtrevalcrdiff) as cr from t_invoicegl where ad_pinstance_id = " + this.getAD_PInstance_ID() + " and (amtrevaldrdiff <> 0 and amtrevalcrdiff = 0 or amtrevaldrdiff = 0 and amtrevalcrdiff <> 0) group by account_id";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (journal == null) {
                        journal = new MJournal(batch);
                        ((X_GL_Journal)journal).setC_AcctSchema_ID(as.getC_AcctSchema_ID());
                        ((X_GL_Journal)journal).setC_Currency_ID(this.p_C_Currency_ID);
                        ((X_GL_Journal)journal).setC_ConversionType_ID(this.p_C_ConversionTypeReval_ID);
                        MOrg org = MOrg.get(this.getCtx(), Env.getAD_Org_ID(this.getCtx()));
                        ((X_GL_Journal)journal).setDescription(this.getName() + " - " + org.getName());
                        ((X_GL_Journal)journal).setGL_Category_ID(cat.getGL_Category_ID());
                        if (!journal.save()) {
                            string = " - Could not create Journal";
                            break block17;
                        }
                    }
                    int accountID = rs.getInt("Account_ID");
                    MAccount account = new MAccount(this.getCtx(), accountID, this.get_TrxName());
                    MJournalLine line = new MJournalLine((MJournal)journal);
                    line.setLine((i + 1) * 10);
                    line.setDescription("Diferencia de cambio");
                    line.setAccount_ID(accountID);
                    BigDecimal dr = rs.getBigDecimal("dr");
                    BigDecimal cr = rs.getBigDecimal("cr");
                    drTotal = drTotal.add(dr);
                    crTotal = crTotal.add(cr);
                    BigDecimal diff = Env.ZERO;
                    boolean ok = true;
                    if (dr.compareTo(cr) > 0) {
                        diff = dr.subtract(cr);
                        line.setAmtSourceDr(diff);
                        line.setAmtAcctDr(diff);
                        line.setAmtSourceCr(Env.ZERO);
                        line.setAmtAcctCr(Env.ZERO);
                    } else if (cr.compareTo(dr) > 0) {
                        diff = cr.subtract(dr);
                        line.setAmtSourceDr(Env.ZERO);
                        line.setAmtAcctDr(Env.ZERO);
                        line.setAmtSourceCr(diff);
                        line.setAmtAcctCr(diff);
                    } else if (dr.compareTo(cr) == 0) {
                        ok = false;
                    }
                    if (ok) {
                        line.saveEx();
                    }
                    this.createBalancing(asDefaultAccts, (MJournal)journal, dr, cr, AD_Org_ID, (i + 1) * 10);
                }
                DB.executeUpdateEx("update gl_journalline set amtsourcecr = 0, amtsourcedr = 0 where gl_journal_id = " + journal.get_ID(), this.get_TrxName());
                string2 = " - " + batch.getDocumentNo() + " #" + list.size();
            }
            catch (Exception ex) {
                try {
                    throw new AdempiereException(ex.getMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            return string2;
        }
        DB.close(rs, pstmt);
        return string;
    }

    private void createBalancing(MAcctSchemaDefault acctSchemaDefault, MJournal journal, BigDecimal dr, BigDecimal cr, int orgId, int lineNo) {
        MAccount acct;
        MAccount base;
        MJournalLine line;
        if (journal == null) {
            throw new IllegalArgumentException("Jornal is null");
        }
        BigDecimal diff = Env.ZERO;
        if (dr.compareTo(cr) > 0) {
            line = new MJournalLine(journal);
            line.setLine(lineNo + 1);
            base = MAccount.getValidCombination(this.getCtx(), acctSchemaDefault.getUnrealizedGain_Acct(), this.get_TrxName());
            acct = MAccount.get(this.getCtx(), acctSchemaDefault.getAD_Client_ID(), orgId, acctSchemaDefault.getC_AcctSchema_ID(), base.getAccount_ID(), base.getC_SubAcct_ID(), base.getM_Product_ID(), base.getC_BPartner_ID(), base.getAD_OrgTrx_ID(), base.getC_LocFrom_ID(), base.getC_LocTo_ID(), base.getC_SalesRegion_ID(), base.getC_Project_ID(), base.getC_Campaign_ID(), base.getC_Activity_ID(), base.getUser1_ID(), base.getUser2_ID(), base.getUser3_ID(), base.getUser4_ID(), base.getUserElement1_ID(), base.getUserElement2_ID(), this.get_TrxName());
            line.setDescription(Msg.getElement(this.getCtx(), "UnrealizedGain_Acct"));
            line.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
            diff = dr.subtract(cr);
            line.setAmtSourceCr(diff);
            line.setAmtAcctCr(diff);
            line.saveEx();
        }
        if (cr.compareTo(dr) > 0) {
            line = new MJournalLine(journal);
            line.setLine(lineNo + 2);
            base = MAccount.getValidCombination(this.getCtx(), acctSchemaDefault.getUnrealizedLoss_Acct(), this.get_TrxName());
            acct = MAccount.get(this.getCtx(), acctSchemaDefault.getAD_Client_ID(), orgId, acctSchemaDefault.getC_AcctSchema_ID(), base.getAccount_ID(), base.getC_SubAcct_ID(), base.getM_Product_ID(), base.getC_BPartner_ID(), base.getAD_OrgTrx_ID(), base.getC_LocFrom_ID(), base.getC_LocTo_ID(), base.getC_SalesRegion_ID(), base.getC_Project_ID(), base.getC_Campaign_ID(), base.getC_Activity_ID(), base.getUser1_ID(), base.getUser2_ID(), base.getUser3_ID(), base.getUser4_ID(), base.getUserElement1_ID(), base.getUserElement2_ID(), this.get_TrxName());
            line.setDescription(Msg.getElement(this.getCtx(), "UnrealizedLoss_Acct"));
            line.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
            diff = cr.subtract(dr);
            line.setAmtSourceDr(diff);
            line.setAmtAcctDr(diff);
            line.saveEx();
        }
    }
}

