/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.openup.core.process.PDunningInterestAbstract;
import org.spin.investment.model.MFMBatch;
import org.spin.investment.model.MFMRate;
import org.spin.investment.model.MFMTransaction;

public class PDunningInterest
extends PDunningInterestAbstract {
    private StringBuffer result = new StringBuffer();
    private int created = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        int invoiceId = this.getRecord_ID();
        List invoiceList = null;
        Object where = "IsSOTrx = ? AND IsPaid = ? AND AD_Client_ID = ? AND AD_Org_ID = ? AND NOT EXISTS (SELECT 1 FROM FM_Transaction t JOIN FM_Batch b ON t.FM_Batch_ID=b.FM_Batch_ID WHERE t.C_Invoice_ID = C_Invoice_ID AND b.DocStatus NOT IN ('VO','RE')) AND DaysDue > 0";
        if (invoiceId > 0) {
            where = (String)where + " AND C_Invoice_ID = ?";
            invoiceList = new Query(this.getCtx(), "C_Invoice", (String)where, this.get_TrxName()).setClient_ID().setParameters(true, true, this.getClientId(), this.getOrgId(), invoiceId).list();
        } else {
            invoiceList = new Query(this.getCtx(), "C_Invoice", (String)where, this.get_TrxName()).setClient_ID().setParameters(true, true, this.getClientId(), this.getOrgId()).list();
        }
        for (MInvoice invoice : invoiceList) {
            this.processInvoice(invoice);
        }
        return this.getDocumentResult();
    }

    private void processInvoice(MInvoice invoice) {
        MFMBatch batch = new MFMBatch(this.getCtx(), 0, this.get_TrxName());
        batch.setAD_Org_ID(invoice.getAD_Org_ID());
        batch.setC_DocType_ID();
        batch.setDateDoc(new Timestamp(System.currentTimeMillis()));
        batch.setFM_FunctionalSetting_ID(this.getFunctionalSettingId());
        batch.setPosted(true);
        batch.setDescription("Generado por Proceso de C\u00e1lculo de Mora sobre Factura");
        batch.saveEx();
        MBPartner bPartner = (MBPartner)invoice.getC_BPartner();
        MFMRate rate = new MFMRate(this.getCtx(), bPartner.get_ValueAsInt("FM_Rate_ID"), this.get_TrxName());
        if (rate != null && rate.get_ID() > 0) {
            BigDecimal interestRate = rate.getValidRate(new Timestamp(System.currentTimeMillis()));
            int productID = rate.get_ValueAsInt("M_Product_ID");
            if (productID <= 0) {
                throw new AdempiereException("ERROR: No se obtuvo producto para la tasa financiera " + rate.getName());
            }
            MProduct product = new MProduct(this.getCtx(), productID, this.get_TrxName());
            if (interestRate.compareTo(Env.ZERO) > 0) {
                BigDecimal daysDue = new BigDecimal(invoice.get_ValueAsInt("DaysDue"));
                BigDecimal daysMonth = new BigDecimal(30);
                BigDecimal finalRate = daysDue.divide(daysMonth, 2, RoundingMode.HALF_UP).multiply(interestRate);
                BigDecimal capitalAmt = invoice.getGrandTotal();
                BigDecimal dunningAmount = capitalAmt.multiply(finalRate.divide(Env.ONEHUNDRED));
                MFMTransaction transaction = new MFMTransaction(batch);
                transaction.setFM_TransactionType_ID(this.getTransactionTypeId());
                transaction.setC_Invoice_ID(invoice.get_ID());
                transaction.setAmount(dunningAmount);
                transaction.saveEx();
                if (!batch.processIt("CO")) {
                    throw new AdempiereException("@Error@ " + batch.getProcessMsg());
                }
                this.createExpenseReport(batch, invoice, product, daysDue);
            }
        } else {
            throw new AdempiereException("ERROR: El socio de negocio " + bPartner.getName() + " no tiene inter\u00e9s de mora definido");
        }
    }

    private void createExpenseReport(MFMBatch batch, MInvoice invoice, MProduct product, BigDecimal daysDue) {
        MTimeExpense expenseReport = new MTimeExpense(this.getCtx(), 0, this.get_TrxName());
        expenseReport.setAD_Org_ID(batch.getAD_Org_ID());
        expenseReport.setDocStatus("DR");
        expenseReport.setDocAction("CO");
        expenseReport.set_ValueOfColumn("FM_Batch_ID", (Object)batch.get_ID());
        expenseReport.setC_BPartner_ID(invoice.getC_BPartner_ID());
        expenseReport.set_ValueOfColumn("Bill_BPartner_ID", (Object)invoice.getC_BPartner_ID());
        expenseReport.setDateReport(batch.getDateDoc());
        expenseReport.setM_PriceList_ID(invoice.getM_PriceList_ID());
        MOrgInfo orgInfo = MOrgInfo.get(this.getCtx(), batch.getAD_Org_ID(), this.get_TrxName());
        if (orgInfo.getM_Warehouse_ID() > 0) {
            expenseReport.setM_Warehouse_ID(orgInfo.getM_Warehouse_ID());
        }
        if (invoice.get_ValueAsInt("S_Contract_ID") > 0) {
            expenseReport.set_ValueOfColumn("S_Contract_ID", (Object)invoice.get_ValueAsInt("S_Contract_ID"));
        }
        expenseReport.saveEx();
        MTimeExpenseLine expenseLine = new MTimeExpenseLine(this.getCtx(), 0, this.get_TrxName());
        expenseLine.setS_TimeExpense_ID(expenseReport.getS_TimeExpense_ID());
        expenseLine.setDateExpense(expenseReport.getDateReport());
        expenseLine.setC_BPartner_ID(invoice.getC_BPartner_ID());
        expenseLine.setIsTimeReport(false);
        expenseLine.setIsInvoiced(false);
        expenseLine.setDescription("Factura Nro. " + invoice.getDocumentNo() + " - " + daysDue + " d\u00edas de atraso.");
        expenseLine.setC_Currency_ID(invoice.getC_Currency_ID());
        expenseLine.setM_Product_ID(product.get_ID());
        expenseLine.setQty(Env.ONE);
        expenseLine.setExpenseAmt(batch.getTotalAmt());
        if (invoice.getC_Project_ID() > 0) {
            expenseLine.setC_Project_ID(invoice.getC_Project_ID());
        }
        MTaxCategory taxCategory = (MTaxCategory)product.getC_TaxCategory();
        MTax tax = taxCategory.getDefaultTax();
        expenseLine.setC_Tax_ID(tax.get_ID());
        expenseLine.saveEx();
        if (!expenseReport.processIt("CO")) {
            throw new AdempiereException("@Error@ " + expenseReport.getProcessMsg());
        }
        this.addDocumentResult(expenseReport.getDocumentNo());
    }

    private void addDocumentResult(String documentNo) {
        ++this.created;
        if (this.result.length() > 0) {
            this.result.append(", ");
        }
        this.result.append(documentNo);
    }

    private String getDocumentResult() {
        String returnMessage = "@Created@: " + this.created;
        if (this.result.length() > 0) {
            returnMessage = "@Created@: " + this.created + " [" + this.result + "]";
        }
        return returnMessage;
    }
}

