/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCommissionRun;
import org.compiere.util.Trx;
import org.openup.core.process.PCommissionBatchProcessAbstract;

public class PCommissionBatchProcess
extends PCommissionBatchProcessAbstract {
    private int counter = 0;
    private int errCounter = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.getSelectionKeys().stream().forEach(comRunId -> this.process((int)comRunId));
        return "@Updated@=" + this.counter + ", @Errors@=" + this.errCounter;
    }

    private boolean process(int comRunId) {
        try {
            Trx.run(trxName -> {
                MCommissionRun commission = new MCommissionRun(this.getCtx(), comRunId, trxName);
                this.log.info(commission.toString());
                commission.setDocAction(this.getDocAction());
                if (!commission.processIt(this.getDocAction())) {
                    this.addLog(0, null, null, commission.getDocumentNo() + ": @Error@ " + commission.getProcessMsg());
                    throw new AdempiereException(commission.getDocumentNo() + ": @Error@ " + commission.getProcessMsg());
                }
                commission.saveEx();
                this.addLog(0, null, null, commission.getDocumentNo() + ": @OK@");
            });
            ++this.counter;
        }
        catch (Exception e) {
            ++this.errCounter;
            this.addLog(e.getMessage());
            this.log.warning(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

