/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProject;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class OrderPOCreateForProject
extends SvrProcess {
    private Timestamp p_DateFinishProject_From = null;
    private Timestamp p_DateFinishProject_To = null;
    private int p_C_Project_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_Vendor_ID = 0;
    private int p_C_Order_ID = 0;
    private boolean p_IsDropShip = false;
    private Properties ctx = null;
    private String trx = null;

    public OrderPOCreateForProject() {
    }

    public OrderPOCreateForProject(Timestamp p_DateFinishProject_From, Timestamp p_DateFinishProject_To, int p_C_Project_ID, int p_C_BPartner_ID, int p_Vendor_ID, int p_C_Order_ID, boolean p_IsDropShip, Properties ctxIn, String trxIn) {
        this.p_DateFinishProject_From = p_DateFinishProject_From;
        this.p_DateFinishProject_To = p_DateFinishProject_To;
        this.p_C_Project_ID = p_C_Project_ID;
        this.p_C_BPartner_ID = p_C_BPartner_ID;
        this.p_Vendor_ID = p_Vendor_ID;
        this.p_C_Order_ID = p_C_Order_ID;
        this.p_IsDropShip = p_IsDropShip;
        this.ctx = ctxIn;
        this.trx = trxIn;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("DateOrdered")) {
                this.p_DateFinishProject_From = (Timestamp)para[i].getParameter();
                this.p_DateFinishProject_To = (Timestamp)para[i].getParameter_To();
                continue;
            }
            if (name.equals("C_Project_ID")) {
                this.p_C_Project_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("Vendor_ID")) {
                this.p_Vendor_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Order_ID")) {
                this.p_C_Order_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("IsDropShip")) {
                this.p_IsDropShip = ((String)para[i].getParameter()).equals("Y");
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.ctx = this.getCtx();
        if (this.getTable_ID() == MOrder.Table_ID && this.getRecord_ID() > 0) {
            this.p_C_Order_ID = this.getRecord_ID();
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("DateFinishProject=" + this.p_DateFinishProject_From + " - " + this.p_DateFinishProject_To + " - C_Project_ID=" + this.p_C_BPartner_ID + " - C_Project_ID=" + this.p_C_Project_ID + " - Vendor_ID=" + this.p_Vendor_ID + " - IsDropShip=" + this.p_IsDropShip + " - C_Order_ID=" + this.p_C_Order_ID);
        if (!"OK".equalsIgnoreCase(this.verifyDataToProcess())) {
            throw new AdempiereUserError("You need to restrict selection");
        }
        return "Se crearon " + this.executeProcess(this.trx) + " OC's";
    }

    protected String verifyDataToProcess() {
        if (this.p_C_Order_ID == 0 && this.p_DateFinishProject_From == null && this.p_DateFinishProject_To == null && this.p_C_Project_ID == 0 && this.p_Vendor_ID == 0 && this.p_C_BPartner_ID == 0) {
            return "You need to restrict selection";
        }
        return "OK";
    }

    protected int executeProcess(String trx) throws Exception {
        String sql = "";
        Object rs = null;
        Object pstmt = null;
        Object whereClauseProj = " WHERE IsActive = 'Y' AND processed = 'N' ";
        Object whereClauseSO = " WHERE o.IsActive = 'Y' AND o.DocStatus IN ('CO') AND o.IsSoTrx='Y' ";
        if (this.p_C_Project_ID > 0) {
            whereClauseProj = (String)whereClauseProj + " AND C_Project_ID = " + this.p_C_Project_ID;
        }
        if (this.p_DateFinishProject_From != null && this.p_DateFinishProject_To != null) {
            whereClauseProj = (String)whereClauseProj + " AND date_trunc('day',DateFinish) >= date_trunc('day', timestamp '" + this.p_DateFinishProject_From + "')  AND date_trunc('day',DateFinish) <= date_trunc('day', timestamp '" + this.p_DateFinishProject_To + "') ";
        }
        if (this.p_C_BPartner_ID > 0) {
            whereClauseProj = (String)whereClauseProj + " AND C_BPartner_ID = " + this.p_C_BPartner_ID;
            whereClauseSO = (String)whereClauseSO + " AND o.C_BPartner_ID = " + this.p_C_BPartner_ID;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] projectIDs = MProject.getAllIDs("C_Project", ((String)whereClauseProj).replace("WHERE", " "), trx);
        if (projectIDs.length > 0) {
            for (int i = 0; i < projectIDs.length; ++i) {
                list.add(projectIDs[i]);
            }
        }
        ArrayList negocios = (ArrayList)MProject.getInstances(MProject.Table_ID, list, trx);
        int count = 0;
        for (MProject p : negocios) {
            List<String> processList = this.getProcessList(p, (String)whereClauseSO);
            for (int i = 0; i <= processList.size() - 1; ++i) {
                count += this.createPOFromSO(processList.get(i), trx);
            }
        }
        return count;
    }

    protected List<String> getProcessList(MProject p, String whereClauseSO) {
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        String prod_name = "";
        Object lines = "";
        ArrayList<String> list = new ArrayList<String>();
        try {
            String sql = "select l.c_orderline_id, p.name from c_order o join c_orderline l on o.c_order_id = l.c_order_id join m_product p on l.m_product_id = p.m_product_id" + whereClauseSO + " and o.c_project_id = " + p.get_ID() + " order by p.name";
            pstmt = DB.prepareStatement(sql, this.trx);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int lineID = rs.getInt("C_OrderLine_ID");
                String prodName = rs.getString("Name");
                if (!prod_name.equalsIgnoreCase(prodName)) {
                    if (lines != null && !((String)lines).isEmpty()) {
                        list.add((String)lines);
                    }
                    lines = "";
                    prod_name = prodName;
                    lines = (String)lines + lineID;
                    continue;
                }
                lines = (String)lines + "," + lineID;
            }
            if (lines != null && !((String)lines).isEmpty()) {
                list.add((String)lines);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return list;
    }

    protected int createPOFromSO(String lines, String trx) throws Exception {
        int counter = 0;
        String sql = "SELECT MIN(po.C_BPartner_ID), po.M_Product_ID, ol.c_orderline_id, ol.c_order_id, po.pricepo FROM M_Product_PO po INNER JOIN C_OrderLine ol ON (po.M_Product_ID=ol.M_Product_ID) WHERE po.IsCurrentVendor='Y' AND po.IsActive = 'Y' AND po.Discontinued = 'N' AND (ol.Link_OrderLine_ID IS NULL OR ol.Link_OrderLine_ID = 0) " + (this.p_Vendor_ID > 0 ? " AND po.C_BPartner_ID=? " : "") + " AND ol.c_orderline_id IN (" + lines + ") GROUP BY po.M_Product_ID, ol.c_orderline_id, po.pricepo  ORDER BY 1";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        X_C_Order po = null;
        MOrder so = null;
        try {
            pstmt = DB.prepareStatement(sql, trx);
            if (this.p_Vendor_ID != 0) {
                pstmt.setInt(2, this.p_Vendor_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (so == null) {
                    so = new MOrder(Env.getCtx(), rs.getInt("C_Order_ID"), trx);
                }
                int C_BPartner_ID = rs.getInt(1);
                if (po == null || po.getBill_BPartner_ID() != C_BPartner_ID) {
                    po = this.createPOForVendor(rs.getInt(1), so);
                    po.setSalesRep_ID(so.getSalesRep_ID());
                    po.saveEx();
                    this.addLog(0, null, null, po.getDocumentNo());
                    ++counter;
                }
                MOrderLine oLine = new MOrderLine(Env.getCtx(), rs.getInt("C_OrderLine_ID"), trx);
                int M_Product_ID = rs.getInt(2);
                if (oLine.getM_Product_ID() != M_Product_ID || oLine.getLink_OrderLine_ID() != 0) continue;
                MOrderLine poLine = new MOrderLine((MOrder)po);
                poLine.setLink_OrderLine_ID(oLine.getC_OrderLine_ID());
                poLine.setM_Product_ID(oLine.getM_Product_ID());
                poLine.setC_Charge_ID(oLine.getC_Charge_ID());
                poLine.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
                poLine.setC_UOM_ID(oLine.getC_UOM_ID());
                poLine.setQtyEntered(oLine.getQtyEntered());
                poLine.setQtyOrdered(oLine.getQtyOrdered());
                poLine.setDescription(oLine.getDescription());
                poLine.set_ValueOfColumn("FabricSupplier", oLine.get_Value("FabricSupplier"));
                poLine.setPriceCost(oLine.getPriceCost());
                if (oLine.getDatePromised() != null) {
                    String sql2 = "SELECT '" + oLine.getDatePromised() + "'::timestamp - CAST('15 days' AS INTERVAL)";
                    Timestamp date = DB.getSQLValueTSEx(trx, sql2, new Object[0]);
                    poLine.setDatePromised(date);
                }
                poLine.setPrice();
                poLine.saveEx();
                oLine.setLink_OrderLine_ID(poLine.getC_OrderLine_ID());
                oLine.saveEx();
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (counter == 1 && po != null) {
            String update = "update c_order set link_order_id = " + po.get_ID() + " where c_order_id in (select distinct (c_order_id) from c_orderline where c_orderline_id in (" + lines + "))";
            DB.executeUpdateEx(update, trx);
            String sql2 = "select max (o.datepromised) from c_order o inner join c_orderline l on o.c_order_id = l.c_order_id where l.c_orderline_id in (" + lines + ")";
            Timestamp datePromised = DB.getSQLValueTSEx(trx, sql2, new Object[0]);
            String sql3 = "SELECT '" + datePromised + "'::timestamp - CAST('15 days' AS INTERVAL)";
            Timestamp date = DB.getSQLValueTSEx(trx, sql3, new Object[0]);
            update = "update c_order set datepromised = '" + date + "' where c_order_id = " + po.get_ID();
            DB.executeUpdateEx(update, trx);
        }
        return counter;
    }

    public MOrder createPOForVendor(int C_BPartner_ID, MOrder so) {
        MOrder po = new MOrder(this.ctx, 0, so.get_TrxName());
        po.setClientOrg(so.getAD_Client_ID(), so.getAD_Org_ID());
        po.setLink_Order_ID(so.getC_Order_ID());
        po.setIsSOTrx(false);
        po.setC_DocTypeTarget_ID();
        po.setDescription(so.getDescription());
        po.setPOReference(so.getDocumentNo());
        po.setPriorityRule(so.getPriorityRule());
        po.setSalesRep_ID(so.getSalesRep_ID());
        po.setM_Warehouse_ID(so.getM_Warehouse_ID());
        MBPartner vendor = new MBPartner(this.ctx, C_BPartner_ID, so.get_TrxName());
        po.setBPartner(vendor);
        if (this.p_IsDropShip) {
            po.setIsDropShip(this.p_IsDropShip);
            if (so.isDropShip() && so.getDropShip_BPartner_ID() != 0) {
                po.setDropShip_BPartner_ID(so.getDropShip_BPartner_ID());
                po.setDropShip_Location_ID(so.getDropShip_Location_ID());
                po.setDropShip_User_ID(so.getDropShip_User_ID());
            } else {
                po.setDropShip_BPartner_ID(so.getC_BPartner_ID());
                po.setDropShip_Location_ID(so.getC_BPartner_Location_ID());
                po.setDropShip_User_ID(so.getAD_User_ID());
            }
            MOrgInfo orginfo = MOrgInfo.get(this.ctx, po.getAD_Org_ID(), so.get_TrxName());
            if (orginfo.getDropShip_Warehouse_ID() != 0) {
                po.setM_Warehouse_ID(orginfo.getDropShip_Warehouse_ID());
            } else {
                this.log.log(Level.SEVERE, "Must specify drop ship warehouse in org info.");
            }
        }
        po.setC_Activity_ID(so.getC_Activity_ID());
        po.setC_Campaign_ID(so.getC_Campaign_ID());
        po.setC_Project_ID(so.getC_Project_ID());
        po.setUser1_ID(so.getUser1_ID());
        po.setUser2_ID(so.getUser2_ID());
        po.setUser3_ID(so.getUser3_ID());
        po.setUser4_ID(so.getUser4_ID());
        po.saveEx();
        return po;
    }

    private int createLinkedPO(MOrder so) throws Exception {
        this.log.info(so.toString());
        MOrderLine[] soLines = so.getLines(true, null);
        if (soLines == null || soLines.length == 0) {
            this.log.warning("No Lines - " + so);
            return 0;
        }
        int counter = 0;
        String sql = "SELECT MIN(po.C_BPartner_ID), po.M_Product_ID FROM M_Product_PO po INNER JOIN C_OrderLine ol ON (po.M_Product_ID=ol.M_Product_ID) WHERE ol.C_Order_ID=? AND po.IsCurrentVendor='Y' " + (this.p_Vendor_ID > 0 ? " AND po.C_BPartner_ID=? " : "") + "GROUP BY po.M_Product_ID ORDER BY 1";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        X_C_Order po = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, so.getC_Order_ID());
            if (this.p_Vendor_ID != 0) {
                pstmt.setInt(2, this.p_Vendor_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_BPartner_ID = rs.getInt(1);
                if (po == null || po.getBill_BPartner_ID() != C_BPartner_ID) {
                    po = this.createPOForVendor(rs.getInt(1), so);
                    this.addLog(0, null, null, po.getDocumentNo());
                    ++counter;
                }
                int M_Product_ID = rs.getInt(2);
                for (int i = 0; i < soLines.length; ++i) {
                    if (soLines[i].getM_Product_ID() != M_Product_ID) continue;
                    MOrderLine poLine = new MOrderLine((MOrder)po);
                    poLine.setLink_OrderLine_ID(soLines[i].getC_OrderLine_ID());
                    poLine.setM_Product_ID(soLines[i].getM_Product_ID());
                    poLine.setC_Charge_ID(soLines[i].getC_Charge_ID());
                    poLine.setM_AttributeSetInstance_ID(soLines[i].getM_AttributeSetInstance_ID());
                    poLine.setC_UOM_ID(soLines[i].getC_UOM_ID());
                    poLine.setQtyEntered(soLines[i].getQtyEntered());
                    poLine.setQtyOrdered(soLines[i].getQtyOrdered());
                    poLine.setDescription(soLines[i].getDescription());
                    poLine.setDatePromised(soLines[i].getDatePromised());
                    poLine.setPrice();
                    poLine.saveEx();
                    soLines[i].setLink_OrderLine_ID(poLine.getC_OrderLine_ID());
                    soLines[i].saveEx();
                }
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (counter == 1 && po != null) {
            so.setLink_Order_ID(po.getC_Order_ID());
            so.saveEx();
        }
        return counter;
    }
}

