/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import com.eevolution.model.MSContract;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProject;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.openup.core.process.OrderGenFromTimeExpenseAbstract;
import org.openup.core.utils.POGroupingProcessor;

public class OrderGenFromTimeExpense
extends OrderGenFromTimeExpenseAbstract {
    List<MOrder> mOrders;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        AtomicBoolean hasError = new AtomicBoolean(true);
        this.mOrders = new ArrayList<MOrder>();
        Trx.run(trxName -> {
            ArrayList<MTimeExpenseLine> mTimeExpenseLines = new ArrayList<MTimeExpenseLine>();
            for (Integer key : this.getSelectionKeys()) {
                this.addLog("Processing time expense line " + key);
                int timeExpenseLine_ID = this.getSelectionAsInt(key, "ER_RV_S_TimeExpenseToOrder_ID");
                MTimeExpenseLine mTimeExpenseLine2 = new MTimeExpenseLine(this.getCtx(), timeExpenseLine_ID, trxName);
                mTimeExpenseLines.add(mTimeExpenseLine2);
            }
            POGroupingProcessor<MTimeExpenseLine> gp = new POGroupingProcessor<ArrayList<MTimeExpenseLine>>().addPO(mTimeExpenseLines).addCriteria("cBp", mTimeExpenseLine -> mTimeExpenseLine.getS_TimeExpense().getC_BPartner_ID()).addCriteria("currency", mTimeExpenseLine -> mTimeExpenseLine.getC_Currency_ID()).addCriteria("contract", mTimeExpenseLine -> ((MTimeExpense)mTimeExpenseLine.getS_TimeExpense()).get_ValueAsInt("S_Contract_ID")).addCriteria("org", mTimeExpenseLine -> ((MTimeExpense)mTimeExpenseLine.getS_TimeExpense()).getAD_Org_ID()).addCriteria("cli", mTimeExpenseLine -> ((MTimeExpense)mTimeExpenseLine.getS_TimeExpense()).getAD_Client_ID()).addCriteria("priceList", mTimeExpenseLine -> mTimeExpenseLine.getS_TimeExpense().getM_PriceList_ID()).addCriteria("defaultProject", mTimeExpenseLine -> {
                MSContract msContract = new MSContract(this.getCtx(), ((MTimeExpense)mTimeExpenseLine.getS_TimeExpense()).get_ValueAsInt("S_Contract_ID"), trxName);
                MProject mProject = this.getDefaultProject(msContract.get_ID(), trxName);
                if (mProject == null || mProject.get_ID() <= 0) {
                    throw new AdempiereException("Contrato " + msContract.getDocumentNo() + ": Proyecto por Defecto no encontrado");
                }
                return mProject.get_ID();
            });
            gp.processGrupedObjects((params, poList) -> {
                int c_bpartner_id = (Integer)params.get("cBp");
                int c_currency_id = (Integer)params.get("currency");
                MSContract msContract = new MSContract(this.getCtx(), (Integer)params.get("contract"), trxName);
                int ad_org_id = (Integer)params.get("org");
                int ad_client_id = (Integer)params.get("cli");
                int m_pricelist_id = (Integer)params.get("priceList");
                MProject mProject = new MProject(this.getCtx(), (Integer)params.get("defaultProject"), trxName);
                MOrder mOrder = this.getOrder(c_bpartner_id, c_currency_id, ad_org_id, ad_client_id, msContract, m_pricelist_id, mProject, trxName);
                for (MTimeExpenseLine mTimeExpenseLine : poList) {
                    MTimeExpense mTimeExpense = (MTimeExpense)mTimeExpenseLine.getS_TimeExpense();
                    MProduct mProduct = (MProduct)mTimeExpenseLine.getM_Product();
                    MPriceList mPriceList = (MPriceList)mTimeExpense.getM_PriceList();
                    BigDecimal priceListAmt = Env.ZERO;
                    if (mPriceList == null || mPriceList.get_ID() <= 0) {
                        throw new AdempiereException("Lista de precios del contrato no definida");
                    }
                    MPriceListVersion mPriceListVersion = mPriceList.getPriceListVersion(null);
                    if (mPriceListVersion == null || mPriceListVersion.get_ID() <= 0) {
                        throw new AdempiereException("Versi\u00f3n de lista de precios " + mPriceList.getName() + " no encontrada");
                    }
                    MProductPrice[] mProductPrice = mPriceListVersion.getProductPrice(" AND M_Product_ID=" + mProduct.getM_Product_ID());
                    if (mProductPrice.length > 0) {
                        priceListAmt = mProductPrice[0].getPriceList();
                    }
                    mTimeExpense.set_ValueOfColumn("C_Order_ID", (Object)mOrder.get_ID());
                    mTimeExpense.saveEx();
                    MOrderLine mOrderLine = new MOrderLine(mOrder);
                    BigDecimal expenseAmt = mTimeExpenseLine.getExpenseAmt();
                    BigDecimal qty = mTimeExpenseLine.getQty();
                    mOrderLine.setQty(qty);
                    mOrderLine.setQtyEntered(qty);
                    mOrderLine.setPriceActual(expenseAmt);
                    mOrderLine.setPriceEntered(expenseAmt);
                    mOrderLine.setPriceList(priceListAmt);
                    mOrderLine.setProduct(mProduct);
                    mOrderLine.setC_UOM_ID(mProduct.getC_UOM_ID());
                    mOrderLine.setDescription(mTimeExpenseLine.getDescription());
                    mOrderLine.setC_Tax_ID(mTimeExpenseLine.getC_Tax_ID());
                    mOrderLine.setC_Activity_ID(mTimeExpenseLine.getC_Activity_ID());
                    mOrderLine.saveEx();
                    mTimeExpenseLine.setC_OrderLine_ID(mOrderLine.get_ID());
                    mTimeExpenseLine.saveEx();
                }
            });
            hasError.set(false);
        });
        if (!hasError.get() && this.getDocAction() != null && !this.getDocAction().isEmpty()) {
            for (MOrder mOrder : this.mOrders) {
                Trx.run(trxName -> {
                    MOrder o = new MOrder(this.getCtx(), mOrder.get_ID(), trxName);
                    o.setDocAction(this.getDocAction());
                    o.processIt(this.getDocAction());
                    o.saveEx();
                });
            }
        }
        return "@DocProcessed@: " + this.mOrders.size() + " | " + this.mOrders.stream().map(X_C_Order::getDocumentNo).collect(Collectors.joining(", "));
    }

    private MOrder getOrder(int c_bpartner_id, int c_currency_id, int ad_org_id, int ad_client_id, MSContract msContract, int m_pricelist_id, MProject mProject, String trxName) {
        MOrder mOrder = new MOrder(this.getCtx(), 0, trxName);
        mOrder.setDateOrdered(this.getDateInvoiced());
        mOrder.setDateAcct(this.getDateInvoiced());
        mOrder.setClientOrg(ad_client_id, ad_org_id);
        mOrder.setC_Project_ID(mProject.get_ID());
        if (this.getDocTypeTargetId() > 0) {
            mOrder.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
        } else {
            mOrder.setC_DocTypeTarget_ID("ARI");
        }
        mOrder.setC_BPartner_ID(c_bpartner_id);
        try {
            mOrder.setC_BPartner_Location_ID(msContract.getC_BPartner_Location_ID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        mOrder.setSalesRep_ID(this.getAD_User_ID());
        mOrder.setC_Currency_ID(c_currency_id);
        mOrder.setM_PriceList_ID(m_pricelist_id);
        mOrder.set_ValueOfColumn("S_Contract_ID", (Object)msContract.get_ID());
        mOrder.saveEx();
        this.mOrders.add(mOrder);
        return mOrder;
    }

    private MProject getDefaultProject(int s_contract_id, String trxName) {
        String query = "S_Contract_ID=? AND isPred='Y'";
        MProject mProject = (MProject)new Query(this.getCtx(), "C_Project", query, trxName).setParameters(s_contract_id).first();
        return mProject;
    }
}

