/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.spin.model.AgencyValidator;

public class ModificationOrder
extends SvrProcess {
    private int orderID = 0;
    private boolean createSO = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null || !name.equalsIgnoreCase("IsCreateSingleOrder") || para[i].getParameter() == null) continue;
            this.createSO = para[i].getParameterAsBoolean();
        }
    }

    @Override
    protected String doIt() throws Exception {
        Object message = "OK";
        MOrder[] newSO = new MOrder[]{null};
        List<Integer> recordIds = this.getSelectionKeys();
        recordIds.stream().forEach(key -> {
            BigDecimal qtyAbnormal;
            BigDecimal qtyReserved;
            BigDecimal qtyReplace;
            BigDecimal newQtyOrdered;
            BigDecimal newPrice;
            BigDecimal qtyOrdered;
            MOrder po = new MOrder(this.getCtx(), this.getSelectionAsInt((int)key, "OLINE_C_Order_ID"), this.get_TrxName());
            MOrderLine poLine = new MOrderLine(this.getCtx(), (int)key, this.get_TrxName());
            MProduct originalProduct = (MProduct)poLine.getM_Product();
            BigDecimal priceEntered = this.getSelectionAsBigDecimal((int)key, "OLINE_PriceEntered");
            if (priceEntered == null) {
                priceEntered = Env.ZERO;
            }
            if ((qtyOrdered = this.getSelectionAsBigDecimal((int)key, "OLINE_QtyOrdered")) == null) {
                qtyOrdered = Env.ZERO;
            }
            Timestamp newDatePromised = this.getSelectionAsTimestamp((int)key, "OLINE_NewDatePromised");
            Timestamp newEndDate = this.getSelectionAsTimestamp((int)key, "OLINE_NewEndDate");
            int newProductID = this.getSelectionAsInt((int)key, "OLINE_M_Product_ID_2");
            BigDecimal newQty = this.getSelectionAsBigDecimal((int)key, "OLINE_Qty");
            if (newQty == null) {
                newQty = Env.ZERO;
            }
            if ((newPrice = this.getSelectionAsBigDecimal((int)key, "OLINE_PricePO")) == null) {
                newPrice = Env.ZERO;
            }
            if ((newQtyOrdered = this.getSelectionAsBigDecimal((int)key, "OLINE_NewQtyOrdered")) == null) {
                newQtyOrdered = Env.ZERO;
            }
            if ((qtyReplace = this.getSelectionAsBigDecimal((int)key, "OLINE_QtyReplace")) == null) {
                qtyReplace = Env.ZERO;
            }
            if ((qtyReserved = this.getSelectionAsBigDecimal((int)key, "OLINE_QtyReserved")) == null) {
                qtyReserved = Env.ZERO;
            }
            if ((qtyAbnormal = this.getSelectionAsBigDecimal((int)key, "OLINE_QtyAbnormal")) == null) {
                qtyAbnormal = Env.ZERO;
            }
            if (qtyAbnormal.compareTo(Env.ZERO) > 0 && !this.createSO) {
                throw new AdempiereException("ERROR: Se debe marcar el check 'Crear Nueva OV' cuando se ha ingresado una cantidad extra");
            }
            if (qtyReplace.compareTo(qtyReserved) > 0) {
                throw new AdempiereException("ERROR: Cantidad a sustituir no puede ser mayor a la pendiente");
            }
            String sql = "select c_orderline_id from c_orderline where link_orderline_id = " + poLine.get_ID();
            int soLine_id = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            if (soLine_id <= 0) {
                throw new AdempiereException("ERROR: No se encuentra linea de OV asociada a la linea de OC seleccionada");
            }
            MOrderLine soLine = new MOrderLine(this.getCtx(), soLine_id, this.get_TrxName());
            MOrder so = (MOrder)soLine.getC_Order();
            Timestamp today = new Timestamp(System.currentTimeMillis());
            if (qtyAbnormal.compareTo(Env.ZERO) > 0) {
                if (newSO[0] == null) {
                    newSO[0] = this.createSO(so, po);
                }
                MOrderLine line = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
                line.setC_Order_ID(newSO[0].get_ID());
                if (newProductID > 0) {
                    if (newPrice.compareTo(Env.ZERO) <= 0 || newDatePromised == null || newEndDate == null) {
                        throw new AdempiereException("ERROR: Se debe indicar nuevo precio, fecha inicio y fin cuando se ha indicado un nuevo producto");
                    }
                    line.setM_Product_ID(newProductID);
                    line.setOrder(newSO[0]);
                    line.setQtyEntered(qtyAbnormal);
                    line.setQtyOrdered(qtyAbnormal);
                    line.setQtyReserved(qtyAbnormal);
                    line.setC_Tax_ID(soLine.getC_Tax_ID());
                    line.setC_UOM_ID(soLine.getC_UOM_ID());
                    line.setQtyEntered(qtyAbnormal);
                    line.setQtyOrdered(qtyAbnormal);
                    line.setQtyReserved(qtyAbnormal);
                    line.setC_Tax_ID(soLine.getC_Tax_ID());
                    line.setC_UOM_ID(soLine.getC_UOM_ID());
                    line.setPriceEntered(newPrice);
                    line.setPriceActual(newPrice);
                    line.setPriceList(newPrice);
                    line.setPriceLimit(newPrice);
                    line.setDatePromised(newDatePromised);
                    line.set_ValueOfColumn("EndDate", (Object)newEndDate);
                } else {
                    line.setM_Product_ID(soLine.getM_Product_ID());
                    line.setOrder(newSO[0]);
                    line.setQtyEntered(qtyAbnormal);
                    line.setQtyOrdered(qtyAbnormal);
                    line.setQtyReserved(qtyAbnormal);
                    line.setC_Tax_ID(soLine.getC_Tax_ID());
                    line.setC_UOM_ID(soLine.getC_UOM_ID());
                    line.setQtyEntered(qtyAbnormal);
                    line.setQtyOrdered(qtyAbnormal);
                    line.setQtyReserved(qtyAbnormal);
                    line.setC_Tax_ID(soLine.getC_Tax_ID());
                    line.setC_UOM_ID(soLine.getC_UOM_ID());
                    line.setPriceEntered(soLine.getPriceEntered());
                    line.setPriceActual(soLine.getPriceActual());
                    line.setPriceList(soLine.getPriceList());
                    line.setPriceLimit(soLine.getPriceLimit());
                    line.setDatePromised(soLine.getDatePromised());
                    line.set_ValueOfColumn("EnDate", soLine.get_Value("EndDate"));
                }
                line.setC_Activity_ID(soLine.getC_Activity_ID());
                line.setC_Campaign_ID(soLine.getC_Campaign_ID());
                line.setUser1_ID(soLine.getUser1_ID());
                line.setUser2_ID(soLine.getUser2_ID());
                line.setUser3_ID(soLine.getUser3_ID());
                line.set_ValueOfColumn("CUST_MediaType_ID", soLine.get_Value("CUST_MediaType_ID"));
                line.setC_Project_ID(soLine.getC_Project_ID());
                line.setC_ProjectPhase_ID(soLine.getC_ProjectPhase_ID());
                line.setC_ProjectTask_ID(soLine.getC_ProjectTask_ID());
                line.save();
            }
            if (newProductID > 0) {
                if (newQty.compareTo(Env.ZERO) <= 0 || newPrice.compareTo(Env.ZERO) <= 0) throw new AdempiereException("Se debe indicar nuevo precio y cantidad para nuevo producto");
                BigDecimal amtOriginal = qtyReplace.multiply(priceEntered);
                BigDecimal amtNew = newQty.multiply(newPrice);
                if (amtNew.compareTo(amtOriginal) > 0) {
                    throw new AdempiereException("ERROR: Importe de sustituci\u00f3n mayor al importe original ordenado");
                }
                poLine.set_ValueOfColumn("IsCompensated", (Object)true);
                if (qtyReplace.compareTo(Env.ZERO) > 0) {
                    poLine.setQtyOrdered(newQtyOrdered);
                }
                if (newQtyOrdered.compareTo(qtyOrdered) <= 0) {
                    poLine.setQtyLostSales(poLine.getQtyLostSales().add(qtyReplace));
                }
                poLine.setQtyReserved(newQtyOrdered.subtract(poLine.getQtyDelivered()));
                MOrderLine.validateParentComplete = false;
                MOrderLine.calculateTax = true;
                poLine.saveEx();
                soLine.set_ValueOfColumn("IsCompensated", (Object)true);
                if (qtyReplace.compareTo(Env.ZERO) > 0) {
                    soLine.setQtyOrdered(newQtyOrdered);
                }
                if (newQtyOrdered.compareTo(qtyOrdered) <= 0) {
                    soLine.setQtyLostSales(soLine.getQtyLostSales().add(qtyReplace));
                }
                soLine.setQtyReserved(newQtyOrdered.subtract(soLine.getQtyDelivered()));
                MOrderLine.validateParentComplete = false;
                MOrderLine.calculateTax = true;
                soLine.saveEx();
                MOrderLine newPOLine = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
                MOrderLine.validateParentComplete = false;
                MOrderLine.calculateTax = true;
                newPOLine.setC_Order_ID(po.get_ID());
                newPOLine.setC_BPartner_ID(po.getC_BPartner_ID());
                newPOLine.setC_BPartner_Location_ID(po.getC_BPartner_Location_ID());
                newPOLine.setM_Product_ID(newProductID);
                newPOLine.setQtyEntered(newQty);
                newPOLine.setQtyOrdered(newQty);
                newPOLine.setQtyReserved(newQty);
                newPOLine.setC_Tax_ID(poLine.getC_Tax_ID());
                newPOLine.setC_UOM_ID(poLine.getC_UOM_ID());
                newPOLine.setPriceEntered(newPrice);
                newPOLine.setPriceActual(newPrice);
                newPOLine.setPriceList(newPrice);
                newPOLine.setPriceLimit(newPrice);
                if (newDatePromised != null) {
                    newPOLine.setDatePromised(newDatePromised);
                } else {
                    newPOLine.setDatePromised(poLine.getDatePromised());
                }
                if (newEndDate != null) {
                    newPOLine.set_ValueOfColumn("EndDate", (Object)newEndDate);
                } else {
                    newPOLine.set_ValueOfColumn("EndDate", poLine.get_Value("EndDate"));
                }
                newPOLine.setC_Activity_ID(poLine.getC_Activity_ID());
                newPOLine.setC_Campaign_ID(poLine.getC_Campaign_ID());
                newPOLine.setUser1_ID(poLine.getUser1_ID());
                newPOLine.setUser2_ID(poLine.getUser2_ID());
                newPOLine.setUser3_ID(poLine.getUser3_ID());
                newPOLine.set_ValueOfColumn("CUST_MediaType_ID", poLine.get_Value("CUST_MediaType_ID"));
                newPOLine.setC_Project_ID(poLine.getC_Project_ID());
                newPOLine.setC_ProjectPhase_ID(poLine.getC_ProjectPhase_ID());
                newPOLine.setC_ProjectTask_ID(poLine.getC_ProjectTask_ID());
                newPOLine.setProcessed(true);
                newPOLine.set_ValueOfColumn("IsSubstitute", (Object)true);
                BigDecimal qtyInvoicePend = qtyOrdered.subtract(poLine.getQtyInvoiced());
                if (qtyInvoicePend.compareTo(qtyReplace) >= 0) {
                    newPOLine.set_ValueOfColumn("IsNotBillable", (Object)false);
                } else if (qtyInvoicePend.compareTo(qtyReplace) < 0) {
                    newPOLine.set_ValueOfColumn("IsNotBillable", (Object)true);
                }
                String sqlHelp = "SUSTITUYE '" + originalProduct.getName() + "' DE LINEA Nro. " + poLine.getLine() + " POR CANTIDAD " + newQty.setScale(2, RoundingMode.HALF_UP);
                newPOLine.set_ValueOfColumn("Help", (Object)sqlHelp);
                newPOLine.saveEx();
                MOrderLine newSOLine = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
                MOrderLine.validateParentComplete = false;
                MOrderLine.calculateTax = true;
                newSOLine.setC_Order_ID(soLine.getC_Order_ID());
                newSOLine.setC_BPartner_ID(soLine.getC_BPartner_ID());
                newSOLine.setC_BPartner_Location_ID(soLine.getC_BPartner_Location_ID());
                newSOLine.setM_Product_ID(newProductID);
                newSOLine.setQtyEntered(newQty);
                newSOLine.setQtyOrdered(newQty);
                newSOLine.setQtyReserved(newQty);
                newSOLine.setC_Tax_ID(soLine.getC_Tax_ID());
                newSOLine.setC_UOM_ID(soLine.getC_UOM_ID());
                newSOLine.setPriceEntered(newPrice);
                newSOLine.setPriceActual(newPrice);
                newSOLine.setPriceList(newPrice);
                newSOLine.setPriceLimit(newPrice);
                if (newDatePromised != null) {
                    newSOLine.setDatePromised(newDatePromised);
                } else {
                    newSOLine.setDatePromised(soLine.getDatePromised());
                }
                if (newEndDate != null) {
                    newSOLine.set_ValueOfColumn("EndDate", (Object)newEndDate);
                } else {
                    newSOLine.set_ValueOfColumn("EndDate", soLine.get_Value("EndDate"));
                }
                newSOLine.setC_Activity_ID(soLine.getC_Activity_ID());
                newSOLine.setC_Campaign_ID(soLine.getC_Campaign_ID());
                newSOLine.setUser1_ID(soLine.getUser1_ID());
                newSOLine.setUser2_ID(soLine.getUser2_ID());
                newSOLine.setUser3_ID(soLine.getUser3_ID());
                newSOLine.set_ValueOfColumn("CUST_MediaType_ID", soLine.get_Value("CUST_MediaType_ID"));
                newSOLine.setC_Project_ID(soLine.getC_Project_ID());
                newSOLine.setC_ProjectPhase_ID(soLine.getC_ProjectPhase_ID());
                newSOLine.setC_ProjectTask_ID(soLine.getC_ProjectTask_ID());
                newSOLine.setProcessed(true);
                newSOLine.set_ValueOfColumn("IsSubstitute", (Object)true);
                newSOLine.set_ValueOfColumn("Help", (Object)sqlHelp);
                if (qtyInvoicePend.compareTo(qtyReplace) >= 0) {
                    newPOLine.set_ValueOfColumn("IsNotBillable", (Object)false);
                } else if (qtyInvoicePend.compareTo(qtyReplace) < 0) {
                    newPOLine.set_ValueOfColumn("IsNotBillable", (Object)true);
                }
                newSOLine.setLink_OrderLine_ID(newPOLine.get_ID());
                newSOLine.saveEx();
                sql = "update c_order set help = 'ORDEN ACTUALIZADA EL " + today + "' where c_order_id in (" + po.get_ID() + "," + soLine.getC_Order_ID() + ")";
                DB.executeUpdateEx(sql, this.get_TrxName());
            } else if (qtyReplace.compareTo(Env.ZERO) > 0) {
                poLine.set_ValueOfColumn("IsCompensated", (Object)true);
                poLine.setQtyOrdered(newQtyOrdered);
                if (newQtyOrdered.compareTo(qtyOrdered) <= 0) {
                    poLine.setQtyLostSales(poLine.getQtyLostSales().add(qtyReplace));
                }
                if (newDatePromised != null) {
                    poLine.setDatePromised(newDatePromised);
                }
                if (newEndDate != null) {
                    poLine.set_ValueOfColumn("EndDate", (Object)newEndDate);
                }
                poLine.setQtyReserved(newQtyOrdered.subtract(poLine.getQtyDelivered()));
                MOrderLine.validateParentComplete = false;
                MOrderLine.calculateTax = true;
                poLine.saveEx();
                soLine.set_ValueOfColumn("IsCompensated", (Object)true);
                soLine.setQtyOrdered(newQtyOrdered);
                if (newQtyOrdered.compareTo(qtyOrdered) <= 0) {
                    soLine.setQtyLostSales(soLine.getQtyLostSales().add(qtyReplace));
                }
                if (newDatePromised != null) {
                    soLine.setDatePromised(newDatePromised);
                }
                if (newEndDate != null) {
                    soLine.set_ValueOfColumn("EndDate", (Object)newEndDate);
                }
                soLine.setQtyReserved(newQtyOrdered.subtract(soLine.getQtyDelivered()));
                MOrderLine.validateParentComplete = false;
                MOrderLine.calculateTax = true;
                soLine.saveEx();
                sql = "update c_order set help = 'ORDEN ACTUALIZADA EL " + today + "' where c_order_id in (" + po.get_ID() + "," + soLine.getC_Order_ID() + ")";
                DB.executeUpdateEx(sql, this.get_TrxName());
            }
            AgencyValidator.updateCommissionRunForOrder(so);
            AgencyValidator.updateCommissionRunForOrder(po);
        });
        if (newSO[0] != null) {
            message = "Creado: Orden de Venta Nro. " + newSO[0].getDocumentNo();
        }
        return message;
    }

    private MOrder createSO(MOrder so, MOrder po) {
        Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        MBPartner partner = (MBPartner)so.getC_BPartner();
        MOrder newSO = MOrder.copyFrom(so, today, 1000133, true, false, false, false, this.get_TrxName());
        newSO.setAD_Org_ID(so.getAD_Org_ID());
        newSO.setM_Warehouse_ID(so.getM_Warehouse_ID());
        newSO.setBPartner(partner);
        newSO.setDateOrdered(today);
        newSO.setDatePromised(today);
        newSO.setSalesRep_ID(so.getSalesRep_ID());
        newSO.set_ValueOfColumn("Help", (Object)("Esta Orden complementa a la Orden de Compra Nro. " + po.getDocumentNo()));
        newSO.set_ValueOfColumn("IsCustomerApproved", (Object)false);
        newSO.setUser1_ID(so.getUser1_ID());
        newSO.setUser2_ID(so.getUser2_ID());
        newSO.setUser3_ID(so.getUser3_ID());
        newSO.setUser3_ID(so.getUser3_ID());
        newSO.save();
        return newSO;
    }
}

