/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.core.domains.models.I_C_CommissionRun;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.eevolution.services.dsl.ProcessBuilder;
import org.spin.process.CommissionOrderCreateAbstract;

public class MassiveCommissionOrderCreate
extends SvrProcess {
    private int comRun_ID = 0;
    private int org_ID = 0;
    private int commissionType_ID = 0;
    private int docType_ID = 0;
    private int partner_ID = 0;
    private int contract_ID = 0;
    private Timestamp dateDocFrom;
    private Timestamp dateDocTo;
    private Timestamp dateOrdered;
    private boolean isSOTrx = false;
    private String trx = "";
    private String docAction;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("C_CommissionRun_ID") && para[i].getParameter() != null) {
                this.comRun_ID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_CommissionType_ID") && para[i].getParameter() != null) {
                this.commissionType_ID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_Org_ID") && para[i].getParameter() != null) {
                this.org_ID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_DocType_ID") && para[i].getParameter() != null) {
                this.docType_ID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_BPartner_ID") && para[i].getParameter() != null) {
                this.partner_ID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("IsSOTrx")) {
                if (para[i].getParameter() != null) {
                    this.trx = (String)para[i].getParameter();
                }
                if (this.trx.equalsIgnoreCase("Y")) {
                    this.isSOTrx = true;
                }
            }
            if (name.equalsIgnoreCase("DateOrdered") && para[i].getParameter() != null) {
                this.dateOrdered = (Timestamp)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("DocAction") && para[i].getParameter() != null) {
                this.docAction = (String)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("DateDoc")) {
                if (para[i].getParameter() != null) {
                    this.dateDocFrom = (Timestamp)para[i].getParameter();
                }
                this.dateDocTo = (Timestamp)para[i].getParameter_To();
            }
            if (!name.equalsIgnoreCase("S_Contract_ID") || para[i].getParameter() == null) continue;
            this.contract_ID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
    }

    @Override
    protected String doIt() throws Exception {
        String message = "OK";
        if (this.comRun_ID > 0) {
            ProcessBuilder.create(this.getCtx()).process(CommissionOrderCreateAbstract.getProcessId()).withRecordId(I_C_CommissionRun.Table_ID, this.comRun_ID).withParameter("IsSOTrx", this.isSOTrx).withParameter("DateOrdered", this.dateOrdered).withParameter("DocAction", this.docAction).withParameter("C_BPartner_ID", this.partner_ID).withParameter("C_DocType_ID", this.docType_ID).withoutTransactionClose().execute(this.get_TrxName());
        } else {
            ResultSet rs = null;
            CPreparedStatement pstmt = null;
            if (this.org_ID <= 0) {
                throw new AdempiereException("Debe indicar organizaci\u00f3n de c\u00e1lculos de comisiones");
            }
            if (this.dateDocFrom == null || this.dateDocTo == null) {
                throw new AdempiereException("Debe indicar rango de fechas de c\u00e1lculos de comisiones");
            }
            if (this.dateDocFrom.compareTo(this.dateDocTo) > 0) {
                throw new AdempiereException("Fecha inicial de c\u00e1lculos de comisiones no puede ser mayor a la fecha final");
            }
            String sql = "select r.c_commissionrun_id, r.c_order_id from c_commissionrun r join c_commission c on r.c_commission_id = c.c_commission_id where c.c_commissiontype_id = " + this.commissionType_ID + " and r.docstatus in ('CO','CL') and r.grandtotal > 0 and r.ad_org_id = " + this.org_ID + " and r.datedoc between '" + this.dateDocFrom + "' and '" + this.dateDocTo + "'";
            if (this.contract_ID > 0) {
                sql = sql + " and r.s_contract_id = " + this.contract_ID;
            }
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MOrder order;
                boolean ok = false;
                int pOrderID = rs.getInt("c_order_id");
                int comRunID = rs.getInt("c_commissionrun_id");
                ok = pOrderID > 0 ? !(order = new MOrder(this.getCtx(), pOrderID, this.get_TrxName())).getDocStatus().equalsIgnoreCase("CO") && !order.getDocStatus().equalsIgnoreCase("CL") : true;
                if (!ok) continue;
                ProcessBuilder.create(this.getCtx()).process(CommissionOrderCreateAbstract.getProcessId()).withRecordId(I_C_CommissionRun.Table_ID, comRunID).withParameter("IsSOTrx", this.isSOTrx).withParameter("DateOrdered", this.dateOrdered).withParameter("DocAction", this.docAction).withParameter("C_BPartner_ID", this.partner_ID).withParameter("C_DocType_ID", this.docType_ID).withoutTransactionClose().execute(this.get_TrxName());
            }
        }
        return message;
    }
}

