/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MPaySelectionCheckOrg;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.MUYPayReceiptDoc;
import org.openup.core.model.MUYPayReceiptLine;

public class LoadFromPaySelection
extends SvrProcess {
    private MUYPayReceipt receipt = null;
    private MPaySelection selection = null;
    private int selectionID = 0;
    private boolean IsFromOtherOrg = false;
    private Hashtable<Integer, Integer> hash = new Hashtable();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("C_PaySelection_ID")) {
                if (para[i].getParameter() == null) continue;
                this.selectionID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (!name.equalsIgnoreCase("IsFromOtherOrg") || para[i].getParameter() == null) continue;
            this.IsFromOtherOrg = para[i].getParameterAsBoolean();
        }
    }

    @Override
    protected String doIt() throws Exception {
        Object sql = "";
        if (this.getRecord_ID() == 0) {
            return "";
        }
        this.receipt = new MUYPayReceipt(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        this.selection = new MPaySelection(this.getCtx(), this.selectionID, this.get_TrxName());
        if (this.receipt.getC_Currency_ID() != this.selection.getC_Currency_ID()) {
            this.receipt.setC_Currency_ID(this.selection.getC_Currency_ID());
            this.receipt.saveEx();
        }
        this.loadDocuments();
        this.loadPayments();
        this.loadAssignments();
        sql = "update c_payment set isdelivered = 'Y' where c_payment_id in (select c_payment_id from uy_payreceiptline where uy_payreceipt_id = " + this.receipt.get_ID() + ")";
        DB.executeUpdateEx((String)sql, this.get_TrxName());
        this.receipt.setDocStatus("DR");
        this.receipt.setDocAction("CO");
        this.receipt.set_ValueOfColumn("C_PaySelection_ID", (Object)this.selection.get_ID());
        this.receipt.setDescription("GENERADO DESDE SELECCION DE PAGO N\u00b0 " + this.selection.getDocumentNo());
        this.receipt.saveEx();
        return "OK";
    }

    private void loadDocuments() {
        List<MPaySelectionLine> paySelectionLines = this.selection.getLines(null, null);
        for (MPaySelectionLine line : paySelectionLines) {
            BigDecimal multiplier = Env.ONE;
            MInvoice inv = (MInvoice)line.getC_Invoice();
            if (inv.isSOTrx()) {
                multiplier = multiplier.negate();
            }
            MUYPayReceiptDoc doc = new MUYPayReceiptDoc(this.getCtx(), 0, this.get_TrxName());
            doc.setUY_PayReceipt_ID(this.receipt.get_ID());
            doc.setC_BPartner_ID(line.getC_BPartner_ID());
            doc.setC_Invoice_ID(inv.get_ID());
            doc.setPaymentRule(line.getPaymentRule());
            doc.setInvoiceAmt(inv.getGrandTotal().multiply(multiplier));
            doc.setAmtSource(inv.getGrandTotal().multiply(multiplier));
            doc.setOpenAmt(inv.getGrandTotal().multiply(multiplier));
            doc.setPayAmt(line.getPayAmt().multiply(multiplier));
            doc.saveEx();
            this.hash.put(inv.get_ID(), doc.get_ID());
        }
    }

    private void loadPayments() {
        Object sql = "";
        MPayment pay = null;
        String tableName = "c_payselectioncheck";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int count = 0;
        try {
            if (this.IsFromOtherOrg) {
                tableName = "c_payselectioncheckorg";
            }
            sql = "select " + tableName + "_id from " + tableName + " where c_payment_id is not null and c_payselection_id = " + this.selectionID;
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MUYPayReceiptLine line = null;
                if (this.IsFromOtherOrg) {
                    MPaySelectionCheckOrg pso = new MPaySelectionCheckOrg(this.getCtx(), rs.getInt("C_PaySelectionCheckOrg_ID"), this.get_TrxName());
                    pay = (MPayment)pso.getC_Payment();
                } else {
                    MPaySelectionCheck ps = new MPaySelectionCheck(this.getCtx(), rs.getInt("C_PaySelectionCheck_ID"), this.get_TrxName());
                    pay = (MPayment)ps.getC_Payment();
                }
                line = new MUYPayReceiptLine(this.getCtx(), 0, this.get_TrxName());
                line.setUY_PayReceipt_ID(this.receipt.get_ID());
                line.setC_BPartner_ID(pay.getC_BPartner_ID());
                line.setC_Payment_ID(pay.getC_Payment_ID());
                line.setPayAmt(pay.getPayAmt());
                line.setC_BankAccount_ID(pay.getC_BankAccount_ID());
                line.saveEx();
                ++count;
            }
            if (count == 0) {
                throw new AdempiereException("ERROR: No se encontraron pagos generados en la selecci\u00f3n de pago '" + this.selection.getDocumentNo() + "'");
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, (String)sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void loadAssignments() {
        Object sql = "";
        MInvoice inv = null;
        MPayment pay = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            sql = "select c_allocationhdr_id from c_allocationhdr where docstatus in ('CO','CL') and c_payselection_id = " + this.selectionID;
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MAllocationHdr allocation = new MAllocationHdr(this.getCtx(), rs.getInt("c_allocationhdr_id"), this.get_TrxName());
                List<MAllocationLine> allocationLines = Arrays.asList(allocation.getLines(true));
                for (MAllocationLine aLine : allocationLines) {
                    if (aLine.getC_Invoice_ID() > 0) {
                        inv = (MInvoice)aLine.getC_Invoice();
                        this.processInvoice(aLine, inv);
                    }
                    if (aLine.getC_Payment_ID() <= 0) continue;
                    pay = (MPayment)aLine.getC_Payment();
                    this.processPayment(aLine, pay);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, (String)sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void processInvoice(MAllocationLine aLine, MInvoice inv) {
        boolean type;
        MUYPayReceiptDoc doc = null;
        MDocType docType = (MDocType)inv.getC_DocTypeTarget();
        String baseType = docType.getDocBaseType();
        boolean bl = type = baseType.equalsIgnoreCase("APC") || baseType.equalsIgnoreCase("API") || baseType.equalsIgnoreCase("ARI");
        if (this.hash.containsKey(inv.get_ID())) {
            BigDecimal total;
            doc = new MUYPayReceiptDoc(this.getCtx(), this.hash.get(inv.get_ID()), this.get_TrxName());
            BigDecimal amtAllocInvoice = aLine.getAmount();
            if (type) {
                amtAllocInvoice = amtAllocInvoice.negate();
            }
            if ((total = doc.getPayAmt().add(amtAllocInvoice)).compareTo(inv.getGrandTotal()) <= 0) {
                doc.setPayAmt(total);
                doc.saveEx();
            }
        } else {
            BigDecimal multiplier = Env.ONE;
            if (type) {
                multiplier = multiplier.negate();
            }
            doc = new MUYPayReceiptDoc(this.getCtx(), 0, this.get_TrxName());
            doc.setUY_PayReceipt_ID(this.receipt.get_ID());
            doc.setC_BPartner_ID(aLine.getC_BPartner_ID());
            doc.setC_Invoice_ID(inv.get_ID());
            doc.setInvoiceAmt(inv.getGrandTotal().multiply(multiplier));
            doc.setAmtSource(inv.getGrandTotal().multiply(multiplier));
            doc.setOpenAmt(inv.getGrandTotal().multiply(multiplier));
            doc.setPayAmt(aLine.getAmount().multiply(multiplier));
            doc.setPaymentRule(inv.getPaymentRule());
            doc.saveEx();
        }
    }

    private void processPayment(MAllocationLine aLine, MPayment pay) {
        MUYPayReceiptLine line = null;
        line = new MUYPayReceiptLine(this.getCtx(), 0, this.get_TrxName());
        line.setUY_PayReceipt_ID(this.receipt.get_ID());
        line.setC_BPartner_ID(aLine.getC_BPartner_ID());
        line.setC_Payment_ID(pay.get_ID());
        line.setPayAmt(aLine.getAmount().negate());
        line.setC_BankAccount_ID(pay.getC_BankAccount_ID());
        line.saveEx();
    }
}

