/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPO;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MUOM;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MProductAuxiliar;
import org.openup.core.model.MUYCustomProduct;
import org.openup.core.model.MUYCustomProductLine;
import org.openup.core.utils.model.MProduct;

public class ImportProject
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private boolean m_deleteOldImported = false;
    private String m_Version = "";
    private boolean m_Manual = false;
    private String m_IsManual = "N";
    private int m_CurrencyID = 0;
    private int m_priceListID = 0;
    private int no = 0;
    private int noInsertPY = 0;
    private int noInsertPR = 0;

    @Override
    public String getImportTableName() {
        return null;
    }

    @Override
    public String getWhereClause() {
        return " AND AD_Client_ID = " + this.m_AD_Client_ID;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_deleteOldImported = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("Version")) {
                this.m_Version = para[i].getParameter().toString().toUpperCase();
                continue;
            }
            if (name.equals("IsManual")) {
                this.m_Manual = para[i].getParameterAsBoolean();
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.m_CurrencyID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_PriceList_ID")) {
                this.m_priceListID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (new MPriceList(this.getCtx(), this.m_priceListID, null).getC_Currency_ID() != this.m_CurrencyID) {
            throw new AdempiereException("La lista de precios no es de la moneda seleccionada");
        }
        if (!new MPriceList(this.getCtx(), this.m_priceListID, null).isSOPriceList()) {
            throw new AdempiereException("La lista de precios no es de venta");
        }
        if (this.m_Version.equalsIgnoreCase("")) {
            throw new AdempiereException("Debe indicar Version para esta carga");
        }
        if (this.m_Manual) {
            this.m_IsManual = "Y";
        }
    }

    @Override
    protected String doIt() throws Exception {
        int no;
        StringBuffer sql;
        String clientCheck = this.getWhereClause();
        String manual = "N";
        if (this.m_deleteOldImported) {
            sql = new StringBuffer("DELETE I_ProductAuxiliar WHERE I_IsImported='Y' AND IsActive='Y' AND Processed = 'Y' ").append(clientCheck);
            no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Impored =" + no);
        }
        sql = new StringBuffer("UPDATE I_ProductAuxiliar SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N', Version = '" + this.m_Version + "' WHERE  IsActive = 'Y' AND Processed = 'N' AND (I_IsImported<>'Y' OR I_IsImported IS NULL) AND IsManual = '" + this.m_IsManual + "'");
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Reset=" + no);
        if (this.m_Manual) {
            this.validateDataManual(clientCheck);
        } else {
            sql = new StringBuffer("DELETE I_ProductAuxiliar WHERE (style is null or style = '') and version = '" + this.m_Version + "' AND IsManual = '" + this.m_IsManual + "'").append(clientCheck);
            no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            this.validateDataNoManual(clientCheck);
        }
        this.setObjectID(clientCheck);
        this.processData(clientCheck);
        return "";
    }

    private void validateDataManual(String clientCheck) {
        this.validateProduct(clientCheck);
        this.validateAmount(clientCheck);
        this.validateTotalAmount(clientCheck);
        this.validateDatePromised(clientCheck);
        this.validateTotalQty(clientCheck);
        this.validateBrand(clientCheck);
        this.validateSeason(clientCheck);
        this.validateFreightCategory(clientCheck);
        this.validatePacking(clientCheck);
    }

    private void validateDataNoManual(String clientCheck) {
        this.validateModelSource(clientCheck);
        this.validateAgent(clientCheck);
        this.validateCountry(clientCheck);
        this.validateProduct(clientCheck);
        this.validateBrand(clientCheck);
        this.validateCategory(clientCheck);
        this.validateFabricType(clientCheck);
        this.validateComposition(clientCheck);
        this.validateFabric(clientCheck);
        this.validateColor(clientCheck);
        this.validatePacking(clientCheck);
        this.validateAmount(clientCheck);
        this.validateTotalAmount(clientCheck);
        this.validateDatePromised(clientCheck);
        this.validateTotalQty(clientCheck);
        this.validateSizeRatio(clientCheck);
        this.validateCustomer(clientCheck);
    }

    private void validateModelSource(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Modelo Origen vacio' WHERE (modelsource IS NULL OR modelsource = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version =  '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateAgent(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Agente de Cuenta vacio' WHERE (agentvalue IS NULL OR agentvalue = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version =  '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateCountry(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Pais vacio' WHERE (countryname IS NULL OR countryname = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version =  '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateBrand(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Marca vacio' WHERE (brand IS NULL OR brand = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version =  '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateSeason(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Temporada vacio' WHERE c_campaign_id IS NULL AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version =  '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateFreightCategory(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Categoria de Flete vacio' WHERE m_freightcategory_id IS NULL AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version =  '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateCategory(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Categoria vacio' WHERE (category IS NULL OR countryname = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateFabricType(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Tipo Tela vacio' WHERE (fabrictype IS NULL OR fabrictype = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateComposition(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Composicion vacio' WHERE (composition IS NULL OR composition = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateFabric(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Tela vacio' WHERE (colorfabric IS NULL OR colorfabric = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateColor(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Color de Tela vacio' WHERE (colortype IS NULL OR colortype = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validatePacking(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Embalaje vacio' WHERE (packing IS NULL OR packing = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateProduct(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Producto vacio' WHERE (style IS NULL OR style = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateAmount(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Precio Prenda invalido' WHERE (unitprice IS NULL OR unitprice <= 0) AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateTotalAmount(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Precio Total invalido' WHERE (saleprice IS NULL OR saleprice <= 0) AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateDatePromised(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Fecha Entrega Prometida vacio' WHERE deliverytime_promised IS NULL AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateTotalQty(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Cantidad Total invalido' WHERE (totalqty IS NULL OR totalqty <= 0) AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateSizeRatio(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Size Ratio vacio' WHERE (sizeratio IS NULL OR sizeratio = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void validateCustomer(String clientCheck) {
        StringBuffer sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Cliente vacio' WHERE (valueclient IS NULL OR valueclient = '') AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND I_IsImported<>'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void setObjectID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("select count(I_ProductAuxiliar_ID) FROM I_ProductAuxiliar WHERE I_IsImported='E' AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.getSQLValueEx(this.get_TrxName(), sql.toString(), new Object[0]);
        if (this.no > 0 && !this.m_Manual) {
            this.addLog(0, null, new BigDecimal(this.no), "Errores");
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', Updated=SysDate WHERE I_IsImported<>'Y' AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND Version = '" + this.m_Version + "' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            this.addLog(0, null, new BigDecimal(this.noInsertPY), "Negocios importados");
            this.addLog(0, null, new BigDecimal(this.noInsertPR), "Productos importados");
        } else {
            if (!this.m_Manual) {
                this.updateCountryName(clientCheck);
                this.setObjectIDNoManual(clientCheck);
            }
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Usuario para el Agente de Cuentas' where ad_user_id IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Tela de Producto' where fabric IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Color de Tela 'where m_parttype_id IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Grupo de Producto para la Categoria' where m_product_group_id IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Clasificacion de Producto para el Tipo Tela' where m_product_classification_id IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Clasificacion de Producto para la Composicion' where m_product_classification2_id IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No existe relacion entre Tipo Tela y Composicion' WHERE not exists (select m_product_classification_id from m_product_classification pc where pc.m_product_classification_id = i.m_product_classification2_id and pc.m_classification_parent_ID = i.m_product_classification_id) AND i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Size Ratio' where m_attribute_id IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            if (this.m_Manual) {
                sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Multiples temporadas asignadas al mismo cliente' WHERE c_bpartner_id in (select c_bpartner_id from I_productauxiliar where version = '" + this.m_Version + "' group by c_bpartner_id having count(distinct(c_campaign_id))>1) AND IsActive = 'Y' AND IsManual = 'Y' AND I_IsImported <> 'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
                this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - Multiples categorias de flete asignadas al mismo cliente y fecha prometida' WHERE c_bpartner_id in (select c_bpartner_id from I_productauxiliar where version = '" + this.m_Version + "' group by c_bpartner_id, deliverytime_promised having count(distinct(m_freightcategory_id))>1) AND IsActive = 'Y' AND IsManual = 'Y' AND I_IsImported <> 'Y' AND Version = '" + this.m_Version + "' ").append(clientCheck);
                this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                sql = new StringBuffer("UPDATE i_productauxiliar i SET sizeratio = a.name from m_attribute a WHERE i.m_attribute_id = a.m_attribute_id AND i.ismanual = 'Y' AND i.version = '" + this.m_Version + "'");
                DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            }
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Cliente' where c_bpartner_id IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        }
    }

    private void updateCountryName(String clientCheck) {
        Object sql = "";
        sql = "UPDATE I_ProductAuxiliar SET countryname = upper(trim(countryname)) where I_IsImported <> 'Y'  AND IsActive = 'Y' " + clientCheck;
        DB.executeUpdateEx((String)sql, this.get_TrxName());
        sql = "UPDATE I_ProductAuxiliar SET countryname = removertildes(countryname) where I_IsImported <> 'Y' AND IsActive = 'Y' " + clientCheck;
        DB.executeUpdateEx((String)sql, this.get_TrxName());
    }

    private void setObjectIDNoManual(String clientCheck) {
        this.setCountryID(clientCheck);
        this.setAgentID(clientCheck);
        this.setColorID(clientCheck);
        this.setCategoryID(clientCheck);
        this.setFabricTypeID(clientCheck);
        this.setCompositionID(clientCheck);
        this.setRatioID(clientCheck);
        this.setCustomerID(clientCheck);
    }

    private void setCountryID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET c_country_id = (select c_country_id from c_country c where upper(trim(c.name)) = upper(trim(i.countryname))) where i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||' - No se obtuvo Pais' where c_country_id IS NULL AND I_IsImported <> 'Y' AND Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void setAgentID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET ad_user_id = (select ad_user_id from ad_user u where upper(trim(u.value)) = upper(trim(i.agentvalue))) where i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void setColorID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET m_parttype_id = (select m_parttype_id from m_parttype p where upper(trim(p.name)) = upper(trim(i.colortype))) where i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void setCategoryID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET m_product_group_id = (select m_product_group_id from m_product_group g where upper(trim(g.value)) = upper(trim(i.category))) where i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void setFabricTypeID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET m_product_classification_id = (select m_product_classification_id from m_product_classification c where upper(trim(c.value)) = upper(trim(i.fabrictype))) where i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void setCompositionID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET m_product_classification2_id = (select m_product_classification_id from m_product_classification c where c.M_Classification_Parent_ID = (select m_product_classification_id from m_product_classification c where upper(trim(c.value)) = upper(trim(i.fabrictype))) AND upper(trim(c.value)) = upper(trim(i.composition))) where i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void setRatioID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET m_attribute_id = (select m_attribute_id from m_attribute a where upper(trim(a.name)) = upper(trim(i.sizeratio))) where i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    private void setCustomerID(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar i SET c_bpartner_id = (select c_bpartner_id from c_bpartner p where upper(trim(p.value)) = upper(trim(i.valueclient)) and p.iscustomer = 'Y') where i.I_IsImported <> 'Y' AND i.Processed = 'N' AND IsManual = '" + this.m_IsManual + "' AND i.IsActive = 'Y' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processData(String clientCheck) {
        StringBuffer sql = null;
        sql = new StringBuffer("SELECT count(I_ProductAuxiliar_ID) FROM I_ProductAuxiliar WHERE I_IsImported='E' AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND Version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.getSQLValueEx(this.get_TrxName(), sql.toString(), new Object[0]);
        if (this.no > 0) {
            this.addLog(0, null, new BigDecimal(this.no), "Errores");
            this.addLog(0, null, new BigDecimal(this.noInsertPY), "Negocios importados");
            this.addLog(0, null, new BigDecimal(this.noInsertPR), "Productos importados");
            sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y' AND IsActive = 'Y' AND IsManual = '" + this.m_IsManual + "' AND Version = '" + this.m_Version + "' ").append(clientCheck);
            this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            return;
        }
        sql = new StringBuffer("SELECT c_bpartner_id FROM I_ProductAuxiliar WHERE I_IsImported = 'N' AND IsActive ='Y' AND Processed ='N' AND IsManual = '" + this.m_IsManual + "' AND Version ='" + this.m_Version + "' " + clientCheck + " group by c_bpartner_id ");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DB.executeUpdate("DROP TABLE IF EXISTS aux_project", this.get_TrxName());
                String sql2 = "SELECT * INTO aux_project FROM i_productauxiliar WHERE I_IsImported = 'N' AND IsActive = 'Y' AND Processed ='N' AND IsManual = '" + this.m_IsManual + "' AND Version ='" + this.m_Version + "' " + clientCheck + " AND c_bpartner_id = " + rs.getInt("c_bpartner_id");
                DB.executeUpdateEx(sql2, this.get_TrxName());
                this.processPartner(clientCheck);
            }
        }
        catch (Exception e) {
            try {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y' AND IsActive = 'Y' AND Processed='N' AND IsManual = '" + this.m_IsManual + "' AND version = '" + this.m_Version + "' ").append(clientCheck);
                this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                this.addLog(0, null, new BigDecimal(this.no), "Errores");
                this.addLog(0, null, new BigDecimal(this.noInsertPY), "Negocios importados");
                this.addLog(0, null, new BigDecimal(this.noInsertPR), "Productos importados");
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuffer("UPDATE I_ProductAuxiliar SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y' AND IsActive = 'Y' AND Processed='N' AND IsManual = '" + this.m_IsManual + "' AND version = '" + this.m_Version + "' ").append(clientCheck);
        this.no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(this.no), "Errores");
        this.addLog(0, null, new BigDecimal(this.noInsertPY), "Negocios importados");
        this.addLog(0, null, new BigDecimal(this.noInsertPR), "Productos importados");
    }

    private void processPartner(String clientCheck) {
        Object sql = "";
        Object sql2 = "";
        MProject pr = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String product_id = "";
        int prod_id = 0;
        int proj_id = 0;
        sql = "select i_productauxiliar_id from aux_project where version = '" + this.m_Version + "' AND IsManual = '" + this.m_IsManual + "' " + clientCheck + " order by style,brand,M_Product_Classification_ID,M_Product_Classification2_ID,M_Product_Class_ID,M_Attribute_ID,M_PartType_ID ";
        try {
            pstmt = DB.prepareStatement(((String)sql).toString(), this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                org.compiere.model.MProduct prod;
                MProductAuxiliar aux = new MProductAuxiliar(this.getCtx(), rs.getInt("i_productauxiliar_id"), this.get_TrxName());
                MBPartner partner = (MBPartner)aux.getC_BPartner();
                if (rs.isFirst()) {
                    pr = this.createProject(aux, partner);
                    proj_id = pr.get_ID();
                }
                Timestamp actualdtp = aux.getDeliveryTime_Promised();
                Timestamp dateFinish = pr.getDateFinish();
                if (dateFinish == null || actualdtp != null && dateFinish.compareTo(actualdtp) < 0) {
                    pr.setDateFinish(actualdtp);
                    pr.saveEx();
                }
                if ((prod = MProduct.forNameAndPartType(this.getCtx(), aux.getStyle(), aux.getBrand(), aux.getM_Product_Classification_ID(), aux.getM_Product_Classification2_ID(), aux.getM_Attribute_ID(), aux.getM_PartType_ID(), this.get_TrxName())) == null) {
                    prod = new org.compiere.model.MProduct(this.getCtx(), 0, this.get_TrxName());
                    prod.setName(aux.getStyle().toUpperCase().trim());
                    sql2 = "select m_product_category_id from m_product_category where isdefault = 'Y'";
                    int catID = DB.getSQLValueEx(this.get_TrxName(), (String)sql2, new Object[0]);
                    if (catID > 0) {
                        prod.setM_Product_Category_ID(catID);
                    }
                    if (aux.getfabric() != null) {
                        prod.set_ValueOfColumn("fabric", (Object)aux.getfabric().trim());
                    }
                    prod.setM_Product_Group_ID(aux.getM_Product_Group_ID());
                    prod.setM_Product_Classification_ID(aux.getM_Product_Classification2_ID());
                    if (aux.getBrand() != null && !aux.getBrand().equalsIgnoreCase("")) {
                        prod.setClassification(aux.getBrand().toUpperCase().trim());
                    }
                    sql2 = "select c_taxcategory_id from c_taxcategory where isdefault = 'Y'";
                    int taxID = DB.getSQLValueEx(this.get_TrxName(), (String)sql2, new Object[0]);
                    if (taxID > 0) {
                        prod.setC_TaxCategory_ID(taxID);
                    }
                    prod.setC_UOM_ID(MUOM.getDefault_UOM_ID(this.getCtx()));
                    prod.setProductType("I");
                    prod.setM_PartType_ID(aux.getM_PartType_ID());
                    prod.setGroup1(aux.getModelSource());
                    prod.setM_FreightCategory_ID(aux.getM_FreightCategory_ID());
                    sql2 = "select s.m_attributeset_id from m_attributeset s inner join m_attributeuse u on s.m_attributeset_id = u.m_attributeset_id where u.m_attribute_id = " + aux.getM_Attribute_ID();
                    int atrSetID = DB.getSQLValueEx(this.get_TrxName(), (String)sql2, new Object[0]);
                    if (atrSetID > 0) {
                        prod.setM_AttributeSet_ID(atrSetID);
                    }
                    prod.setVersionNo(aux.getVersion());
                    prod.setIsPurchased(false);
                    prod.setIsSold(true);
                    prod.saveEx();
                    MProductPrice ppv = new MProductPrice(this.getCtx(), pr.getM_PriceList_Version_ID(), prod.get_ID(), aux.getUnitPrice(), aux.getUnitPrice(), aux.getUnitPrice(), this.get_TrxName());
                    ppv.saveEx();
                }
                aux.setM_Product_ID(prod.get_ID());
                aux.setC_Project_ID(pr.get_ID());
                ++this.noInsertPR;
                aux.saveEx();
                if (prod_id == 0 || prod_id != prod.get_ID()) {
                    prod_id = prod.get_ID();
                    this.createProjetLine(pr, prod, actualdtp);
                }
                this.createCustomProduct(aux, prod, pr);
                sql = "UPDATE I_ProductAuxiliar SET I_IsImported = 'Y', processed = 'Y', isvalid = 'Y', CreateSO = 'Y' , I_ErrorMsg = null WHERE i_productauxiliar_id = " + aux.get_ID();
                this.no = DB.executeUpdateEx(((String)sql).toString(), this.get_TrxName());
            }
            DB.executeUpdateEx("drop table aux_project", this.get_TrxName());
        }
        catch (Exception e) {
            try {
                this.rollback();
                throw new DBException(e, ((String)sql).toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void createCustomProduct(MProductAuxiliar aux, org.compiere.model.MProduct prod, MProject pr) {
        ArrayList<Object> ratio;
        MUYCustomProduct cp = null;
        if (aux != null && prod != null && pr != null) {
            cp = new MUYCustomProduct(this.getCtx(), 0, this.get_TrxName());
            cp.setC_Project_ID(pr.get_ID());
            cp.setModelSource(aux.getModelSource());
            cp.setAD_User_ID(aux.getAD_User_ID());
            cp.setC_Country_ID(aux.getC_Country_ID());
            if (aux.getfabric() != null) {
                cp.setfabric(aux.getfabric().trim());
            }
            cp.setOrderNo(aux.getOrderNo());
            cp.setM_Product_Group_ID(aux.getM_Product_Group_ID());
            cp.setStyle(aux.getStyle());
            cp.setBrand(aux.getBrand());
            cp.setM_Product_ID(prod.get_ID());
            cp.setM_PartType_ID(aux.getM_PartType_ID());
            cp.setM_Product_Classification_ID(aux.getM_Product_Classification_ID());
            cp.setM_Product_Classification_ID_2(aux.getM_Product_Classification2_ID());
            cp.setSample(aux.isSample());
            cp.setAlarm(aux.isAlarm());
            cp.setPacking(aux.getPacking());
            cp.setUnitPrice(aux.getUnitPrice());
            cp.setSalePrice(aux.getSalePrice());
            cp.setDeliveryTime_Promised(aux.getDeliveryTime_Promised());
            cp.setTotalQty(aux.getTotalQty());
            cp.setSizeRatio(aux.getSizeRatio());
            cp.setFabricSupplier(aux.getRef_BPartner_ID());
            if (this.m_Manual) {
                cp.setC_Campaign_ID(aux.getC_Campaign_ID());
            }
            if (this.m_Manual) {
                cp.setM_FreightCategory_ID(aux.getM_FreightCategory_ID());
            }
            cp.setC_BPartner_ID(aux.getC_BPartner_ID());
            if (aux.getC_BPartner_2_ID() != 0) {
                cp.setC_BPartner_2_ID(aux.getC_BPartner_2_ID());
            }
            cp.saveEx();
        }
        try {
            MAttribute sr = (MAttribute)aux.getM_Attribute();
            String strRatio = sr.getName();
            ratio = new ArrayList<String>(Arrays.asList(strRatio.replace(" ", "").split("-")));
        }
        catch (Exception e) {
            ratio = new ArrayList();
        }
        MAttribute mAttribute = new MAttribute(this.getCtx(), aux.getM_Attribute_ID(), this.get_TrxName());
        ArrayList<MAttributeValue> mAttributeValues = new ArrayList<MAttributeValue>(Arrays.asList(mAttribute.getMAttributeValues()));
        for (MAttributeValue mAttributeValue : mAttributeValues) {
            int pos;
            try {
                pos = ratio.indexOf(mAttributeValue.getValue()) + 1;
            }
            catch (Exception e) {
                pos = -1;
            }
            MUYCustomProductLine cpl = new MUYCustomProductLine(this.getCtx(), 0, this.get_TrxName());
            cpl.setUY_CustomProduct_ID(cp.get_ID());
            cpl.setSize(mAttributeValue.getValue());
            if (pos == 1) {
                cpl.setQtyEntered(aux.getSize1());
            } else if (pos == 2) {
                cpl.setQtyEntered(aux.getSize2());
            } else if (pos == 3) {
                cpl.setQtyEntered(aux.getSize3());
            } else if (pos == 4) {
                cpl.setQtyEntered(aux.getSize4());
            } else if (pos == 5) {
                cpl.setQtyEntered(aux.getSize5());
            } else if (pos == 6) {
                cpl.setQtyEntered(aux.getSize6());
            } else if (pos == 7) {
                cpl.setQtyEntered(aux.getSize7());
            } else if (pos == 8) {
                cpl.setQtyEntered(aux.getSize8());
            } else if (pos == 9) {
                cpl.setQtyEntered(aux.getSize9());
            } else if (pos == 10) {
                cpl.setQtyEntered(aux.getSize10());
            } else if (pos == 11) {
                cpl.setQtyEntered(aux.getSize11());
            } else if (pos == 12) {
                cpl.setQtyEntered(aux.getSize12());
            } else if (pos == 13) {
                cpl.setQtyEntered(aux.getSize13());
            } else if (pos == 14) {
                cpl.setQtyEntered(aux.getSize14());
            } else if (pos == 15) {
                cpl.setQtyEntered(aux.getSize15());
            } else if (pos == 16) {
                cpl.setQtyEntered(aux.getSize16());
            } else {
                throw new AdempiereException("Linea " + aux.getStyle() + "-" + aux.getBrand() + "-" + aux.getColorFabric() + "-" + aux.getFabricType() + ": La cantidad de talles no coincide con la denominaci\u00f3n de SizeRatio");
            }
            cpl.saveEx();
            this.setAttInstanceSetToOrderLine(prod, mAttributeValue.getValue());
        }
    }

    private void setAttInstanceSetToOrderLine(org.compiere.model.MProduct producto, String sizeIn) {
        try {
            if (producto != null && producto.get_ID() > 0) {
                MAttributeSet conjDeInstancia = producto.getAttributeSet();
                MAttribute[] atributosDelConjDeInctacia = conjDeInstancia.getMAttributes(true);
                MAttributeValue[] sizes = atributosDelConjDeInctacia[0].getMAttributeValues();
                MAttributeValue sizeAttValue = null;
                MAttributeSetInstance attSetInstance = null;
                MAttributeInstance attInstance = null;
                for (MAttributeValue av : sizes) {
                    if (!av.getValue().trim().toUpperCase().equals(sizeIn.trim().toUpperCase())) continue;
                    sizeAttValue = av;
                    int instanciaID = DB.getSQLValue(this.get_TrxName(), "SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance  WHERE IsActive = 'Y' AND value ='" + sizeIn.trim().toUpperCase() + "'  AND M_Attribute_ID = " + atributosDelConjDeInctacia[0].get_ID() + " AND M_AttributeValue_ID =" + av.get_ID());
                    if (instanciaID > 0) {
                        attSetInstance = new MAttributeSetInstance(this.getCtx(), instanciaID, null);
                        continue;
                    }
                    attSetInstance = new MAttributeSetInstance(this.getCtx(), 0, producto.getM_AttributeSet_ID(), null);
                    attSetInstance.setAD_Org_ID(producto.getAD_Org_ID());
                    attSetInstance.setDescription(sizeAttValue.getValue());
                    attSetInstance.saveEx();
                    attInstance = new MAttributeInstance(this.getCtx(), atributosDelConjDeInctacia[0].get_ID(), attSetInstance.get_ID(), av.get_ID(), av.getValue().trim().toUpperCase(), this.get_TrxName());
                    attInstance.setAD_Org_ID(producto.getAD_Org_ID());
                    attInstance.saveEx();
                    System.out.println("creo ASI:" + attSetInstance);
                }
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private void createProjetLine(MProject pr, org.compiere.model.MProduct prod, Timestamp actualdtp) {
        if (pr != null && pr.get_ID() > 0 && prod != null && prod.get_ID() > 0) {
            MProjectLine prLine = new MProjectLine(pr);
            prLine.setM_Product_ID(prod.get_ID());
            prLine.setDescription(pr.getName());
            if (actualdtp != null) {
                String sql = "SELECT '" + actualdtp + "'::timestamp - CAST('75 days' AS INTERVAL)";
                Timestamp date = DB.getSQLValueTSEx(this.get_TrxName(), sql, new Object[0]);
                prLine.set_ValueOfColumn("DateDelivered", (Object)date);
            }
            prLine.saveEx();
        }
    }

    private void createMProductPO(int C_BPartner_2_ID, org.compiere.model.MProduct prod, BigDecimal pricePO, int C_Currency_ID, BigDecimal priceList) {
        MBPartner prov;
        if (C_BPartner_2_ID > 0 && (prov = new MBPartner(this.getCtx(), C_BPartner_2_ID, null)) != null) {
            MProductPO pPO = new MProductPO(this.getCtx(), 0, this.get_TrxName());
            pPO.setM_Product_ID(prod.get_ID());
            pPO.setC_UOM_ID(prod.getC_UOM_ID());
            pPO.setC_BPartner_ID(C_BPartner_2_ID);
            pPO.setIsCurrentVendor(true);
            pPO.setC_Currency_ID(C_Currency_ID);
            pPO.setPriceList(priceList);
            pPO.setPricePO(pricePO);
            pPO.setVendorProductNo(prod.getValue());
            pPO.saveEx();
        }
    }

    private void createPriceLVerSalePurchase(MProject pr, org.compiere.model.MProduct prod, int c_bPartner_2_id, BigDecimal unitPrice, BigDecimal pricePO, BigDecimal priceList) {
        MBPartner prov;
        MProductPrice ppv = new MProductPrice(this.getCtx(), pr.getM_PriceList_Version_ID(), prod.get_ID(), unitPrice, unitPrice, unitPrice, this.get_TrxName());
        ppv.saveEx();
        if (c_bPartner_2_id > 0 && (prov = new MBPartner(this.getCtx(), c_bPartner_2_id, null)) != null && prov.getPO_PriceList_ID() > 0) {
            int[] plvIds = null;
            if (prov.getPO_PriceList_ID() > 0) {
                plvIds = MPriceListVersion.getAllIDs("M_PriceList_Version", " M_PriceList_ID = " + prov.getPO_PriceList_ID() + " AND IsActive='Y' ", null);
            } else if (prov.getC_BP_Group_ID() > 0 && prov.getBPGroup().getPO_PriceList_ID() > 0) {
                plvIds = MPriceListVersion.getAllIDs("M_PriceList_Version", " M_PriceList_ID = " + prov.getBPGroup().getPO_PriceList_ID() + " AND IsActive='Y' ", null);
            }
            if (plvIds.length > 0 && plvIds[0] > 0) {
                MProductPrice ppc = new MProductPrice(this.getCtx(), plvIds[0], prod.get_ID(), priceList, pricePO, pricePO, this.get_TrxName());
                ppc.saveEx();
            }
        }
    }

    private MProject createProject(MProductAuxiliar aux, MBPartner partner) {
        String sql = "SELECT C_Project_ID FROM C_Project WHERE C_BPartner_ID=" + partner.get_ID() + " AND upper(Name) LIKE upper('%" + aux.getVersion() + "')";
        int prId = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        MProject pr = new MProject(this.getCtx(), prId > 0 ? prId : 0, this.get_TrxName());
        pr.setName(partner.getName() + " - " + aux.getVersion());
        pr.setSalesRep_ID(aux.getAD_User_ID());
        pr.setAD_User_ID(aux.getAD_User_ID());
        pr.setDateFinish(aux.getDeliveryTime_Promised());
        pr.setC_BPartner_ID(partner.get_ID());
        pr.setC_BPartner_Location_ID(partner.getPrimaryC_BPartner_Location_ID());
        if (partner.getC_PaymentTerm_ID() > 0) {
            pr.setC_PaymentTerm_ID(partner.getC_PaymentTerm_ID());
        }
        pr.setPOReference(aux.getOrderNo());
        pr.setC_Currency_ID(this.m_CurrencyID);
        int idProjType = DB.getSQLValueEx(this.get_TrxName(), "SELECT C_ProjectType_ID FROM C_ProjectType  WHERE UPPER(name) like '%NEGOCIO TRADER%'  AND IsActive = 'Y' AND ProjectCategory='S' ", new Object[0]);
        if (idProjType > 0) {
            pr.setC_ProjectType_ID(idProjType);
        }
        pr.setM_PriceList_Version_ID(new MPriceList(this.getCtx(), this.m_priceListID, null).getPriceListVersion(null).get_ID());
        int mWarehouse_ID = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
        if (mWarehouse_ID <= 0) {
            int mOrg_ID = Env.getContextAsInt(this.getCtx(), "#AD_Org_ID");
            MOrgInfo orginfo = MOrgInfo.get(this.getCtx(), mOrg_ID, this.get_TrxName());
            if (orginfo.getDropShip_Warehouse_ID() != 0) {
                mWarehouse_ID = orginfo.getDropShip_Warehouse_ID();
            }
            if (mWarehouse_ID >= 0) {
                try {
                    mWarehouse_ID = orginfo.getM_Warehouse_ID();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        pr.setM_Warehouse_ID(mWarehouse_ID);
        pr.setC_Campaign_ID(aux.getC_Campaign_ID());
        pr.saveEx();
        ++this.noInsertPY;
        return pr;
    }
}

