/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateProformaFromProject
extends SvrProcess {
    private Timestamp date = null;
    private int prodID = 0;
    private String style = "";
    private int projectID = 0;
    private int salesOrderOk = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name.isEmpty()) continue;
            if (name.equalsIgnoreCase("DatePromised")) {
                this.date = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equalsIgnoreCase("M_Product_ID")) {
                if (para[i].getParameter() == null) continue;
                this.prodID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (!name.equalsIgnoreCase("Style") || para[i].getParameter() == null) continue;
            this.style = para[i].getParameterAsString();
        }
        if (this.style != null && !this.style.equalsIgnoreCase("")) {
            this.style = this.style.toUpperCase().trim();
        }
        this.projectID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        MOrder order = null;
        String group = "";
        MProduct prod = null;
        MProject proj = new MProject(this.getCtx(), this.projectID, null);
        Object sql = "";
        Object where = "";
        this.checkProductPrice();
        if (this.prodID > 0) {
            where = (String)where + " and p.m_product_id = " + this.prodID;
        }
        if (this.style != null && !this.style.equalsIgnoreCase("")) {
            where = (String)where + " and trim(upper(p.group1)) like '" + this.style + "'";
        }
        sql = "select pl.c_projectline_id, p.group1 from c_projectline pl inner join m_product p on pl.m_product_id = p.m_product_id where pl.c_project_id = " + this.projectID + (String)where + " order by p.group1";
        try {
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MProductPrice pp;
                MProjectLine line = new MProjectLine(this.getCtx(), rs.getInt("C_ProjectLine_ID"), this.get_TrxName());
                prod = (MProduct)line.getM_Product();
                if (!group.equalsIgnoreCase(rs.getString("group1"))) {
                    group = rs.getString("group1");
                    order = this.createNewSOHeader(rs);
                }
                if ((pp = MProductPrice.get(this.getCtx(), proj.getM_PriceList_Version_ID(), prod.get_ID(), this.get_TrxName())) == null || pp.get_ID() <= 0) {
                    pp = new MProductPrice(this.getCtx(), proj.getM_PriceList_Version_ID(), prod.get_ID(), this.get_TrxName());
                }
                pp.setPriceList(line.getPlannedPrice());
                pp.setPriceLimit(line.getPlannedPrice());
                pp.setPriceStd(line.getPlannedPrice());
                pp.saveEx();
                MAttributeSet atrSet = prod.getAttributeSet();
                MAttribute[] attributes = atrSet.getMAttributes(true);
                if (attributes.length <= 0) {
                    throw new AdempiereException("Error: Product '" + prod.getName() + "' with size ratio wrongly configured");
                }
                MAttributeValue[] sizes = attributes[0].getMAttributeValues();
                MAttributeSetInstance attSetInstance = null;
                MAttributeInstance attInstance = null;
                for (MAttributeValue av : sizes) {
                    int instanceID;
                    MOrderLine saleOLine = new MOrderLine(order);
                    saleOLine.setC_BPartner_ID(order.getC_BPartner_ID());
                    saleOLine.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
                    saleOLine.setM_Product_ID(prod.get_ID());
                    if (order.getM_FreightCategory_ID() <= 0 && prod.getM_FreightCategory_ID() > 0) {
                        order.setM_FreightCategory_ID(prod.getM_FreightCategory_ID());
                        order.saveEx();
                    }
                    if ((instanceID = DB.getSQLValue(this.get_TrxName(), "SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE M_Attribute_ID = " + sizes[0].get_ID() + " AND M_AttributeValue_ID = " + av.get_ID())) > 0) {
                        attSetInstance = new MAttributeSetInstance(this.getCtx(), instanceID, null);
                    } else {
                        attSetInstance = new MAttributeSetInstance(this.getCtx(), 0, prod.getM_AttributeSet_ID(), null);
                        attSetInstance.setAD_Org_ID(prod.getAD_Org_ID());
                        attSetInstance.setDescription(av.getValue());
                        attSetInstance.saveEx();
                        attInstance = new MAttributeInstance(this.getCtx(), attributes[0].get_ID(), attSetInstance.get_ID(), av.get_ID(), av.getValue().trim().toUpperCase(), this.get_TrxName());
                        attInstance.setAD_Org_ID(prod.getAD_Org_ID());
                        attInstance.saveEx();
                    }
                    if (attSetInstance != null && attSetInstance.get_ID() > 0) {
                        saleOLine.setM_AttributeSetInstance_ID(attSetInstance.get_ID());
                    }
                    saleOLine.setTax();
                    saleOLine.setPriceEntered(line.getPlannedPrice());
                    saleOLine.setPriceActual(line.getPlannedPrice());
                    saleOLine.set_ValueOfColumn("C_SubscriptionType_ID", (Object)prod.getC_SubscriptionType_ID());
                    saleOLine.saveEx();
                }
            }
            this.addLog(0, null, new BigDecimal(this.salesOrderOk), " Proformas Generated");
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    private void checkProductPrice() {
        Object sql = "";
        Object where = "";
        if (this.prodID > 0) {
            where = (String)where + " and p.m_product_id = " + this.prodID;
        }
        if (this.style != null && !this.style.equalsIgnoreCase("")) {
            where = (String)where + " and trim(upper(p.group1)) like '" + this.style + "'";
        }
        sql = "select count(pl.c_projectline_id) from c_projectline pl inner join m_product p on pl.m_product_id = p.m_product_id where pl.plannedprice <= 0 and pl.c_project_id = " + this.projectID + (String)where;
        int count = DB.getSQLValueEx(this.get_TrxName(), (String)sql, new Object[0]);
        if (count > 0) {
            throw new AdempiereException("Error: There are products without a Sale Price");
        }
    }

    private MOrder createNewSOHeader(ResultSet rs) {
        MOrder so = null;
        try {
            MProject proj = new MProject(this.getCtx(), this.projectID, this.get_TrxName());
            so = new MOrder(proj, true, "SO");
            so.setDropShip_BPartner_ID(so.getC_BPartner_ID());
            so.setDropShip_Location_ID(so.getC_BPartner_Location_ID());
            so.setDateOrdered(Env.getContextAsDate(this.getCtx(), "Date"));
            so.setDatePromised(this.date);
            so.setC_Currency_ID(proj.getC_Currency_ID());
            if (this.prodID > 0) {
                MProduct p = new MProduct(this.getCtx(), this.prodID, this.get_TrxName());
                so.setM_FreightCategory_ID(p.getM_FreightCategory_ID());
            }
            so.saveEx();
            ++this.salesOrderOk;
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        return so;
    }
}

