/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.adempiere.core.domains.models.I_DD_Order;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MStorage;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.distribution.process.MovementGenerate;
import org.eevolution.manufacturing.model.MPPCostCollector;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPOrderBOMLine;
import org.eevolution.services.dsl.ProcessBuilder;
import org.eevolution.wms.model.MWMInOutBound;
import org.eevolution.wms.model.MWMInOutBoundLine;
import org.openup.core.process.GeneratePickingAndShipmentAbstract;

public class GeneratePickingAndShipment
extends GeneratePickingAndShipmentAbstract {
    private Hashtable<Integer, MInOut> shipments = new Hashtable();
    private Hashtable<Integer, I_DD_Order> distributionOrders = new Hashtable();
    private Hashtable<Integer, MPPCostCollector> manufacturingIssues = new Hashtable();
    private int documentCreated = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.getProcessInfo().setTableSelectionId(MWMInOutBoundLine.Table_ID);
        List<Integer> recordIds = this.getSelectionKeys();
        recordIds.stream().forEach(key -> {
            MWMInOutBoundLine ioLine = new MWMInOutBoundLine(this.getCtx(), (int)key, this.get_TrxName());
            BigDecimal qtyToDeliver = this.getSelectionAsBigDecimal((int)key, "QtyToDeliver");
            this.createShipment(ioLine, qtyToDeliver);
            MWMInOutBound ioHdr = new MWMInOutBound(this.getCtx(), ioLine.getWM_InOutBound_ID(), this.get_TrxName());
            if (ioHdr.getDocStatus().equals("DR") || ioHdr.getDocStatus().equals("IP")) {
                ioHdr.setDocAction("CO");
                if (!ioHdr.processIt("CO")) {
                    this.addLog("@ProcessFailed@ : " + ioHdr.getDocumentInfo());
                    this.log.warning("@ProcessFailed@ :" + ioHdr.getDocumentInfo());
                }
                ioHdr.saveEx();
            }
        });
        this.processingShipments();
        this.processingMovements();
        this.processingIssues();
        StringBuilder documentGenerated = new StringBuilder();
        this.shipments.forEach((key, value) -> documentGenerated.append(" , ").append(value.getDocumentInfo()));
        return "@Created@ " + this.documentCreated + documentGenerated.toString();
    }

    private void createShipment(MWMInOutBoundLine outboundLine, BigDecimal qtyToDeliver) {
        if (outboundLine.getC_OrderLine_ID() > 0) {
            MOrderLine orderLine = outboundLine.getOrderLine();
            if (orderLine.getQtyToDelivery().subtract(qtyToDeliver).signum() < 0) {
                return;
            }
            BigDecimal qtyToDelivery = this.getSalesOrderQtyToDelivery(outboundLine, orderLine);
            if (qtyToDelivery.compareTo(outboundLine.getQtyToDeliver()) < 0) {
                return;
            }
            qtyToDelivery = qtyToDeliver;
            MInOut shipment = this.getShipment(orderLine, outboundLine.getParent());
            MInOutLine shipmentLine = new MInOutLine(outboundLine.getCtx(), 0, outboundLine.get_TrxName());
            shipmentLine.setM_InOut_ID(shipment.getM_InOut_ID());
            shipmentLine.setM_Locator_ID(outboundLine.getM_LocatorTo_ID());
            shipmentLine.setM_Product_ID(outboundLine.getM_Product_ID());
            shipmentLine.setDescription(outboundLine.getDescription());
            shipmentLine.setC_UOM_ID(outboundLine.getC_UOM_ID());
            shipmentLine.setQtyEntered(qtyToDelivery);
            shipmentLine.setMovementQty(qtyToDelivery);
            shipmentLine.setC_OrderLine_ID(orderLine.getC_OrderLine_ID());
            shipmentLine.setM_Shipper_ID(outboundLine.getM_Shipper_ID());
            shipmentLine.setM_FreightCategory_ID(outboundLine.getM_FreightCategory_ID());
            shipmentLine.setFreightAmt(outboundLine.getFreightAmt());
            shipmentLine.setM_AttributeSetInstance_ID(outboundLine.getM_AttributeSetInstance_ID());
            shipmentLine.setWM_InOutBoundLine_ID(outboundLine.getWM_InOutBoundLine_ID());
            shipmentLine.saveEx();
            outboundLine.setPickedQty(qtyToDeliver);
            outboundLine.saveEx();
        }
        if (outboundLine.getDD_OrderLine_ID() > 0) {
            MDDOrderLine distributionOrderLine = new MDDOrderLine(outboundLine.getCtx(), outboundLine.getDD_OrderLine_ID(), outboundLine.get_TrxName());
            distributionOrderLine.setDescription(outboundLine.getDescription());
            if (this.distributionOrders.get(distributionOrderLine.getDD_Order_ID()) == null) {
                this.distributionOrders.put(distributionOrderLine.getDD_Order_ID(), distributionOrderLine.getParent());
            }
            distributionOrderLine.setConfirmedQty(this.getDistributionOrderQtyToDelivery(outboundLine, distributionOrderLine));
            distributionOrderLine.saveEx();
        }
        if (outboundLine.getPP_Order_BOMLine_ID() > 0) {
            MPPOrderBOMLine orderBOMLine = (MPPOrderBOMLine)outboundLine.getPP_Order_BOMLine();
            if (outboundLine.getPickedQty().subtract(orderBOMLine.getQtyDelivered()).signum() < 0) {
                return;
            }
            MStorage[] storage = MStorage.getAll(this.getCtx(), orderBOMLine.getM_Product_ID(), outboundLine.getM_LocatorTo_ID(), this.get_TrxName());
            BigDecimal qtyDelivered = this.getManufacturingOrderQtyToDelivery(outboundLine, orderBOMLine);
            List<MPPCostCollector> issues = MPPOrder.createIssue(orderBOMLine.getParent(), orderBOMLine, this.getMovementDate(), qtyDelivered, BigDecimal.ZERO, BigDecimal.ZERO, storage, true);
            issues.forEach(costCollector -> {
                costCollector.setDescription(outboundLine.getDescription());
                costCollector.saveEx();
                if (this.manufacturingIssues.get(costCollector.getPP_Cost_Collector_ID()) == null) {
                    this.manufacturingIssues.put(costCollector.getPP_Cost_Collector_ID(), (MPPCostCollector)costCollector);
                }
            });
        }
    }

    private BigDecimal getSalesOrderQtyToDelivery(MWMInOutBoundLine outboundLine, MOrderLine orderLine) {
        BigDecimal salesOrderQtyAvailable = orderLine.getQtyToDelivery();
        BigDecimal outboundOrderQtyToDelivery = outboundLine.getPickedQty().subtract(outboundLine.getShipmentQtyDelivered());
        BigDecimal qtyToDelivery = outboundOrderQtyToDelivery.compareTo(salesOrderQtyAvailable) > 0 ? salesOrderQtyAvailable : (!"F".equals(orderLine.getParent().getDeliveryRule()) && !"M".equals(orderLine.getParent().getDeliveryRule()) ? outboundOrderQtyToDelivery : salesOrderQtyAvailable);
        return qtyToDelivery;
    }

    private BigDecimal getManufacturingOrderQtyToDelivery(MWMInOutBoundLine outboundLine, MPPOrderBOMLine orderBOMLine) {
        BigDecimal manufacturingOrderQtyToDelivery = orderBOMLine.getQtyRequired().subtract(orderBOMLine.getQtyRequired());
        BigDecimal outboundOrderQtyToDelivery = outboundLine.getPickedQty().subtract(outboundLine.getManufacturingOrderQtyDelivered());
        BigDecimal qtyToDelivery = outboundOrderQtyToDelivery.compareTo(manufacturingOrderQtyToDelivery) > 0 ? manufacturingOrderQtyToDelivery : (!"F".equals(orderBOMLine.getParent().getDeliveryRule()) && !"M".equals(orderBOMLine.getParent().getDeliveryRule()) ? outboundOrderQtyToDelivery : manufacturingOrderQtyToDelivery);
        return qtyToDelivery;
    }

    private BigDecimal getDistributionOrderQtyToDelivery(MWMInOutBoundLine outboundLine, MDDOrderLine orderLine) {
        BigDecimal distributionOrderQtyToDelivery = orderLine.getQtyToDeliver();
        BigDecimal outboundOrderQtyToDelivery = outboundLine.getPickedQty().subtract(outboundLine.getDistributionOrderQtyDelivered());
        BigDecimal qtyToDelivery = outboundOrderQtyToDelivery.compareTo(distributionOrderQtyToDelivery) > 0 ? distributionOrderQtyToDelivery : (!"F".equals(orderLine.getParent().getDeliveryRule()) && !"M".equals(orderLine.getParent().getDeliveryRule()) ? outboundOrderQtyToDelivery : distributionOrderQtyToDelivery);
        return qtyToDelivery;
    }

    private void processingMovements() {
        this.distributionOrders.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            I_DD_Order distributionOrder = (I_DD_Order)entry.getValue();
            ArrayList<Integer> orderIds = new ArrayList<Integer>();
            orderIds.add(distributionOrder.getDD_Order_ID());
            ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(MovementGenerate.getProcessId()).withSelectedRecordsIds(MDDOrder.Table_ID, orderIds).withParameter("M_Warehouse_ID", distributionOrder.getM_Warehouse_ID()).withParameter("MovementDate", this.getMovementDate()).withoutTransactionClose().execute(this.get_TrxName());
            if (processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            this.addLog(processInfo.getSummary());
            Arrays.stream(processInfo.getIDs()).forEach(recordId -> {
                Optional<MMovement> maybeMovement = Optional.ofNullable(new MMovement(this.getCtx(), recordId, this.get_TrxName()));
                maybeMovement.ifPresent(movement -> {
                    ++this.documentCreated;
                    this.printDocument((PO)movement, true);
                });
            });
        });
    }

    private void processingShipments() {
        ArrayList<PO> shipmentsToPrint = new ArrayList<PO>();
        this.shipments.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            MInOut shipment = (MInOut)entry.getValue();
            if (!shipment.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + shipment.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + shipment.getDocumentInfo());
            }
            shipment.saveEx();
            ++this.documentCreated;
            this.addLog(shipment.getDocumentInfo());
            shipmentsToPrint.add(shipment);
        });
        this.printDocument(shipmentsToPrint, true);
    }

    private void processingIssues() {
        this.manufacturingIssues.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            MPPCostCollector issue = (MPPCostCollector)entry.getValue();
            if ("DR".equals(issue.getDocStatus()) || "IP".equals(issue.getDocStatus())) {
                if (!issue.processIt("CO")) {
                    this.addLog("@ProcessFailed@ : " + issue.getDocumentInfo());
                    this.log.warning("@ProcessFailed@ :" + issue.getDocumentInfo());
                }
                issue.saveEx();
            }
        });
    }

    private MInOut getShipment(MOrderLine orderLine, MWMInOutBound outbound) {
        MInOut shipment = this.shipments.get(orderLine.getC_Order_ID());
        if (shipment != null) {
            return shipment;
        }
        MOrder order = orderLine.getParent();
        MDocType orderDocumentType = (MDocType)order.getC_DocType();
        int docTypeId = orderDocumentType.getC_DocTypeShipment_ID();
        if (docTypeId == 0) {
            docTypeId = MDocType.getDocType("MMS", orderLine.getAD_Org_ID());
        }
        shipment = new MInOut(order, docTypeId, this.getMovementDate());
        shipment.setIsSOTrx(true);
        shipment.setM_Shipper_ID(outbound.getM_Shipper_ID());
        shipment.setDescription(outbound.getDescription());
        shipment.setM_FreightCategory_ID(outbound.getM_FreightCategory_ID());
        shipment.setFreightCostRule(outbound.getFreightCostRule());
        shipment.setFreightAmt(outbound.getFreightAmt());
        shipment.setDocAction("CO");
        shipment.setDocStatus("DR");
        shipment.saveEx();
        this.shipments.put(order.getC_Order_ID(), shipment);
        return shipment;
    }
}

