/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.sql.ResultSet;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateBPLocation
extends SvrProcess {
    private int locationID = 0;

    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        ResultSet rs;
        CPreparedStatement pstmt;
        block6: {
            MOrg org;
            block5: {
                org = new MOrg(Env.getCtx(), 1000001, null);
                MOrgInfo info = org.getInfo();
                pstmt = null;
                rs = null;
                if (info.getC_Location_ID() <= 0) break block5;
                this.locationID = info.getC_Location_ID();
                String sql = "select bp.c_bpartner_id from c_bpartner bp where bp.ad_client_id = 1000001 and (select count(c_bpartner_location_id) from c_bpartner_location where c_bpartner_id = bp.c_bpartner_id) <= 0";
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int partnerID = rs.getInt("c_bpartner_id");
                        this.generatePartnerLocation(partnerID);
                    }
                }
                catch (Exception e) {
                    try {
                        throw new AdempiereException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                }
                break block6;
            }
            throw new AdempiereException("No se pudo obtener localizaci\u00f3n para la organizaci\u00f3n " + org.getName());
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "OK";
    }

    private void generatePartnerLocation(int partnerID) {
        if (partnerID > 0) {
            MLocation locationOrg = new MLocation(Env.getCtx(), this.locationID, null);
            MLocation locationBP = new MLocation(Env.getCtx(), 0, null);
            locationBP.setC_Country_ID(locationOrg.getC_Country_ID());
            locationBP.setCity(locationOrg.getCity());
            locationBP.setC_City_ID(locationOrg.getC_City_ID());
            locationBP.setRegionName(locationOrg.getRegionName());
            locationBP.setC_Region_ID(locationOrg.getC_Region_ID());
            locationBP.saveEx();
            MBPartnerLocation bpLocation = new MBPartnerLocation(Env.getCtx(), 0, null);
            bpLocation.setC_BPartner_ID(partnerID);
            if (locationBP.getCity() != null) {
                bpLocation.setName(locationBP.getCity());
            } else {
                bpLocation.setName("--");
            }
            bpLocation.setC_Location_ID(locationBP.get_ID());
            bpLocation.saveEx();
        }
    }
}

