/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.util.List;
import org.eevolution.hr.model.MHRRelationship;
import org.openup.core.model.MFamily;
import org.openup.core.model.MFamily_Member;
import org.openup.core.process.FamilyUpdateQtyOfChildrenAbstract;

public class FamilyUpdateQtyOfChildren
extends FamilyUpdateQtyOfChildrenAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        int relationshipId = this.getRelationshipId();
        MHRRelationship mhrRelationship = new MHRRelationship(this.getCtx(), relationshipId, this.get_TrxName());
        MFamily mFamily = new MFamily(this.getCtx(), this.getFamilyId(), this.get_TrxName());
        List<MFamily_Member> members = mFamily.getMembers();
        long qtyOfChildren = members.stream().filter(mFamily_member -> mFamily_member.getHR_Relationship_ID() == relationshipId).count();
        this.log.info("Setting quantity of children: " + qtyOfChildren);
        mFamily.set_ValueOfColumn("QtyUsed", (Object)BigDecimal.valueOf(qtyOfChildren));
        mFamily.saveEx();
        return "@UY_Family_Member@ (" + mhrRelationship.getName() + "): @Quantity@ = " + qtyOfChildren;
    }
}

