/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class CompensationPO
extends SvrProcess {
    private int orderID = 0;
    private int lineID = 0;
    private int productID = 0;
    private int docTypeID = 0;
    private Timestamp datePromised = null;
    private BigDecimal qtyEntered = Env.ZERO;
    private BigDecimal priceEntered = Env.ZERO;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("C_Order_ID") && para[i].getParameter() != null) {
                this.orderID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_OrderLine_ID") && para[i].getParameter() != null) {
                this.lineID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("M_Product_ID") && para[i].getParameter() != null) {
                this.productID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("DatePromised") && para[i].getParameter() != null) {
                this.datePromised = (Timestamp)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("QtyEntered") && para[i].getParameter() != null) {
                this.qtyEntered = (BigDecimal)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("PriceEntered") && para[i].getParameter() != null) {
                this.priceEntered = (BigDecimal)para[i].getParameter();
            }
            if (!name.equalsIgnoreCase("C_DocType_ID") || para[i].getParameter() == null) continue;
            this.docTypeID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String doIt() throws Exception {
        String message = "No se realizaron cambios en la linea de orden seleccionada";
        if (this.datePromised != null && this.productID == 0) {
            MOrderLine line = new MOrderLine(this.getCtx(), this.lineID, this.get_TrxName());
            if (this.datePromised == null) return message;
            line.set_ValueOfColumn("OldDatePromised", (Object)line.getDatePromised());
            line.setDatePromised(this.datePromised);
            line.set_ValueOfColumn("IsCompensated", (Object)true);
            line.saveEx();
            return "Linea modificada correctamente";
        }
        if (this.productID <= 0) return message;
        if (this.datePromised == null) throw new AdempiereException("ERROR: Se debe indicar fecha emisi\u00f3n, cantidad y precio para el producto seleccionado");
        if (this.qtyEntered.compareTo(Env.ZERO) <= 0) throw new AdempiereException("ERROR: Se debe indicar fecha emisi\u00f3n, cantidad y precio para el producto seleccionado");
        if (this.priceEntered.compareTo(Env.ZERO) <= 0) throw new AdempiereException("ERROR: Se debe indicar fecha emisi\u00f3n, cantidad y precio para el producto seleccionado");
        MOrder poOrder = new MOrder(this.getCtx(), this.orderID, this.get_TrxName());
        MOrderLine poLine = new MOrderLine(this.getCtx(), this.lineID, this.get_TrxName());
        MOrderLine soLine = null;
        String sql = "select c_order_id from c_order where issotrx = 'Y' and link_order_id = " + poOrder.get_ID();
        int so_id = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (so_id <= 0) throw new AdempiereException("ERROR: No se encuentra OV asociada a la OC seleccionada");
        MOrder so_from = new MOrder(this.getCtx(), so_id, this.get_TrxName());
        sql = "select c_orderline_id from c_orderline where link_orderline_id = " + poLine.get_ID();
        int soLine_id = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (soLine_id <= 0) throw new AdempiereException("ERROR: No se encuentra linea de OV asociada a la linea de OC seleccionada");
        soLine = new MOrderLine(this.getCtx(), soLine_id, this.get_TrxName());
        if (soLine.getQtyDelivered().compareTo(Env.ZERO) > 0) {
            throw new AdempiereException("ERROR: Existe cantidad entregada para linea de OV asociada a la linea de OC seleccionada");
        }
        MOrder newSO = this.createSO(so_from, poLine, soLine);
        return "Se gener\u00f3 Orden de Venta Compensaci\u00f3n Nro. " + newSO.getDocumentNo();
    }

    private MOrder createSO(MOrder so, MOrderLine poLine, MOrderLine soLine) {
        Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        MOrder poOrder = new MOrder(this.getCtx(), this.orderID, this.get_TrxName());
        MBPartner partner = (MBPartner)so.getC_BPartner();
        MProduct product = (MProduct)poLine.getM_Product();
        MOrder newSO = MOrder.copyFrom(so, today, this.docTypeID, true, false, false, false, this.get_TrxName());
        newSO.setAD_Org_ID(so.getAD_Org_ID());
        newSO.setM_Warehouse_ID(so.getM_Warehouse_ID());
        newSO.setBPartner(partner);
        newSO.setDateOrdered(today);
        newSO.setDatePromised(this.datePromised);
        newSO.setSalesRep_ID(so.getSalesRep_ID());
        String description = "Por favor realizar la siguiente compensaci\u00f3n de la Emisi\u00f3n solicitada en la Orden de Compra nro. " + poOrder.getDocumentNo() + " : \nProducto: " + product.getName() + "\nFecha Emisi\u00f3n: " + this.datePromised + "\nCantidad: " + poLine.getQtyEntered() + "\nPrecio: " + poLine.getPriceEntered();
        newSO.setDescription(description);
        newSO.set_ValueOfColumn("IsCustomerApproved", (Object)false);
        newSO.save();
        MOrderLine line = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
        line.setC_Order_ID(newSO.get_ID());
        line.setM_Product_ID(this.productID);
        line.setOrder(newSO);
        line.setQtyEntered(this.qtyEntered);
        line.setQtyOrdered(this.qtyEntered);
        line.setQtyReserved(this.qtyEntered);
        line.setC_Tax_ID(poLine.getC_Tax_ID());
        line.setC_UOM_ID(poLine.getC_UOM_ID());
        line.setPrice();
        line.setPriceEntered(this.priceEntered);
        line.setPriceActual(this.priceEntered);
        line.setPriceList(this.priceEntered);
        line.setPriceLimit(this.priceEntered);
        line.setDatePromised(this.datePromised);
        line.setC_Activity_ID(soLine.getC_Activity_ID());
        line.setC_Campaign_ID(soLine.getC_Campaign_ID());
        line.setUser1_ID(soLine.getUser1_ID());
        line.setUser2_ID(soLine.getUser2_ID());
        line.setUser3_ID(soLine.getUser3_ID());
        line.set_ValueOfColumn("CUST_MediaType_ID", soLine.get_Value("CUST_MediaType_ID"));
        line.setC_Project_ID(soLine.getC_Project_ID());
        line.setC_ProjectPhase_ID(soLine.getC_ProjectPhase_ID());
        line.setC_ProjectTask_ID(soLine.getC_ProjectTask_ID());
        line.save();
        return newSO;
    }
}

