/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.util.Env;
import org.openup.core.process.BankStmtCommissionPayAbstract;

public class BankStmtCommissionPay
extends BankStmtCommissionPayAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MBankStatement statement = new MBankStatement(this.getCtx(), this.getParameterAsInt("C_BankStatement_ID"), this.get_TrxName());
        MBankAccount account = null;
        int chargeID = 0;
        BigDecimal totalAmount = Env.ZERO;
        for (int key : this.getSelectionKeys()) {
            BigDecimal amount = this.getSelectionAsBigDecimal(key, "BSL_Amount");
            if (amount.compareTo(Env.ZERO) < 0) {
                amount = amount.negate();
            }
            totalAmount = totalAmount.add(amount);
            if (account == null) {
                int lineID = this.getSelectionAsInt(key, "BSL_C_BankStatementLine_ID");
                MBankStatementLine line = new MBankStatementLine(this.getCtx(), lineID, this.get_TrxName());
                account = line.getParent().getBankAccount();
                if (account.getC_BPartner_ID() <= 0) {
                    throw new AdempiereException("ERROR: No se obtuvo socio del negocio para la cuenta bancaria del documento");
                }
            }
            if (chargeID != 0) continue;
            chargeID = this.getSelectionAsInt(key, "BSL_C_Charge_ID_2");
        }
        MPayment payment = this.createPayment(account, totalAmount, statement, chargeID);
        return "Creado: " + payment.getDocumentNo();
    }

    private MPayment createPayment(MBankAccount account, BigDecimal payAmt, MBankStatement statement, int chargeID) {
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        payment.setAD_Org_ID(statement.getAD_Org_ID());
        payment.setIsReceipt(false);
        payment.setC_BankAccount_ID(account.get_ID());
        payment.setC_Currency_ID(account.getC_Currency_ID());
        payment.setDateAcct(statement.getStatementDate());
        payment.setDateTrx(statement.getStatementDate());
        payment.setTenderType("A");
        payment.setC_Charge_ID(chargeID);
        payment.setPayAmt(payAmt);
        payment.setDescription("Pago por comisi\u00f3n generado desde estado de cuenta bancario Nro. " + statement.getDocumentNo());
        payment.setC_BPartner_ID(account.getC_BPartner_ID());
        payment.saveEx();
        payment.processIt("CO");
        payment.saveEx();
        return payment;
    }
}

