/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.process.InvoiceCreateInOut;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class AutoDelivery
extends SvrProcess {
    private int invoiceID = 0;
    private int warehouseID = 0;
    private boolean completeDoc = false;
    private Properties ctx = null;
    String trxName = "";

    public AutoDelivery(int Invoice_ID, Properties ctx, boolean comp\u013aeteDoc, String trxName) {
        this.invoiceID = Invoice_ID;
        this.ctx = ctx;
        this.completeDoc = comp\u013aeteDoc;
        this.trxName = trxName;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("C_Invoice_ID")) {
                this.invoiceID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.executeProcess();
        return "OK";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String executeProcess() throws Exception {
        MInvoice inv = new MInvoice(this.ctx, this.invoiceID, this.trxName);
        if (inv.get_ID() <= 0) {
            throw new AdempiereException("No se obtuvo ID de documento");
        }
        if (inv.getAD_Org_ID() <= 0) throw new AdempiereException("El documento actual no tiene organizacion");
        MOrg org = new MOrg(this.ctx, inv.getAD_Org_ID(), this.trxName);
        MOrgInfo info = org.getInfo();
        if (info == null || info.get_ID() <= 0) throw new AdempiereException("No se obtuvo informacion de la organizacion actual");
        if (info.getDropShip_Warehouse_ID() <= 0) {
            throw new AdempiereException("No se obtuvo 'Almacen Entrega Directa' para la organizacion actual");
        }
        this.warehouseID = info.getDropShip_Warehouse_ID();
        InvoiceCreateInOut pr = new InvoiceCreateInOut(this.warehouseID, this.invoiceID, this.completeDoc, this.ctx, this.trxName);
        return pr.executeProcess();
    }
}

