/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.model.MSequence;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.MUYPayReceiptDoc;
import org.openup.core.model.MUYPayReceiptLine;
import org.openup.core.model.MViaLoan;
import org.spin.investment.model.MFMAmortization;

public class ModelValidatorCaycut
implements ModelValidator {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;
    private int m_AD_Org_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        } else {
            this.log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner", this);
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_Invoice", this);
        engine.addDocValidate("UY_PayReceipt", this);
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public int getAD_Client_ID() {
        return 0;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (po instanceof MBPartner) {
            MBPartner model = (MBPartner)po;
            if (1 != type || !model.isProspect()) return null;
            int seqID = MSequence.getNextID_ForName(model.getAD_Client_ID(), model.getAD_Org_ID(), "Value_Socio", model.get_TrxName());
            if (seqID <= 0) throw new AdempiereException("No se obtuvo secuencia para Socios");
            String secNumber = String.valueOf(seqID).trim();
            model.setValue(secNumber);
            return null;
        } else if (po instanceof MOrder) {
            MOrder model = (MOrder)po;
            if (4 != type && 5 != type || !model.isSOTrx()) return null;
            MViaLoan via = new MViaLoan(model.getCtx(), model.get_ValueAsInt("UY_ViaLoan_ID"), model.get_TrxName());
            if (via != null && via.get_ID() > 0) {
                Object reference = "";
                String plateNo = "";
                if (via.getPlateNo() != null && !via.getPlateNo().equalsIgnoreCase("")) {
                    plateNo = via.getPlateNo().toUpperCase().trim();
                    reference = via.getValue().toUpperCase().trim() + "-" + plateNo;
                } else {
                    reference = via.getValue().toUpperCase().trim();
                }
                DB.executeUpdateEx("update c_order set poreference = '" + (String)reference + "' where c_order_id = " + model.get_ID(), model.get_TrxName());
                return null;
            } else {
                DB.executeUpdateEx("update c_order set poreference = null where c_order_id = " + model.get_ID(), model.get_TrxName());
            }
            return null;
        } else {
            MOrder order;
            MDocType docOrder;
            MDocType doc;
            if (!(po instanceof MInvoice)) return null;
            MInvoice model = (MInvoice)po;
            if (4 != type || !model.isSOTrx() || !(doc = (MDocType)model.getC_DocTypeTarget()).getDocBaseType().equalsIgnoreCase("ARI") || model.get_ValueAsInt("UY_ViaLoan_ID") > 0 || model.getC_Order_ID() <= 0 || !(docOrder = (MDocType)(order = (MOrder)model.getC_Order()).getC_DocTypeTarget()).getDocBaseType().equalsIgnoreCase("SOO") || docOrder.getDocSubTypeSO() == null || !docOrder.getDocSubTypeSO().equalsIgnoreCase("SO") || order.get_ValueAsInt("UY_ViaLoan_ID") <= 0) return null;
            int viaID = order.get_ValueAsInt("UY_ViaLoan_ID");
            DB.executeUpdateEx("update c_invoice set uy_vialoan_id = " + viaID + " where c_invoice_id = " + model.get_ID(), model.get_TrxName());
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        block7: {
            MInvoice inv;
            MDocType documentType;
            block10: {
                MOrder order;
                MDocType doc;
                block6: {
                    block9: {
                        MUYPayReceipt pay;
                        block8: {
                            if (!(po instanceof MUYPayReceipt) || timing != 9) break block6;
                            pay = (MUYPayReceipt)po;
                            if (!pay.isSOTrx() || !pay.get_ValueAsBoolean("IsRepresentation")) break block7;
                            if (pay.getLinesDef().size() <= 0 || pay.getLinesGen("").size() > 0) break block8;
                            this.generateNCRepresentation(pay);
                            this.generateAllocation(pay);
                            break block7;
                        }
                        if (pay.getLinesGen("").size() <= 0 || pay.getLinesDoc("DRC", "").size() > 0) break block9;
                        this.generateAllocation(pay);
                        break block7;
                    }
                    throw new AdempiereException("ERROR: Verifique documentos de medios de cobro");
                }
                if (!(po instanceof MInvoice) || timing != 7) break block10;
                MInvoice inv2 = (MInvoice)po;
                int viaID = 0;
                if (!inv2.isSOTrx() || !(doc = (MDocType)inv2.getC_DocTypeTarget()).getDocBaseType().equalsIgnoreCase("ARI")) break block7;
                if (inv2.get_ValueAsInt("UY_ViaLoan_ID") > 0) {
                    viaID = inv2.get_ValueAsInt("UY_ViaLoan_ID");
                } else if (inv2.getC_Order_ID() > 0 && (order = (MOrder)inv2.getC_Order()).get_ValueAsInt("UY_ViaLoan_ID") > 0) {
                    viaID = order.get_ValueAsInt("UY_ViaLoan_ID");
                }
                if (viaID <= 0) break block7;
                String plateno = "";
                Object desc = "";
                MViaLoan via = new MViaLoan(inv2.getCtx(), viaID, inv2.get_TrxName());
                if (via.getPlateNo() != null && !via.getPlateNo().equalsIgnoreCase("")) {
                    plateno = via.getPlateNo().toUpperCase().trim();
                    desc = inv2.getDescription() != null && !inv2.getDescription().equalsIgnoreCase("") ? inv2.getDescription() + " \n Matr\u00edcula: " + plateno : "Matr\u00edcula: " + plateno;
                    inv2.setDescription((String)desc);
                }
                inv2.set_ValueOfColumn("UY_ViaLoan_ID", (Object)viaID);
                inv2.saveEx();
                break block7;
            }
            if (po instanceof MInvoice && timing == 9 && (documentType = MDocType.get((inv = (MInvoice)po).getCtx(), inv.getC_DocType_ID())).getDocBaseType().endsWith("C")) {
                for (MInvoiceLine line : inv.getLines()) {
                    if (line.get_ValueAsInt("FM_Amortization_ID") == 0) continue;
                    MFMAmortization amortization = new MFMAmortization(inv.getCtx(), line.get_ValueAsInt("FM_Amortization_ID"), inv.get_TrxName());
                    amortization.setIsInvoiced(false);
                    amortization.setIsPaid(false);
                    amortization.saveEx();
                }
            }
        }
        return null;
    }

    private void generateNCRepresentation(MUYPayReceipt pay) {
        Object sql = "";
        String message = null;
        MInvoice inv = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int docTypeID = MDocType.getDocType("DRC");
            MCurrency cur = (MCurrency)pay.getC_Currency();
            sql = "select c_bpartner_id, sum(invoiceamt) as amount from uy_payreceiptdoc where uy_payreceipt_id = " + pay.get_ID() + " group by c_bpartner_id, invoiceamt";
            pstmt = DB.prepareStatement((String)sql, pay.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MBPartner partner = new MBPartner(pay.getCtx(), rs.getInt("c_bpartner_id"), pay.get_TrxName());
                BigDecimal amount = rs.getBigDecimal("amount");
                inv = new MInvoice(pay.getCtx(), 0, pay.get_TrxName());
                inv.setC_DocType_ID(docTypeID);
                inv.setC_DocTypeTarget_ID(docTypeID);
                inv.setDateInvoiced(pay.getDateDoc());
                inv.setDateAcct(pay.getDateDoc());
                inv.setIsSOTrx(true);
                inv.setDescription("Creada desde: Recibo de Cobro Nro " + pay.getDocumentNo());
                inv.setC_BPartner_ID(partner.get_ID());
                String sql2 = "select c_bpartner_location_id from c_bpartner_location where c_bpartner_id = " + partner.get_ID();
                int locID = DB.getSQLValueEx(pay.get_TrxName(), sql2, new Object[0]);
                if (locID <= 0) {
                    throw new AdempiereException("No se obtuvo localizacion para el socio de negocio " + partner.getName());
                }
                inv.setC_BPartner_Location_ID(locID);
                inv.setC_Currency_ID(pay.getC_Currency_ID());
                inv.setPaymentRule("S");
                inv.setC_PaymentTerm_ID(MPaymentTerm.getPaymentTermByDefault(pay.getCtx(), pay.get_TrxName()).get_ID());
                inv.setTotalLines(amount);
                inv.setGrandTotal(amount);
                MPriceList list = MPriceList.getDefault(pay.getCtx(), true, cur.getISO_Code());
                if (list == null || list.get_ID() <= 0) {
                    throw new AdempiereException("No se obtuvo lista de precios de venta predeterminada en " + cur.getISO_Code());
                }
                inv.setM_PriceList_ID(list.get_ID());
                inv.set_ValueOfColumn("UY_PayReceipt_ID", (Object)pay.get_ID());
                inv.setDocStatus("DR");
                inv.setDocAction("CO");
                inv.saveEx();
                MInvoiceLine line = new MInvoiceLine(pay.getCtx(), 0, pay.get_TrxName());
                line.setC_Invoice_ID(inv.get_ID());
                line.setLine(0);
                line.setC_Charge_ID(1000003);
                line.setC_Tax_ID(1000000);
                line.setQtyEntered(Env.ONE);
                line.setQtyInvoiced(Env.ONE);
                line.setC_UOM_ID(100);
                line.setPriceEntered(amount);
                line.setPriceActual(amount);
                line.setLineNetAmt(amount);
                line.setLineTotalAmt(amount);
                line.saveEx();
                if (!inv.processIt("CO")) {
                    message = inv.getProcessMsg();
                    throw new AdempiereException(message);
                }
                MUYPayReceiptDoc lineDoc = new MUYPayReceiptDoc(Env.getCtx(), 0, pay.get_TrxName());
                lineDoc.setUY_PayReceipt_ID(pay.get_ID());
                lineDoc.setC_BPartner_ID(inv.getC_BPartner_ID());
                lineDoc.setC_Invoice_ID(inv.get_ID());
                lineDoc.setInvoiceAmt(inv.getGrandTotal());
                lineDoc.setAmtSource(inv.getGrandTotal());
                lineDoc.setPayAmt(inv.getGrandTotal());
                lineDoc.setOpenAmt(inv.getGrandTotal());
                lineDoc.setPaymentRule(inv.getPaymentRule());
                lineDoc.setIsSelected(false);
                lineDoc.saveEx();
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, (String)sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void generateAllocation(MUYPayReceipt pay) {
        boolean partnerID = false;
        MAllocationHdr alloc = null;
        Object line = null;
        if (pay.getLinesDoc("ARI", "").size() > 0 && pay.getLinesDoc("DRC", "").size() > 0) {
            alloc = new MAllocationHdr(Env.getCtx(), true, pay.getDateDoc(), pay.getC_Currency_ID(), Env.getContext(Env.getCtx(), "#AD_User_Name"), pay.get_TrxName());
            alloc.setAD_Org_ID(pay.getAD_Org_ID());
            alloc.setDescription("Generado automaticamente desde Recibo de Cobro Nro. " + pay.getDocumentNo());
            alloc.saveEx();
            List<MUYPayReceiptDoc> docs = pay.getLinesDoc();
            for (MUYPayReceiptDoc docLine : docs) {
                MInvoice inv = (MInvoice)docLine.getC_Invoice();
                MDocType doc = (MDocType)inv.getC_DocTypeTarget();
                BigDecimal multiplier = Env.ONE;
                if (doc.getDocBaseType().equalsIgnoreCase("DRC") && docLine.getPayAmt().compareTo(Env.ZERO) > 0) {
                    multiplier = multiplier.negate();
                }
                MAllocationLine aLine = new MAllocationLine(alloc, docLine.getPayAmt().multiply(multiplier), docLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
                aLine.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
                aLine.setC_BPartner_ID(inv.getC_BPartner_ID());
                aLine.saveEx();
            }
            if (alloc != null && alloc.get_ID() > 0) {
                if (!alloc.processIt("CO")) {
                    throw new AdempiereException(alloc.getProcessMsg());
                }
                alloc.saveEx();
                pay.setC_AllocationHdr_ID(alloc.get_ID());
                pay.saveEx();
            }
        } else if (pay.getLinesDoc("ARI", "").size() > 0 && pay.getLinesGen("").size() > 0) {
            alloc = new MAllocationHdr(Env.getCtx(), true, pay.getDateDoc(), pay.getC_Currency_ID(), Env.getContext(Env.getCtx(), "#AD_User_Name"), pay.get_TrxName());
            alloc.setAD_Org_ID(pay.getAD_Org_ID());
            alloc.setDescription("Generado automaticamente desde Recibo de Cobro Nro. " + pay.getDocumentNo());
            alloc.saveEx();
            List<MUYPayReceiptDoc> docs = pay.getLinesDoc("ARI", "");
            for (MUYPayReceiptDoc docLine : docs) {
                MInvoice inv = (MInvoice)docLine.getC_Invoice();
                MAllocationLine aLine = new MAllocationLine(alloc, docLine.getPayAmt(), docLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
                aLine.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
                aLine.setC_BPartner_ID(inv.getC_BPartner_ID());
                aLine.saveEx();
            }
            List<MUYPayReceiptLine> payLines = pay.getLinesGen("");
            for (MUYPayReceiptLine payLine : payLines) {
                if (payLine.getC_Payment_ID() <= 0) continue;
                MPayment payment = (MPayment)payLine.getC_Payment();
                MAllocationLine aLine = new MAllocationLine(alloc, payLine.getPayAmt(), payLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
                aLine.setC_Payment_ID(payment.get_ID());
                aLine.setC_BPartner_ID(payment.getC_BPartner_ID());
                aLine.saveEx();
            }
            if (alloc != null && alloc.get_ID() > 0) {
                if (!alloc.processIt("CO")) {
                    throw new AdempiereException(alloc.getProcessMsg());
                }
                alloc.saveEx();
                pay.setC_AllocationHdr_ID(alloc.get_ID());
                pay.saveEx();
            }
        }
    }
}

