/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import com.eevolution.model.MSContract;
import com.eevolution.model.X_S_Contract;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.I_C_Order;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.MCommissionRun;
import org.compiere.model.MCommissionType;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MJournal;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRequest;
import org.compiere.model.MRevenueRecognitionRun;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.model.MStandardRequest;
import org.compiere.model.MStandardRequestType;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.services.dsl.ProcessBuilder;
import org.openup.core.process.UpdateProjectProgressLog;
import org.openup.core.utils.Utils;
import org.openup.core.utils.model.MRevenueRecognitionPlan;

public class ModAgencyValidator
implements ModelValidator {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;
    private int m_AD_Org_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        } else {
            this.log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_RfQResponse", this);
        engine.addModelChange("C_Order", this);
        engine.addModelChange("R_Request", this);
        engine.addModelChange("C_Project", this);
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_InvoiceLine", this);
        engine.addModelChange("M_InOut", this);
        engine.addModelChange("C_ProjectPhase", this);
        engine.addModelChange("C_ProjectLine", this);
        engine.addModelChange("C_CommissionAmt", this);
        engine.addModelChange("C_Invoice", this);
        engine.addDocValidate("C_Order", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("M_InOut", this);
        engine.addDocValidate("S_TimeExpense", this);
        engine.addDocValidate("C_CommissionRun", this);
    }

    @Override
    public int getAD_Client_ID() {
        return 0;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (po instanceof MRfQResponse) {
            MRfQResponse model = (MRfQResponse)po;
            if (2 == type) {
                if (model.is_ValueChanged("IsSelectedWinner") && model.isSelectedWinner()) {
                    MRfQ rfq = (MRfQ)model.getC_RfQ();
                    String sql = "select c_rfqresponse_id from c_rfqresponse where c_rfq_id = " + model.getC_RfQ_ID() + " and isselectedwinner = 'Y'";
                    int responseID = DB.getSQLValueEx(model.get_TrxName(), sql, new Object[0]);
                    if (responseID > 0) {
                        throw new AdempiereException("Ya existe una respuesta ganadora para la SCP " + rfq.getDocumentNo());
                    }
                }
            } else if (5 == type && model.is_ValueChanged("IsSelectedWinner") && model.isSelectedWinner()) {
                this.updateRfqLineQty(model);
            }
        } else if (po instanceof MOrder) {
            MOrder model = (MOrder)po;
            MDocType docType = (MDocType)model.getC_DocTypeTarget();
            if (1 == type) {
                if (model.isSOTrx()) {
                    MProject p;
                    if (docType.get_ValueAsBoolean("IsUniqueOrder")) {
                        this.validateSOForProject(model);
                    }
                    if (model.get_ValueAsInt("C_ProjectPhase_ID") > 0) {
                        MProjectPhase phase = new MProjectPhase(model.getCtx(), model.get_ValueAsInt("C_ProjectPhase_ID"), model.get_TrxName());
                        model.setUser3_ID(phase.getUser3_ID());
                    } else if (model.get_ValueAsInt("C_ProjectTask_ID") > 0) {
                        MProjectTask task = new MProjectTask(model.getCtx(), model.get_ValueAsInt("C_ProjectTask_ID"), model.get_TrxName());
                        model.setUser3_ID(task.getUser3_ID());
                    }
                    if (model.getC_Project_ID() > 0 && (p = (MProject)model.getC_Project()).get_ValueAsInt("S_Contract_ID") > 0) {
                        MSContract con = new MSContract(model.getCtx(), p.get_ValueAsInt("S_Contract_ID"), model.get_TrxName());
                        Boolean noBillToFromContract = null;
                        try {
                            MCommission mCommission = (MCommission)new MCommissionRun(model.getCtx(), model.get_ValueAsInt("C_CommissionRun_ID"), model.get_TrxName()).getC_Commission();
                            MCommissionType mCommissionType = new MCommissionType(model.getCtx(), mCommission.get_ValueAsInt("C_CommissionType_ID"), model.get_TrxName());
                            noBillToFromContract = mCommissionType.get_ValueAsBoolean("NoBillToFromContract");
                        }
                        catch (Exception e) {
                            noBillToFromContract = null;
                        }
                        if (noBillToFromContract == null) {
                            throw new AdempiereException("\"@C_CommissionType@\".\"@NoBillToFromContract@\" @not.found@");
                        }
                        if (!noBillToFromContract.booleanValue() && con.getBill_BPartner_ID() > 0) {
                            model.setBill_BPartner_ID(con.getBill_BPartner_ID());
                            model.setBill_Location_ID(con.getBill_Location_ID());
                        }
                    }
                    if (docType.get_ValueAsBoolean("IsDirectInvoice")) {
                        model.set_ValueOfColumn("IsDirectInvoice", (Object)true);
                    } else {
                        model.set_ValueOfColumn("IsDirectInvoice", (Object)false);
                    }
                } else if (docType.get_ValueAsBoolean("IsDirectInvoice")) {
                    model.set_ValueOfColumn("IsDirectInvoice", (Object)true);
                } else {
                    model.set_ValueOfColumn("IsDirectInvoice", (Object)false);
                }
                if ((model.is_ValueChanged("C_DocTypeTarget_ID") || model.is_ValueChanged("S_Contract_ID")) && docType.get_ValueAsBoolean("IsContractMandatory") && model.get_ValueAsInt("S_Contract_ID") <= 0) {
                    throw new AdempiereException("ERROR: Debe seleccionar un Contrato.");
                }
            } else if (2 == type) {
                if (model.isSOTrx()) {
                    MSContract contract;
                    if (model.get_ValueAsInt("S_Contract_ID") > 0 && model.get_ValueAsBoolean("IsAllowToInvoice") && (contract = new MSContract(model.getCtx(), model.get_ValueAsInt("S_Contract_ID"), model.get_TrxName())).isSelected() && contract.getC_BPartner_ID() == model.getC_BPartner_ID() && (model.getPOReference() == null || model.getPOReference().compareTo("") == 0)) {
                        throw new AdempiereException("ERROR: No es posible definir 'Permite Facturar', referencia en campo 'OC Cliente' es obligatorio.");
                    }
                    if (model.get_ValueAsBoolean("IsAllowToInvoice") && docType.getC_DocTypeInvoice_ID() <= 0) {
                        throw new AdempiereException("ERROR: No es posible definir 'Permite Facturar', verifique tipo de documento de esta orden.");
                    }
                    if (docType.get_ValueAsBoolean("IsDirectInvoice")) {
                        model.set_ValueOfColumn("IsDirectInvoice", (Object)true);
                    } else {
                        model.set_ValueOfColumn("IsDirectInvoice", (Object)false);
                    }
                } else {
                    if (model.is_ValueChanged("C_DocTypeTarget_ID") || model.is_ValueChanged("IsDirectInvoice")) {
                        if (docType.get_ValueAsBoolean("IsDirectInvoice")) {
                            model.set_ValueOfColumn("IsDirectInvoice", (Object)true);
                        } else {
                            model.set_ValueOfColumn("IsDirectInvoice", (Object)false);
                        }
                    }
                    if ((model.is_ValueChanged("C_DocTypeTarget_ID") || model.is_ValueChanged("S_Contract_ID")) && docType.get_ValueAsBoolean("IsContractMandatory") && model.get_ValueAsInt("S_Contract_ID") <= 0) {
                        throw new AdempiereException("ERROR: Debe seleccionar un Contrato.");
                    }
                }
            } else if (5 == type) {
                MSContract contract;
                if (model.isSOTrx() && model.get_ValueAsBoolean("IsAllowToInvoice") && model.get_ValueAsInt("S_Contract_ID") > 0 && (contract = new MSContract(model.getCtx(), model.get_ValueAsInt("S_Contract_ID"), model.get_TrxName())).isSelected() && contract.getC_BPartner_ID() == model.getC_BPartner_ID()) {
                    if (model.getPOReference() == null || model.getPOReference().compareTo("") == 0) {
                        DB.executeUpdateEx("update c_order set isallowtoinvoice = 'N' where c_order_id = " + model.get_ID(), model.get_TrxName());
                    } else {
                        DB.executeUpdateEx("update c_order set c_ordersource_id = null where c_order_id = " + model.get_ID(), model.get_TrxName());
                    }
                }
            } else if (4 == type && docType.get_ValueAsBoolean("IsUniqueOrder")) {
                int phaseID = model.get_ValueAsInt("C_ProjectPhase_ID");
                int taskID = model.get_ValueAsInt("C_ProjectTask_ID");
                MProject project = (MProject)model.getC_Project();
                if (project != null && project.getAD_Org_ID() == model.getAD_Org_ID()) {
                    if (model.isSOTrx()) {
                        if (taskID > 0) {
                            DB.executeUpdateEx("update c_projecttask set c_order_id = " + model.get_ID() + " where c_projecttask_id = " + taskID, model.get_TrxName());
                        }
                        if (phaseID > 0 && taskID == 0) {
                            DB.executeUpdateEx("update c_projectphase set c_order_id = " + model.get_ID() + " where c_projectphase_id = " + phaseID, model.get_TrxName());
                        }
                    } else {
                        if (taskID > 0) {
                            DB.executeUpdateEx("update c_projecttask set c_orderpo_id = " + model.get_ID() + " where c_projecttask_id = " + taskID, model.get_TrxName());
                        }
                        if (phaseID > 0 && taskID == 0) {
                            DB.executeUpdateEx("update c_projectphase set c_orderpo_id = " + model.get_ID() + " where c_projectphase_id = " + phaseID, model.get_TrxName());
                        }
                    }
                }
            }
        } else if (po instanceof MOrderLine) {
            MOrderLine model = (MOrderLine)po;
            if (1 == type || 2 == type) {
                MTax forcedTax;
                if (model.getC_Order().isSOTrx() && (forcedTax = this.getForcedTax(model.getCtx(), model.getAD_Client_ID(), model.getAD_Org_ID())) != null) {
                    model.setC_Tax_ID(forcedTax.get_ID());
                }
                if ((1 == type || 2 == type && (model.is_ValueChanged("M_Product_ID") || model.is_ValueChanged("DescriptionURL"))) && model.getM_Product_ID() > 0) {
                    MProduct prod = (MProduct)model.getM_Product();
                    String value = model.get_ValueAsString("DescriptionURL");
                    if (prod.isWebStoreFeatured() && (value == null || value.trim().isEmpty())) {
                        throw new AdempiereException("ERROR: Campo Landing de Campa\u00f1a es obligatorio para el producto '" + prod.getName() + "'");
                    }
                }
            }
        } else if (po instanceof MInvoiceLine) {
            MTax forcedTax;
            MInvoiceLine model = (MInvoiceLine)po;
            if ((1 == type || 2 == type) && model.getC_Invoice().isSOTrx() && (forcedTax = this.getForcedTax(model.getCtx(), model.getAD_Client_ID(), model.getAD_Org_ID())) != null) {
                model.setC_Tax_ID(forcedTax.get_ID());
            }
        } else if (po instanceof MRequest) {
            MOrder order;
            MRequest model = (MRequest)po;
            if (1 == type && model.getC_Order_ID() > 0 && (order = (MOrder)model.getC_Order()).getSalesRep_ID() > 0) {
                model.setSalesRep_ID(order.getSalesRep_ID());
            }
        } else if (po instanceof MProject) {
            MProject model = (MProject)po;
            if (1 == type || 2 == type) {
                if (model.is_ValueChanged("S_Contract_ID")) {
                    if (model.get_ValueAsInt("S_Contract_ID") > 0) {
                        if (model.getC_ProjectCategory() != null) {
                            int contractID = model.get_ValueAsInt("S_Contract_ID");
                            int user1_ID = 0;
                            if (model.getC_ProjectCategory().getProjectCategory().equalsIgnoreCase("N")) {
                                user1_ID = this.getUser1_ID(model.get_TrxName(), contractID, "('AC')");
                            } else if (model.getC_ProjectCategory().getProjectCategory().equalsIgnoreCase("W")) {
                                user1_ID = this.getUser1_ID(model.get_TrxName(), contractID, "('AM')");
                            } else if (model.getC_ProjectCategory().getProjectCategory().equalsIgnoreCase("A")) {
                                user1_ID = this.getUser1_ID(model.get_TrxName(), contractID, "('ARP')");
                            } else if (model.getC_ProjectCategory().getProjectCategory().equalsIgnoreCase("S")) {
                                user1_ID = this.getUser1_ID(model.get_TrxName(), contractID, "('AMD')");
                            }
                            if (user1_ID > 0) {
                                model.setUser4_ID(user1_ID);
                            } else {
                                boolean user4_Mandatory = MSysConfig.getBooleanValue("UY_USER4_ID_MANDATORY", false, this.getAD_Client_ID());
                                if (user4_Mandatory) {
                                    throw new AdempiereException("ERROR: No se obtuvo sello origen.");
                                }
                            }
                        }
                    } else {
                        model.setUser4_ID(0);
                    }
                }
                if (model.is_ValueChanged("AD_Org_ID") || model.is_ValueChanged("User1_ID") || model.is_ValueChanged("S_Contract_ID")) {
                    boolean user1_Mandatory = MSysConfig.getBooleanValue("UY_USER1_ID_MANDATORY", false, this.getAD_Client_ID());
                    Object sql = "select ad_tree_user1_id from pa_hierarchy";
                    int treeUser1ID = DB.getSQLValueEx(model.get_TrxName(), (String)sql, new Object[0]);
                    if (treeUser1ID <= 0 && user1_Mandatory) {
                        throw new AdempiereException("ERROR: No se obtuvo \u00e1rbol de sello");
                    }
                    sql = "select 1 from c_elementvalue where c_elementvalue_id IN (select v.c_elementvalue_id  from ad_treenode t join c_elementvalue v on t.node_id = v.c_elementvalue_id join c_elementvalue parent on parent.c_elementvalue_id = t.parent_id where t.ad_tree_id = " + treeUser1ID + " and parent.ad_org_id = " + model.getAD_Org_ID() + ") and c_elementvalue_id = " + model.getUser1_ID();
                    int value = DB.getSQLValueEx(model.get_TrxName(), (String)sql, new Object[0]);
                    if (value <= 0 && user1_Mandatory) {
                        throw new AdempiereException("ERROR: El sello seleccionado no pertenece a la organizaci\u00f3n");
                    }
                    if (model.get_ValueAsInt("S_Contract_ID") > 0) {
                        MSContract contract = new MSContract(model.getCtx(), model.get_ValueAsInt("S_Contract_ID"), model.get_TrxName());
                        if (contract.getAD_Org_ID() != model.getAD_Org_ID()) {
                            throw new AdempiereException("ERROR: El contrato seleccionado no pertenece a la organizaci\u00f3n");
                        }
                        if (user1_Mandatory && contract.getUser1_ID() != model.getUser1_ID()) {
                            throw new AdempiereException("ERROR: El sello del contrato es distinto al sello del proyecto");
                        }
                    }
                }
            }
        } else if (po instanceof MInOut) {
            MInOut model = (MInOut)po;
            if (1 == type) {
                MInOut refInOut;
                MProject project;
                if (model.getC_Project_ID() > 0 && (project = (MProject)model.getC_Project()).get_ValueAsInt("S_Contract_ID") > 0) {
                    model.set_ValueOfColumn("S_Contract_ID", (Object)project.get_ValueAsInt("S_Contract_ID"));
                }
                if (model.getRef_InOut_ID() > 0 && (refInOut = new MInOut(model.getCtx(), model.getRef_InOut_ID(), model.get_TrxName())).getUser3_ID() > 0) {
                    model.setUser1_ID(refInOut.getUser3_ID());
                    model.setUser3_ID(refInOut.getUser1_ID());
                }
            }
        } else if (po instanceof MCommissionAmt) {
            MCommissionAmt mCommissionAmt = (MCommissionAmt)po;
            try {
                if (mCommissionAmt.getPercentage() == null || mCommissionAmt.getPercentage().compareTo(Env.ZERO) <= 0) {
                    mCommissionAmt.setPercentage(mCommissionAmt.getC_CommissionLine().getAmtMultiplier().multiply(Env.ONEHUNDRED));
                }
            }
            catch (Exception refInOut) {}
        } else if (po instanceof MInvoice) {
            MInvoice refInvoice;
            MInvoice invoice;
            if (1 == type && (invoice = (MInvoice)po).getRef_Invoice_ID() > 0 && (refInvoice = new MInvoice(invoice.getCtx(), invoice.getRef_Invoice_ID(), invoice.get_TrxName())).getUser3_ID() > 0) {
                invoice.setUser1_ID(refInvoice.getUser3_ID());
                invoice.setUser3_ID(refInvoice.getUser1_ID());
            }
        } else if (po instanceof MProjectLine) {
            MProjectLine line = (MProjectLine)po;
            if ((1 == type || 2 == type && (line.is_ValueChanged("M_Product_ID") || line.is_ValueChanged("DescriptionURL"))) && line.getM_Product_ID() > 0) {
                MProduct prod = (MProduct)line.getM_Product();
                String value = line.get_ValueAsString("DescriptionURL");
                if (prod.isWebStoreFeatured() && (value == null || value.trim().isEmpty())) {
                    throw new AdempiereException("ERROR: Campo Landing de Campa\u00f1a es obligatorio para el producto '" + prod.getName() + "'");
                }
            }
        }
        return null;
    }

    private void validateSOForProject(MOrder model) {
        Object sql = "";
        Object where = "";
        int phaseID = model.get_ValueAsInt("C_ProjectPhase_ID");
        int taskID = model.get_ValueAsInt("C_ProjectTask_ID");
        if (taskID > 0) {
            where = "and c_projecttask_id = " + taskID + " and c_projectphase_id = " + phaseID;
        } else if (phaseID > 0) {
            where = "and c_projectphase_id = " + phaseID + " and c_projecttask_id is null";
        }
        if (!((String)where).equalsIgnoreCase("")) {
            sql = "select c_order_id from c_order where issotrx = 'Y' and docstatus <> 'VO' " + (String)where;
            int orderID = DB.getSQLValueEx(model.get_TrxName(), (String)sql, new Object[0]);
            if (orderID > 0) {
                MOrder o = new MOrder(model.getCtx(), orderID, model.get_TrxName());
                throw new AdempiereException("No se permite generar nueva orden de venta, ya existe la orden nro. " + o.getDocumentNo());
            }
        }
    }

    private int getUser1_ID(String trxName, int contractID, String wherePartiesType) {
        String sql = "select p.user1_id from s_contractparties p join s_contractpartiestype pt on p.s_contractpartiestype_id = pt.s_contractpartiestype_id where p.isactive = 'Y' and p.s_contract_id = " + contractID + " and pt.value in " + wherePartiesType;
        int user1_ID = DB.getSQLValueEx(trxName, sql, new Object[0]);
        return user1_ID;
    }

    private void updateRfqLineQty(MRfQResponse model) {
        for (MRfQResponseLine resLine : model.getLines()) {
            for (MRfQResponseLineQty resLineQty : resLine.getQtys()) {
                MRfQLineQty lineQty = (MRfQLineQty)resLineQty.getC_RfQLineQty();
                lineQty.setBestResponseAmt(resLineQty.getPrice());
                lineQty.setMargin((BigDecimal)resLineQty.get_Value("Margin"));
                lineQty.saveEx();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String docValidate(PO po, int timing) {
        this.log.info(po.get_TableName() + " Timing: " + timing);
        String retorno = "";
        if (po instanceof MOrder && timing == 7) {
            MProject project;
            MOrder order = (MOrder)po;
            MDocType docType = (MDocType)order.getC_DocTypeTarget();
            if (!order.isSOTrx()) {
                if (!docType.get_ValueAsBoolean("IsValidateSO")) return null;
                String sql = "select c_order_id from c_order where link_order_id = " + order.get_ID() + " and issotrx = 'Y' and docstatus in ('CO','CL')";
                int linkID = DB.getSQLValueEx(order.get_TrxName(), sql, new Object[0]);
                if (linkID > 0) return null;
                throw new AdempiereException("No se ha encontrado orden de venta completa para este documento");
            }
            X_S_Contract contract = null;
            if (order.get_ValueAsInt("S_Contract_ID") > 0) {
                contract = new MSContract(order.getCtx(), order.get_ValueAsInt("S_Contract_ID"), order.get_TrxName());
            } else if (order.getC_Project_ID() > 0 && (project = (MProject)order.getC_Project()).get_ValueAsInt("S_Contract_ID") > 0) {
                contract = new MSContract(order.getCtx(), project.get_ValueAsInt("S_Contract_ID"), order.get_TrxName());
            }
            if (contract == null || !contract.isSelected() || contract.getC_BPartner_ID() != order.getC_BPartner_ID() || order.getPOReference() != null && !order.getPOReference().equalsIgnoreCase("")) return null;
            int sourceID = this.getOrderSource(order.get_TrxName(), "pendiente");
            if (sourceID <= 0) throw new AdempiereException("No se obtuvo Origen de OV 'Pendiente OC'");
            order.setC_OrderSource_ID(sourceID);
            return null;
        }
        if (po instanceof MOrder && timing == 9) {
            MOrder mOrder = (MOrder)po;
            this.updateProjectProgressLog(mOrder);
            return null;
        }
        if (po instanceof MInvoice && timing == 9) {
            int c_conversionType_ID;
            MInvoice mInvoice = (MInvoice)po;
            try {
                c_conversionType_ID = mInvoice.getC_Order().getC_ConversionType_ID();
            }
            catch (Exception e) {
                c_conversionType_ID = 0;
            }
            int acctCurrency_ID = Utils.getAcctCurrency(mInvoice.getCtx());
            for (MInvoiceLine mInvoiceLine : mInvoice.getLines()) {
                org.compiere.model.MRevenueRecognitionPlan mRevenueRecognitionPlan;
                MOrderLine mOrderLine = (MOrderLine)mInvoiceLine.getC_OrderLine();
                MOrder mOrder = (MOrder)mOrderLine.getC_Order();
                BigDecimal currencyRate = null;
                if (mOrder.get_ValueAsInt("C_Currency_ID_To") > 0) {
                    try {
                        currencyRate = (BigDecimal)mOrder.get_Value("CurrencyRate");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (currencyRate == null || currencyRate.compareTo(Env.ZERO) <= 0) {
                    currencyRate = MConversionRate.getRate(mInvoice.getC_Currency_ID(), acctCurrency_ID, mInvoice.getDateInvoiced(), c_conversionType_ID, mInvoice.getAD_Client_ID(), mInvoice.getAD_Org_ID());
                }
                if ((mRevenueRecognitionPlan = MRevenueRecognitionPlan.forOrder(mOrderLine.get_ID(), mInvoice.getCtx(), mInvoice.get_TrxName())) == null || mRevenueRecognitionPlan.get_ID() <= 0) continue;
                mRevenueRecognitionPlan.set_ValueOfColumn("IsInvoiced", (Object)true);
                mRevenueRecognitionPlan.set_ValueOfColumn("CurrencyRate", (Object)currencyRate);
                mRevenueRecognitionPlan.saveEx();
            }
            return null;
        }
        if (po instanceof MInOut) {
            if (timing == 9) {
                MInOut mInOut = (MInOut)po;
                this.updateProjectProgressLog(mInOut);
                return null;
            } else {
                if (timing != 10) return null;
                MInOut mInOut = (MInOut)po;
                this.updateProjectProgressLog(mInOut);
            }
            return null;
        } else if (po instanceof MCommissionRun && timing == 1) {
            MCommissionRun mCommissionRun = (MCommissionRun)po;
            int c_order_id = mCommissionRun.get_ValueAsInt("C_Order_ID");
            if (c_order_id <= 0) return null;
            mCommissionRun.addFilterValues("C_Order_ID", c_order_id);
            return null;
        } else if (po instanceof MCommissionRun && timing == 11) {
            MCommissionRun mCommissionRun = (MCommissionRun)po;
            Object[] orders = new Query(mCommissionRun.getCtx(), "C_Order", "C_CommissionRun_ID=?", mCommissionRun.get_TrxName()).setParameters(mCommissionRun.get_ID()).list().toArray();
            for (int i = 0; i < orders.length; ++i) {
                MOrder order = (MOrder)orders[i];
                MInvoice[] invoices = order.getInvoices();
                for (int j = 0; j < invoices.length; ++j) {
                    MInvoice invoice = invoices[j];
                    if (!"CO".equals(invoice.getDocStatus()) && !"CL".equals(invoice.getDocStatus())) continue;
                    String sql = "select sum(qtyinvoiced) from c_orderline where c_order_id = " + order.get_ID();
                    int totalInvoiced = DB.getSQLValueEx(mCommissionRun.get_TrxName(), sql, new Object[0]);
                    if (totalInvoiced <= 0) continue;
                    this.generateRequest(order, invoice, 0, true);
                }
                order.set_ValueOfColumn("IsAllowToInvoice", (Object)false);
                order.saveEx();
            }
            return null;
        } else if (po instanceof MTimeExpense && timing == 9) {
            MTimeExpense expense = (MTimeExpense)po;
            if (!expense.get_ValueAsBoolean("IsFromReturn")) return null;
            Hashtable<Integer, Hashtable<Integer, BigDecimal>> orders = new Hashtable<Integer, Hashtable<Integer, BigDecimal>>();
            for (MTimeExpenseLine line : expense.getLines()) {
                MOrderLine salesOrderLine;
                int salesOrderLineId = line.getC_OrderLine_ID();
                int linkOrderLineId = line.get_ValueAsInt("Link_OrderLine_ID");
                if (salesOrderLineId <= 0 && linkOrderLineId <= 0 || line.getQty() == null || line.getQty().compareTo(Env.ZERO) <= 0) continue;
                if (salesOrderLineId > 0) {
                    salesOrderLine = new MOrderLine(expense.getCtx(), salesOrderLineId, expense.get_TrxName());
                    Hashtable<Integer, BigDecimal> salesOrderLines = (Hashtable<Integer, BigDecimal>)orders.get(salesOrderLine.getC_Order_ID());
                    if (salesOrderLines == null) {
                        salesOrderLines = new Hashtable<Integer, BigDecimal>();
                    }
                    salesOrderLines.put(salesOrderLine.getC_OrderLine_ID(), line.getQty());
                    orders.put(salesOrderLine.getC_Order_ID(), salesOrderLines);
                }
                if (linkOrderLineId <= 0) continue;
                salesOrderLine = new MOrderLine(expense.getCtx(), linkOrderLineId, expense.get_TrxName());
                Hashtable<Integer, BigDecimal> purchaseOrderLines = (Hashtable<Integer, BigDecimal>)orders.get(salesOrderLine.getC_Order_ID());
                if (purchaseOrderLines == null) {
                    purchaseOrderLines = new Hashtable<Integer, BigDecimal>();
                }
                purchaseOrderLines.put(salesOrderLine.getC_OrderLine_ID(), line.getQty());
                orders.put(salesOrderLine.getC_Order_ID(), purchaseOrderLines);
            }
            orders.entrySet().stream().forEach(orderSet -> this.generateRMAFromOrder(expense, (Integer)orderSet.getKey(), (Hashtable)orderSet.getValue()));
            return null;
        } else if (po instanceof MOrder && timing == 3) {
            MDocType docType;
            MOrder order = (MOrder)po;
            this.verifyOrderToClose(order, 2);
            if (order.isSOTrx() || !(docType = (MDocType)order.getC_DocTypeTarget()).getDocBaseType().equalsIgnoreCase("POO") || docType.getDocSubTypeSO() == null || !docType.getDocSubTypeSO().equalsIgnoreCase("SO") || !docType.isDefault() || !docType.get_ValueAsBoolean("IsSplitDocuments") || order.getRef_Order_ID() <= 0) return null;
            MOrder refOrder = (MOrder)order.getRef_Order();
            String message = "";
            if (!"CO".equals(refOrder.getDocStatus())) return null;
            if (!refOrder.processIt("CL")) {
                message = refOrder.getProcessMsg();
                throw new AdempiereException(message);
            }
            refOrder.saveEx();
            return null;
        } else if (po instanceof MOrder && timing == 11) {
            MOrder linkOrder;
            MOrder order = (MOrder)po;
            this.verifyOrderToClose(order, 1);
            if (order.isSOTrx() && order.getLink_Order_ID() > 0 && (linkOrder = (MOrder)order.getLink_Order()) != null) {
                String message = "";
                if (linkOrder.getDocStatus().equalsIgnoreCase("CO")) {
                    if (!linkOrder.processIt("CL")) {
                        message = linkOrder.getProcessMsg();
                        throw new AdempiereException(message);
                    }
                    linkOrder.saveEx();
                }
            }
            MOrder mOrder = (MOrder)po;
            this.updateProjectProgressLog(mOrder);
            return null;
        } else {
            if (!(po instanceof MOrder) || timing != 2) return null;
            MOrder order = (MOrder)po;
            this.verifyInvoiceOfOrder(order);
            this.verifyInOutOfOrder(order);
            this.verifyRevenueRecognitionPlan(order);
            Object sql = "";
            int orderID = 0;
            if (!order.isSOTrx()) {
                sql = "select c_order_id from c_order where ref_order_id = " + order.get_ID() + " and issotrx = 'Y' and docstatus not in ('VO','RE')";
                orderID = DB.getSQLValueEx(order.get_TrxName(), (String)sql, new Object[0]);
                if (orderID <= 0) return null;
                MOrder sOrder = new MOrder(order.getCtx(), orderID, order.get_TrxName());
                throw new AdempiereException("ERROR: No se permite anular, previamente debe anular la OV interna nro. '" + sOrder.getDocumentNo() + "'");
            }
            if (order.getAD_Org_ID() != 2000004) return null;
            sql = "SELECT o.C_Order_ID FROM C_Order o JOIN C_OrderLine ol ON ol.C_Order_ID = o.C_Order_ID WHERE o.issotrx = 'N' AND docstatus NOT IN ('VO','RE') AND EXISTS (SELECT ol2.C_OrderLine_ID FROM C_OrderLine ol2 WHERE ol2.C_Order_ID = " + order.get_ID() + " AND ol2.C_OrderLine_ID = ol.Link_OrderLine_ID)";
            orderID = DB.getSQLValueEx(order.get_TrxName(), (String)sql, new Object[0]);
            if (orderID <= 0) return null;
            MOrder pOrder = new MOrder(order.getCtx(), orderID, order.get_TrxName());
            throw new AdempiereException("ERROR: No se permite anular, previamente debe anular la OC nro. '" + pOrder.getDocumentNo() + "'");
        }
    }

    private void verifyInOutOfOrder(MOrder order) {
        MInOut[] shipments = order.getShipments();
        for (int i = 0; i < shipments.length; ++i) {
            MInOut ship = shipments[i];
            if (!"CO".equals(ship.getDocStatus()) && !"CL".equals(ship.getDocStatus()) && !"DR".equals(ship.getDocStatus()) && !"IP".equals(ship.getDocStatus()) && !"IN".equals(ship.getDocStatus())) continue;
            throw new AdempiereException("Esta tratando de Anular un Documento que esta facturado o tiene un checking asociado, si esta seguro que quiere anularlo, se debe anular la factura o el checking relacionado a la Orden '" + order.getDocumentNo() + "'");
        }
    }

    private void verifyInvoiceOfOrder(MOrder order) {
        MInvoice[] invoices = order.getInvoices();
        for (int i = 0; i < invoices.length; ++i) {
            MInvoice invoice = invoices[i];
            if (!"CO".equals(invoice.getDocStatus()) && !"CL".equals(invoice.getDocStatus()) && !"DR".equals(invoice.getDocStatus()) && !"IP".equals(invoice.getDocStatus()) && !"IN".equals(invoice.getDocStatus())) continue;
            throw new AdempiereException("Esta tratando de Anular un Documento que esta facturado o tiene un checking asociado, si esta seguro que quiere anularlo, se debe anular la factura o el checking relacionado a la Orden '" + order.getDocumentNo() + "'");
        }
    }

    private void verifyRevenueRecognitionPlan(MOrder mOrder) {
        String query = "EXISTS (SELECT 1 FROM C_OrderLine WHERE C_Order_ID=? AND C_OrderLine_ID=C_RevenueRecognition_Plan.C_OrderLine_ID)";
        List mRevenueRecognitionPlans = new Query(mOrder.getCtx(), "C_RevenueRecognition_Plan", query, mOrder.get_TrxName()).setParameters(mOrder.get_ID()).list();
        ArrayList<MRevenueRecognitionRun> mRevenueRecognitionRuns = new ArrayList<MRevenueRecognitionRun>();
        for (org.compiere.model.MRevenueRecognitionPlan mRevenueRecognitionPlan : mRevenueRecognitionPlans) {
            mRevenueRecognitionRuns.addAll(mRevenueRecognitionPlan.getMRevenueRecognitionRuns());
        }
        if (mRevenueRecognitionRuns.stream().filter(mRevenueRecognitionRun -> mRevenueRecognitionRun.getGL_Journal_ID() > 0).map(mRevenueRecognitionRun -> (MJournal)mRevenueRecognitionRun.getGL_Journal()).anyMatch(mJournal -> "CO".equalsIgnoreCase(mJournal.getDocStatus()))) {
            throw new AdempiereException("Plan de Reconocimiento de Ingresos para la Orden nro " + mOrder.getDocumentNo() + " tiene asientos definidos");
        }
        for (MRevenueRecognitionRun mRevenueRecognitionRun2 : mRevenueRecognitionRuns) {
            mRevenueRecognitionRun2.deleteEx(true);
        }
        for (org.compiere.model.MRevenueRecognitionPlan mRevenueRecognitionPlan : mRevenueRecognitionPlans) {
            mRevenueRecognitionPlan.deleteEx(true);
        }
    }

    private void verifyOrderToClose(MOrder order, int control) {
        if (order != null) {
            if (control == 1) {
                MOrderLine[] lines = order.getLines(" AND (IsCompensated = 'N' AND IsSubstitute = 'N')", "Line");
                for (int i = 0; i < lines.length; ++i) {
                    int invoiceLineID;
                    MOrderLine orderLine = lines[i];
                    if (orderLine.getQtyInvoiced().compareTo(orderLine.getQtyOrdered()) <= 0 || (invoiceLineID = orderLine.getC_InvoiceLine_ID()) <= 0) continue;
                    MInvoiceLine invLine = new MInvoiceLine(order.getCtx(), invoiceLineID, order.get_TrxName());
                    MInvoice invoice = (MInvoice)invLine.getC_Invoice();
                    if (order.isSOTrx()) {
                        if (order.get_ValueAsInt("M_RMAType_ID") > 0) {
                            this.generateRequest(order, invoice, order.get_ValueAsInt("M_RMAType_ID"), false);
                            continue;
                        }
                        throw new AdempiereException("ERROR: Debe indicar un Motivo de NC para Cerrar este documento");
                    }
                    if (order.get_ValueAsInt("M_RMAType_ID") > 0) {
                        this.generateRequest(order, invoice, order.get_ValueAsInt("M_RMAType_ID"), false);
                        continue;
                    }
                    String sql = "select c_order_id from c_order where link_order_id = " + order.get_ID() + " and issotrx = 'Y' and docstatus in ('CO','CL')";
                    int linkID = DB.getSQLValueEx(order.get_TrxName(), sql, new Object[0]);
                    if (linkID > 0) {
                        MOrder linkOrderSO = new MOrder(order.getCtx(), linkID, order.get_TrxName());
                        order.set_ValueOfColumn("M_RMAType_ID", (Object)linkOrderSO.get_ValueAsInt("M_RMAType_ID"));
                        order.saveEx();
                        this.generateRequest(order, invoice, linkOrderSO.get_ValueAsInt("M_RMAType_ID"), false);
                        continue;
                    }
                    throw new AdempiereException("ERROR: No se obtuvo Orden de Venta asociada a la Orden de Compra '" + order.getDocumentNo() + "'");
                }
            } else if (control == 2) {
                Object sql = "";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                sql = "select coalesce(sum(ol.linenetamt),0) as totalamt from c_orderline ol where ol.c_order_id = " + order.get_ID() + " and (ol.iscompensated = 'Y' or ol.issubstitute = 'Y')";
                BigDecimal amtOrdered = DB.getSQLValueBDEx(order.get_TrxName(), (String)sql, new Object[0]);
                sql = "select coalesce(sum(il.linenetamt),0) as totalamt from c_invoiceline il join c_invoice i on il.c_invoice_id = i.c_invoice_id join c_orderline ol on il.c_orderline_id = ol.c_orderline_id where i.docstatus in ('CO','CL') and (ol.iscompensated = 'Y' or ol.issubstitute = 'Y') and ol.c_order_id = " + order.get_ID();
                BigDecimal amtInvoiced = DB.getSQLValueBDEx(order.get_TrxName(), (String)sql, new Object[0]);
                if (amtInvoiced.compareTo(amtOrdered) > 0) {
                    BigDecimal amtDiff = amtInvoiced.subtract(amtOrdered);
                    sql = "select sum(il.linenetamt) as totalamt, i.c_invoice_id from c_invoiceline il join c_invoice i on il.c_invoice_id = i.c_invoice_id join c_orderline ol on il.c_orderline_id = ol.c_orderline_id where i.docstatus in ('CO','CL') and ol.c_order_id = " + order.get_ID() + " and (ol.iscompensated = 'Y' or ol.issubstitute = 'Y') group by i.c_invoice_id order by i.c_invoice_id";
                    try {
                        pstmt = DB.prepareStatement((String)sql, order.get_TrxName());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            BigDecimal amt = rs.getBigDecimal("TotalAmt");
                            int invoiceID = rs.getInt("C_Invoice_ID");
                            if (order.isSOTrx()) {
                                if (order.get_ValueAsInt("M_RMAType_ID") > 0) {
                                    this.generateRequest2(order, invoiceID, amtDiff, order.get_ValueAsInt("M_RMAType_ID"));
                                    continue;
                                }
                                throw new AdempiereException("ERROR: Debe indicar un Motivo de NC para Cerrar este documento");
                            }
                            if (order.get_ValueAsInt("M_RMAType_ID") > 0) {
                                this.generateRequest2(order, invoiceID, amtDiff, order.get_ValueAsInt("M_RMAType_ID"));
                                continue;
                            }
                            sql = "select c_order_id from c_order where link_order_id = " + order.get_ID() + " and issotrx = 'Y' and docstatus in ('CO','CL')";
                            int linkID = DB.getSQLValueEx(order.get_TrxName(), (String)sql, new Object[0]);
                            if (linkID > 0) {
                                MOrder linkOrderSO = new MOrder(order.getCtx(), linkID, order.get_TrxName());
                                order.set_ValueOfColumn("M_RMAType_ID", (Object)linkOrderSO.get_ValueAsInt("M_RMAType_ID"));
                                order.saveEx();
                                this.generateRequest2(order, invoiceID, amtDiff, linkOrderSO.get_ValueAsInt("M_RMAType_ID"));
                                continue;
                            }
                            throw new AdempiereException("ERROR: No se obtuvo Orden de Venta asociada a la Orden de Compra '" + order.getDocumentNo() + "'");
                        }
                    }
                    catch (Exception e) {
                        try {
                            throw new AdempiereException(e.getMessage());
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            throw throwable;
                        }
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateRequest(MOrder order, MInvoice invoice, int rmaTypeID, boolean IsAmtFromOrder) {
        try {
            Timestamp today = new Timestamp(System.currentTimeMillis());
            MRequest request = new MRequest(order.getCtx(), 0, order.get_TrxName());
            request.setC_Order_ID(order.get_ID());
            request.setC_Invoice_ID(invoice.get_ID());
            request.setC_Project_ID(order.getC_Project_ID());
            request.setC_BPartner_ID(order.getC_BPartner_ID());
            if (IsAmtFromOrder) {
                request.setRequestAmt(order.getTotalLines());
            } else {
                String sql = "select sum (il.linenetamt) - o.totallines as diff from c_invoiceline il join c_orderline ol on il.c_orderline_id = ol.c_orderline_id join c_order o on ol.c_order_id = o.c_order_id where il.c_invoice_id = " + invoice.get_ID() + " and o.c_order_id = " + order.get_ID() + " group by o.totallines";
                BigDecimal diffAmt = DB.getSQLValueBDEx(order.get_TrxName(), sql, new Object[0]);
                request.setRequestAmt(diffAmt);
            }
            if (order.isSOTrx()) {
                request.setR_RequestType_ID(1000004);
                if (order.get_ValueAsInt("M_RMA_ID") > 0) {
                    request.setSubject("NOTA DE CREDITO CLIENTE POR DEVOLUCION");
                } else {
                    request.setSubject("NOTA DE CREDITO CLIENTE");
                }
                request.setSummary("Se solicita nota de cr\u00e9dito cliente");
            } else {
                request.setR_RequestType_ID(1000005);
                if (order.get_ValueAsInt("M_RMA_ID") > 0) {
                    request.setSubject("NOTA DE CREDITO PROVEEDOR POR DEVOLUCION");
                } else {
                    request.setSubject("NOTA DE CREDITO PROVEEDOR");
                }
                request.setSummary("Se solicita nota de cr\u00e9dito proveedor");
            }
            request.setAD_Table_ID(I_C_Order.Table_ID);
            request.setRecord_ID(order.get_ID());
            request.setAD_Org_ID(order.getAD_Org_ID());
            request.setDateStartPlan(today);
            if (rmaTypeID > 0) {
                request.set_ValueOfColumn("M_RMAType_ID", (Object)rmaTypeID);
            }
            if (order.get_ValueAsInt("M_RMA_ID") > 0) {
                request.setM_RMA_ID(order.get_ValueAsInt("M_RMA_ID"));
            }
            if (order.isSOTrx()) {
                MStandardRequest req = this.getStandardRequest(order.getCtx(), order.get_TrxName());
                if (req == null) throw new AdempiereException("ERROR: No se obtuvo tipo de solicitud est\u00e1ndar");
                request.setAD_Role_ID(req.getAD_Role_ID());
                request.setSalesRep_ID(req.getSalesRep_ID());
                request.setR_Group_ID(req.getR_Group_ID());
            } else {
                request.setSalesRep_ID(order.getSalesRep_ID());
            }
            request.saveEx();
            if (invoice.isSOTrx()) return;
            invoice.setIsInDispute(true);
            invoice.saveEx();
            return;
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateRequest2(MOrder order, int invoiceID, BigDecimal amtDiff, int rmaTypeID) {
        try {
            MInvoice invoice = new MInvoice(order.getCtx(), invoiceID, order.get_TrxName());
            Timestamp today = new Timestamp(System.currentTimeMillis());
            MRequest request = new MRequest(order.getCtx(), 0, order.get_TrxName());
            request.setC_Order_ID(order.get_ID());
            request.setC_Invoice_ID(invoice.get_ID());
            request.setC_Project_ID(order.getC_Project_ID());
            request.setC_BPartner_ID(order.getC_BPartner_ID());
            request.setRequestAmt(amtDiff);
            if (order.isSOTrx()) {
                request.setR_RequestType_ID(1000004);
                if (order.get_ValueAsInt("M_RMA_ID") > 0) {
                    request.setSubject("NOTA DE CREDITO CLIENTE POR DEVOLUCION");
                } else {
                    request.setSubject("NOTA DE CREDITO CLIENTE");
                }
                request.setSummary("Se solicita nota de cr\u00e9dito cliente");
            } else {
                request.setR_RequestType_ID(1000005);
                if (order.get_ValueAsInt("M_RMA_ID") > 0) {
                    request.setSubject("NOTA DE CREDITO PROVEEDOR POR DEVOLUCION");
                } else {
                    request.setSubject("NOTA DE CREDITO PROVEEDOR");
                }
                request.setSummary("Se solicita nota de cr\u00e9dito proveedor");
            }
            request.setAD_Table_ID(I_C_Order.Table_ID);
            request.setRecord_ID(order.get_ID());
            request.setAD_Org_ID(order.getAD_Org_ID());
            request.setDateStartPlan(today);
            request.set_ValueOfColumn("M_RMAType_ID", (Object)rmaTypeID);
            if (order.get_ValueAsInt("M_RMA_ID") > 0) {
                request.setM_RMA_ID(order.get_ValueAsInt("M_RMA_ID"));
            }
            if (order.isSOTrx()) {
                MStandardRequest req = this.getStandardRequest(order.getCtx(), order.get_TrxName());
                if (req == null) throw new AdempiereException("ERROR: No se obtuvo tipo de solicitud est\u00e1ndar");
                request.setAD_Role_ID(req.getAD_Role_ID());
                request.setSalesRep_ID(req.getSalesRep_ID());
                request.setR_Group_ID(req.getR_Group_ID());
            } else {
                request.setSalesRep_ID(order.getSalesRep_ID());
            }
            request.saveEx();
            if (invoice.isSOTrx()) return;
            invoice.setIsInDispute(true);
            invoice.saveEx();
            return;
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private MStandardRequest getStandardRequest(Properties ctx, String trx) {
        MStandardRequest req = null;
        String sql = "select r_standardrequestType_id from r_standardrequestType where value = 'OrderCloseControl'";
        int stdReq_ID = DB.getSQLValueEx(trx, sql, new Object[0]);
        if (stdReq_ID > 0) {
            MStandardRequestType rType = new MStandardRequestType(ctx, stdReq_ID, trx);
            List<MStandardRequest> standardRequests = rType.getStandardRequest(true);
            Iterator<MStandardRequest> iterator = standardRequests.iterator();
            while (iterator.hasNext()) {
                MStandardRequest request;
                req = request = iterator.next();
            }
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateRMAFromOrder(MTimeExpense expenseReport, int orderId, Hashtable<Integer, BigDecimal> lines) {
        int docTypeInout_ID = 0;
        int doctypeRMA_ID = 0;
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        int inoutID = 0;
        MRMA rma = null;
        try {
            MOrder order = new MOrder(expenseReport.getCtx(), orderId, expenseReport.get_TrxName());
            if (order.isSOTrx()) {
                docTypeInout_ID = MDocType.getDocType("MMR", "AND IsSOTrx = 'Y'");
                doctypeRMA_ID = MDocType.getDocType("SOO", "AND DocSubTypeSO = 'RM' AND IsSOTrx = 'Y'");
            } else {
                docTypeInout_ID = MDocType.getDocType("MMS", "AND IsSOTrx = 'N'");
                doctypeRMA_ID = MDocType.getDocType("POO", "AND DocSubTypeSO = 'RM' AND IsSOTrx = 'N'");
            }
            if (doctypeRMA_ID <= 0) {
                throw new AdempiereException("No se obtuvo tipo de documento de RMA");
            }
            if (docTypeInout_ID <= 0) {
                throw new AdempiereException("No se obtuvo tipo de documento de Devoluci\u00f3n");
            }
            sql = "select ml.m_inout_id, ml.m_inoutline_id, tl.qty, ol.priceentered from s_timeexpenseline tl left join c_orderline ol on (tl.c_orderline_id = ol.c_orderline_id or tl.link_orderline_id = ol.c_orderline_id) inner join c_order o on ol.c_order_id = o.c_order_id inner join m_inoutline ml on ol.c_orderline_id = ml.c_orderline_id left join m_inout io on ml.m_inout_id = io.m_inout_id where tl.s_timeexpense_id = " + expenseReport.get_ID() + " and o.c_order_id = " + orderId + " and io.docstatus in ('CO','CL') order by ml.m_inout_id";
            pstmt = DB.prepareStatement((String)sql, expenseReport.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int inout_ID = rs.getInt("M_InOut_ID");
                BigDecimal qty = rs.getBigDecimal("Qty");
                BigDecimal price = rs.getBigDecimal("PriceEntered");
                if (inoutID != inout_ID) {
                    if (rma != null) {
                        if (!rma.processIt("CO")) {
                            throw new AdempiereException(rma.getProcessMsg());
                        }
                        rma.saveEx();
                        this.generateReturn(expenseReport, rma, order, docTypeInout_ID);
                    }
                    MInOut inout = new MInOut(expenseReport.getCtx(), inout_ID, expenseReport.get_TrxName());
                    rma = new MRMA(expenseReport.getCtx(), 0, expenseReport.get_TrxName());
                    rma.setAD_Org_ID(expenseReport.getAD_Org_ID());
                    rma.setC_DocType_ID(doctypeRMA_ID);
                    rma.setName("GENERADO DESDE INFORME DE GASTO Nro. " + expenseReport.getDocumentNo());
                    rma.setM_RMAType_ID(1000000);
                    rma.setM_InOut_ID(inout_ID);
                    rma.setC_BPartner_ID(inout.getC_BPartner_ID());
                    rma.setSalesRep_ID(Env.getAD_User_ID(expenseReport.getCtx()));
                    rma.set_ValueOfColumn("S_TimeExpense_ID", (Object)expenseReport.get_ID());
                    rma.setIsSOTrx(order.isSOTrx());
                    rma.setDocStatus("DR");
                    rma.saveEx();
                    inoutID = inout_ID;
                }
                MRMALine line = new MRMALine(rma.getCtx(), 0, rma.get_TrxName());
                line.setM_RMA_ID(rma.get_ID());
                line.setM_InOutLine_ID(rs.getInt("M_InoutLine_ID"));
                line.setQty(qty);
                line.setAmt(price);
                line.saveEx();
            }
            if (rma != null) {
                if (!rma.processIt("CO")) {
                    throw new AdempiereException(rma.getProcessMsg());
                }
                rma.saveEx();
                this.generateReturn(expenseReport, rma, order, docTypeInout_ID);
            }
            order.set_ValueOfColumn("M_RMA_ID", (Object)rma.get_ID());
            order.saveEx();
            if (expenseReport.get_ValueAsBoolean("IsCloseDocument")) {
                order.set_ValueOfColumn("M_RMAType_ID", expenseReport.get_Value("M_RMAType_ID"));
                order.saveEx();
                if (!order.processIt("CL")) {
                    throw new AdempiereException(rma.getProcessMsg());
                }
                order.saveEx();
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.warning(e.getMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void generateReturn(MTimeExpense expense, MRMA rma, MOrder order, int docTypeID) {
        MBPartner partner = (MBPartner)rma.getC_BPartner();
        MInOut hdr = new MInOut(rma.getCtx(), 0, rma.get_TrxName());
        hdr.setIsSOTrx(order.isSOTrx());
        hdr.setC_DocType_ID(docTypeID);
        hdr.setC_BPartner_ID(rma.getC_BPartner_ID());
        hdr.setC_BPartner_Location_ID(partner.getPrimaryC_BPartner_Location_ID());
        hdr.setMovementDate(expense.getDateReport());
        hdr.setDateAcct(expense.getDateReport());
        hdr.setM_Warehouse_ID(order.getM_Warehouse_ID());
        hdr.setSalesRep_ID(Env.getAD_User_ID(rma.getCtx()));
        hdr.setC_Project_ID(order.getC_Project_ID());
        hdr.setM_RMA_ID(rma.get_ID());
        hdr.set_ValueOfColumn("S_TimeExpense_ID", (Object)expense.get_ID());
        hdr.setDocStatus("DR");
        if (order.isSOTrx()) {
            hdr.setMovementType("C+");
        } else {
            hdr.setMovementType("V-");
        }
        hdr.saveEx();
        for (MRMALine rLine : rma.getLines(true)) {
            MInOutLine ioLine = (MInOutLine)rLine.getM_InOutLine();
            MInOutLine iLine = new MInOutLine(rma.getCtx(), 0, rma.get_TrxName());
            iLine.setM_InOut_ID(hdr.get_ID());
            iLine.setM_RMALine_ID(rLine.getM_RMALine_ID());
            iLine.setM_Product_ID(ioLine.getM_Product_ID(), true);
            iLine.setQtyEntered(rLine.getQty());
            iLine.setMovementQty(rLine.getQty());
            iLine.setDescription(rLine.getDescription());
            iLine.setM_AttributeSetInstance_ID(rLine.getM_AttributeSetInstance_ID());
            iLine.setC_Project_ID(rLine.getC_Project_ID());
            iLine.setC_ProjectPhase_ID(rLine.getC_ProjectPhase_ID());
            iLine.setC_ProjectTask_ID(rLine.getC_ProjectTask_ID());
            iLine.setC_Activity_ID(rLine.getC_Activity_ID());
            iLine.setAD_OrgTrx_ID(rLine.getAD_OrgTrx_ID());
            iLine.setUser1_ID(rLine.getUser1_ID());
            iLine.setUser2_ID(rLine.getUser2_ID());
            iLine.setUser3_ID(rLine.getUser3_ID());
            iLine.setUser4_ID(rLine.getUser4_ID());
            iLine.saveEx();
        }
        if (!hdr.processIt("CO")) {
            throw new AdempiereException(rma.getProcessMsg());
        }
        hdr.saveEx();
    }

    private MTax getForcedTax(Properties ctx, int ad_client_id, int ad_org_id) {
        MTax forcedTax = null;
        try {
            forcedTax = MTax.get(ctx, Integer.valueOf(MSysConfig.getValue("UY_FORCED_TAX", "0", ad_client_id, ad_org_id)));
            if (forcedTax.get_ID() <= 0) {
                forcedTax = null;
            }
        }
        catch (Exception e) {
            forcedTax = null;
        }
        return forcedTax;
    }

    private int getOrderSource(String trxName, String value) {
        String sql = "select c_ordersource_id from c_ordersource where value = '" + value + "'";
        int sourceID = DB.getSQLValueEx(trxName, sql, new Object[0]);
        return sourceID;
    }

    private void updateProjectProgressLog(MInOut mInOut) {
        PO mProject = null;
        try {
            mProject = (MProject)Utils.when((o1, o2) -> o1.getC_Project_ID() > 0, mInOut.getC_Project(), mInOut.getC_Order().getC_Project());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mProject != null && mProject.get_ID() > 0) {
            ProcessBuilder.create(mProject.getCtx()).process(MProcess.getProcess_ID(UpdateProjectProgressLog.getProcessValue(), mProject.get_TrxName())).withParameter("C_Project_ID", mProject.get_ID()).withoutTransactionClose().execute(mProject.get_TrxName());
        }
    }

    private void updateProjectProgressLog(MOrder mOrder) {
        MProject mProject = null;
        try {
            mProject = (MProject)mOrder.getC_Project();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mProject != null && mProject.get_ID() > 0) {
            this.updateProjectProgressLog(mOrder.getCtx(), mOrder.get_TrxName(), mProject.get_ID());
        }
    }

    private void updateProjectProgressLog(Properties ctx, String trxName, int c_project_id) {
        if (c_project_id > 0) {
            ProcessBuilder.create(ctx).process(MProcess.getProcess_ID(UpdateProjectProgressLog.getProcessValue(), trxName)).withParameter("C_Project_ID", c_project_id).withoutTransactionClose().execute(trxName);
        }
    }
}

