/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.X_UY_PayReceiptLine;

public class MUYPayReceiptLine
extends X_UY_PayReceiptLine {
    public MUYPayReceiptLine(Properties ctx, int UY_PayReceiptLine_ID, String trxName) {
        super(ctx, UY_PayReceiptLine_ID, trxName);
    }

    public MUYPayReceiptLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.setHeader();
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            MCashLine line;
            this.setHeader();
            if (this.getC_Payment_ID() > 0) {
                DB.executeUpdateEx("delete from c_payment where c_payment_id = " + this.getC_Payment_ID() + " and docstatus = 'DR'", this.get_TrxName());
            }
            if (this.getC_CashLine_ID() > 0 && (line = new MCashLine(this.getCtx(), this.getC_CashLine_ID(), this.get_TrxName())) != null && line.get_ID() > 0) {
                MCash cash = (MCash)line.getC_Cash();
                if (cash.getDocStatus().equalsIgnoreCase("DR")) {
                    line.deleteEx(true);
                } else {
                    throw new AdempiereException("El Diario de Caja actual no esta en estado borrador");
                }
            }
        }
        return success;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MUYPayReceipt hdr = new MUYPayReceipt(this.getCtx(), this.getUY_PayReceipt_ID(), this.get_TrxName());
        if (newRecord && hdr.isSOTrx() && hdr.get_ValueAsBoolean("IsRepresentation") && hdr.getLinesDef().size() > 0) {
            throw new AdempiereException("Ya hay cheques diferidos generados para este documento, no se permiten diferentes medios de pago");
        }
        if (newRecord) {
            this.set_ValueOfColumn("AmtToAllocate", (Object)this.getPayAmt());
        }
        return true;
    }

    private void setHeader() {
        MUYPayReceipt hdr = (MUYPayReceipt)this.getUY_PayReceipt();
        Object sql = "";
        BigDecimal amtAllocated = Env.ZERO;
        amtAllocated = hdr.isSOTrx() ? this.getTotalPayAmt("", " AND dt.DocBaseType NOT IN ('ARI','ARC','DPC','DRC')") : this.getTotalPayAmt("", " AND dt.DocBaseType NOT IN ('API','APC','DPC','DRC')");
        sql = "SELECT COALESCE(SUM(PayAmt),0) FROM UY_PayReceiptLine WHERE IsActive='Y' AND UY_PayReceipt_ID=" + this.getUY_PayReceipt_ID();
        BigDecimal payAmt = DB.getSQLValueBDEx(this.get_TrxName(), (String)sql, new Object[0]);
        sql = "SELECT COALESCE(SUM(AmtSource),0) FROM UY_PayReceiptDef WHERE IsActive='Y' AND UY_PayReceipt_ID=" + this.getUY_PayReceipt_ID();
        BigDecimal amtSource = DB.getSQLValueBDEx(this.get_TrxName(), (String)sql, new Object[0]);
        BigDecimal totalAllocated = amtSource.add(payAmt).subtract(amtAllocated);
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET AllocatedAmt = " + totalAllocated + " where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET PayAmt = " + totalAllocated + " where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET OpenAmt = (" + totalAllocated + " - AmtToAllocate) * -1 where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET ChargeAmt = (" + totalAllocated + " - AmtToAllocate) * -1 where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
    }

    private BigDecimal getTotalPayAmt(String trx, String docBaseType) {
        String sql = "SELECT COALESCE(SUM(d.PayAmt),0) FROM UY_PayReceiptDoc d JOIN C_Invoice i ON d.C_Invoice_ID = i.C_Invoice_ID JOIN C_DocType dt ON i.C_DocTypeTarget_ID = dt.C_DocType_ID WHERE d.IsActive = 'Y' AND d.UY_PayReceipt_ID = " + this.getUY_PayReceipt_ID() + trx + docBaseType;
        BigDecimal payAmt = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
        return payAmt;
    }

    public static MUYPayReceiptLine getFirst(Properties ctx, int payReceipt_ID, String trx) {
        String whereClause = "UY_PayReceipt_ID = ?";
        MUYPayReceiptLine model = (MUYPayReceiptLine)new Query(ctx, "UY_PayReceiptLine", whereClause, trx).setParameters(payReceipt_ID).setOnlyActiveRecords(true).setOrderBy("Created ASC").first();
        return model;
    }
}

