/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.X_UY_PayReceiptDoc;

public class MUYPayReceiptDoc
extends X_UY_PayReceiptDoc {
    public MUYPayReceiptDoc(Properties ctx, int UY_PayReceiptDoc_ID, String trxName) {
        super(ctx, UY_PayReceiptDoc_ID, trxName);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.setHeader();
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.setHeader();
        return success;
    }

    private void setHeader() {
        Object sql = "";
        String IsSOTrx = "Y";
        BigDecimal amtToAllocate = Env.ZERO;
        BigDecimal amtAllocated = Env.ZERO;
        MUYPayReceipt hdr = (MUYPayReceipt)this.getUY_PayReceipt();
        if (hdr.isSOTrx()) {
            amtToAllocate = this.getTotalPayAmt(" AND i.issotrx = 'Y'", " AND dt.DocBaseType IN ('ARI','ARC')");
            amtAllocated = this.getTotalPayAmt("", " AND dt.DocBaseType NOT IN ('ARI','ARC','DPC','DRC')");
        } else {
            amtToAllocate = this.getTotalPayAmt(" AND i.issotrx = 'N'", " AND dt.DocBaseType IN ('API','APC')");
            amtAllocated = this.getTotalPayAmt("", " AND dt.DocBaseType NOT IN ('API','APC','DPC','DRC')");
        }
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET AmtToAllocate = " + amtToAllocate + " where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        sql = "SELECT COALESCE(SUM(PayAmt),0) FROM UY_PayReceiptLine WHERE IsActive='Y' AND UY_PayReceipt_ID=" + this.getUY_PayReceipt_ID();
        BigDecimal payAmt = DB.getSQLValueBDEx(this.get_TrxName(), (String)sql, new Object[0]);
        sql = "SELECT COALESCE(SUM(AmtSource),0) FROM UY_PayReceiptDef WHERE IsActive='Y' AND UY_PayReceipt_ID=" + this.getUY_PayReceipt_ID();
        BigDecimal amtSource = DB.getSQLValueBDEx(this.get_TrxName(), (String)sql, new Object[0]);
        BigDecimal totalAllocated = amtSource.add(payAmt).subtract(amtAllocated);
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET AllocatedAmt = " + totalAllocated + " where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET PayAmt = " + totalAllocated + " where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET OpenAmt =  (AllocatedAmt - AmtToAllocate) * -1 where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_PayReceipt SET ChargeAmt =  (AllocatedAmt - AmtToAllocate) * -1 where uy_payreceipt_id = " + this.getUY_PayReceipt_ID(), this.get_TrxName());
    }

    public MUYPayReceiptDoc(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private BigDecimal getTotalPayAmt(String trx, String docBaseType) {
        String sql = "SELECT COALESCE(SUM(d.PayAmt),0) FROM UY_PayReceiptDoc d JOIN C_Invoice i ON d.C_Invoice_ID = i.C_Invoice_ID JOIN C_DocType dt ON i.C_DocTypeTarget_ID = dt.C_DocType_ID WHERE d.IsActive = 'Y' AND d.UY_PayReceipt_ID = " + this.getUY_PayReceipt_ID() + trx + docBaseType;
        BigDecimal payAmt = DB.getSQLValueBDEx(this.get_TrxName(), sql, new Object[0]);
        return payAmt;
    }
}

