/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.openup.core.model.X_UY_Family_Member;
import org.openup.core.process.FamilyUpdateQtyOfChildrenAbstract;
import org.openup.core.utils.ProcessBuilderHelper;

public class MFamily_Member
extends X_UY_Family_Member {
    public MFamily_Member(Properties ctx, int UY_Family_Member_ID, String trxName) {
        super(ctx, UY_Family_Member_ID, trxName);
    }

    public MFamily_Member(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String sysconf_setResponsible = "UY_RelationMember_SetResponsible";
        if (!this.isResponsible()) {
            int hr_relationship_id = MSysConfig.getIntValue(sysconf_setResponsible, 0, this.getAD_Client_ID());
            if (hr_relationship_id <= 0) {
                throw new AdempiereException("@AD_SysConfig_ID@: " + sysconf_setResponsible + " @not.found@");
            }
            if (this.getHR_Relationship_ID() == hr_relationship_id && !new Query(this.getCtx(), "UY_Family_Member", "UY_Family_ID=? AND isResponsible=?", this.get_TrxName()).setParameters(this.getUY_Family_ID(), "Y").match()) {
                this.setisResponsible(true);
            }
        }
        return super.beforeSave(newRecord);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.recalculeQtyOfChildren();
        return super.afterSave(newRecord, success);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.recalculeQtyOfChildren();
        return super.afterDelete(success);
    }

    private void recalculeQtyOfChildren() {
        ProcessBuilderHelper.createAndLoadDefaultData(this.getCtx(), this.get_TrxName(), FamilyUpdateQtyOfChildrenAbstract.getProcessValue()).withParameter("UY_Family_ID", this.getUY_Family_ID()).withoutTransactionClose().execute(this.get_TrxName());
    }
}

