/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.X_UY_AllocInvoice;

public class MAllocInvoice
extends X_UY_AllocInvoice {
    private boolean IsFromProcess = false;

    public MAllocInvoice(Properties ctx, int UY_AllocInvoice_ID, String trxName) {
        super(ctx, UY_AllocInvoice_ID, trxName);
    }

    public MAllocInvoice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAllocInvoice(MInvoice mInvoice, MInvoice mCorrectionNote, boolean link) {
        super(mInvoice.getCtx(), 0, mInvoice.get_TrxName());
        this.setClientOrg(mInvoice);
        this.set_TrxName(mInvoice.get_TrxName());
        this.setC_Invoice_ID(mCorrectionNote.get_ID());
        if (link) {
            this.setC_AllocInvoice_ID(mInvoice.get_ID());
        } else {
            this.setDescription("Ref.: " + mInvoice.getDocumentNo());
        }
    }

    public boolean isFromProcess() {
        return this.IsFromProcess;
    }

    public void setFromProcess(boolean fromProcess) {
        this.IsFromProcess = fromProcess;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && !this.isFromProcess() && this.getC_AllocInvoice_ID() > 0) {
            BigDecimal amtInvAllocate = DB.getSQLValueBDEx(this.get_TrxName(), "select invoiceopen(" + this.getC_AllocInvoice_ID() + ", null)", new Object[0]);
            this.setOpenAmt(amtInvAllocate);
            this.setAmtToAllocate(amtInvAllocate);
        }
        if (this.getC_AllocInvoice_ID() > 0 && !this.isFromProcess()) {
            if (this.getOpenAmt().compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("ERROR: EL importe Total Abierto debe ser mayor a cero");
            }
            if (this.getAmtToAllocate().compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("ERROR: EL importe Total Asignado debe ser mayor a cero");
            }
        }
        return true;
    }

    public static MAllocInvoice getByInvoice(Properties ctx, int invoiceID, int noteID, String trx) {
        String whereClause = "C_Invoice_ID=" + noteID + " AND C_AllocInvoice_ID=" + invoiceID;
        MAllocInvoice line = (MAllocInvoice)new Query(ctx, "UY_AllocInvoice", whereClause, trx).first();
        return line;
    }
}

