/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.spin.model.MWHDefinition;
import org.spin.model.MWHSetting;
import org.spin.model.MWHWithholding;
import org.spin.util.AbstractWithholdingSetting;

public class LUYWithholdingSetting
extends AbstractWithholdingSetting {
    private MInvoice mInvoice;
    private MBPartner mbPartner;
    private List<MWHWithholding> mWithholdings;

    public LUYWithholdingSetting(MWHSetting setting) {
        super(setting);
    }

    @Override
    public String run() {
        if (this.mWithholdings != null) {
            this.mWithholdings.forEach(mwhWithholding -> {
                mwhWithholding.saveEx();
                mwhWithholding.processIt("CO");
                mwhWithholding.saveEx();
            });
        }
        return null;
    }

    @Override
    public boolean isValid() {
        AtomicBoolean isValid = new AtomicBoolean(true);
        if (this.getDocument().get_Table_ID() != I_C_Invoice.Table_ID) {
            this.addLog("@C_Invoice_ID@ @NotFound@");
            isValid.set(false);
        }
        this.mInvoice = (MInvoice)this.getDocument();
        this.mbPartner = (MBPartner)this.mInvoice.getC_BPartner();
        this.mWithholdings = new ArrayList<MWHWithholding>();
        MWHDefinition mwhDefinition = this.getDefinition();
        boolean hasVendor = new Query(this.mInvoice.getCtx(), "WH_Definition_Vendor", "WH_Definition_ID=? AND C_BPartner_ID=?", this.mInvoice.get_TrxName()).setParameters(mwhDefinition.get_ID(), this.mbPartner.get_ID()).match();
        if (!hasVendor) {
            isValid.set(false);
        } else {
            Arrays.asList(this.mInvoice.getLines()).forEach(mInvoiceLine -> {
                String whAmtType = mwhDefinition.get_ValueAsString("WHAmtType");
                if (this.isGenerated((MInvoiceLine)mInvoiceLine)) {
                    isValid.set(false);
                } else if ("T".equalsIgnoreCase(whAmtType) && !new Query(this.getContext(), "WH_DefinitionTax", "WH_Definition_ID=? AND C_Tax_ID=?", this.getTransactionName()).setParameters(mwhDefinition.get_ID(), mInvoiceLine.getC_Tax_ID()).match()) {
                    isValid.set(false);
                } else {
                    BigDecimal baseAmt = Env.ZERO;
                    if ("T".equalsIgnoreCase(whAmtType)) {
                        baseAmt = mInvoiceLine.getTaxAmt();
                    } else if ("A".equalsIgnoreCase(whAmtType)) {
                        baseAmt = mInvoiceLine.getLineTotalAmt();
                    } else if ("S".equalsIgnoreCase(whAmtType)) {
                        baseAmt = mInvoiceLine.getLineNetAmt();
                    }
                    mInvoiceLine.getLineTotalAmt();
                    BigDecimal rate = (BigDecimal)mwhDefinition.get_Value("Percentage");
                    if (rate == null) {
                        throw new AdempiereException("@Percentage@ @not.found@");
                    }
                    if ("APC".equalsIgnoreCase(this.mInvoice.getC_DocType().getDocBaseType())) {
                        baseAmt = baseAmt.negate();
                    }
                    BigDecimal withholdingAmount = baseAmt.multiply(rate).divide(Env.ONEHUNDRED, 4, RoundingMode.HALF_UP);
                    MWHWithholding mwhWithholding = new MWHWithholding(this.getContext(), 0, this.getTransactionName());
                    MDocType wdDocType = (MDocType)new Query(this.mInvoice.getCtx(), "C_DocType", "DocBaseType=?", this.mInvoice.get_TrxName()).setParameters("WHH").first();
                    if (wdDocType == null || wdDocType.get_ID() <= 0) {
                        throw new AdempiereException("@C_DocType_ID@ (@DocBaseType@=WHH) @not.found@");
                    }
                    mwhWithholding.setAD_Org_ID(this.mInvoice.getAD_Org_ID());
                    mwhWithholding.setC_DocType_ID(wdDocType.get_ID());
                    mwhWithholding.setDateDoc(this.mInvoice.getDateInvoiced());
                    mwhWithholding.setWH_Definition_ID(mwhDefinition.get_ID());
                    mwhWithholding.setWH_Setting_ID(this.getSetting().getWH_Setting_ID());
                    mwhWithholding.setDescription(mInvoiceLine.getDescription());
                    mwhWithholding.setA_Base_Amount(baseAmt);
                    mwhWithholding.setWithholdingRate(rate);
                    mwhWithholding.setWithholdingAmt(withholdingAmount);
                    mwhWithholding.setC_BPartner_ID(this.mInvoice.getC_BPartner_ID());
                    mwhWithholding.setSourceInvoice_ID(this.mInvoice.get_ID());
                    mwhWithholding.setSourceInvoiceLine_ID(mInvoiceLine.get_ID());
                    mwhWithholding.setWH_Definition_ID(mwhDefinition.get_ID());
                    this.mWithholdings.add(mwhWithholding);
                }
            });
        }
        return isValid.get();
    }

    private boolean isGenerated(MInvoiceLine mInvoiceLine) {
        if (this.mInvoice != null) {
            return new Query(this.getContext(), "WH_Withholding", "SourceInvoice_ID = ? AND SourceInvoiceLine_ID = ? AND WH_Definition_ID = ? AND IsSimulation='N'", this.getTransactionName()).setParameters(this.mInvoice.get_ID(), mInvoiceLine.get_ID(), this.getDefinition().get_ID()).match();
        }
        return false;
    }
}

