/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import javax.validation.constraints.NotNull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.openup.LUY.util.CFEUtils;
import org.openup.core.utils.helpers.functionalinterfaces.FunctionalInterface1Param;

public class InvoiCyWebServiceHandler {
    private String alias;
    private String endpoint;
    private String invoiCyPK;
    private String invoiCyCk;
    private String operation;
    private String action;
    private String namespace;
    private String parameter;
    private Object rootDto;
    private Class rootDtoClazz;
    private Object signedCkDto;
    private Class signedCkDtoClazz;
    private CKSetter ckSetter;
    private Class returnClazz;
    private XmlUsed xmlUsed;
    private TempXMLFilesUsed tempXMLFilesUsed;

    public InvoiCyWebServiceHandler(@NotNull String alias, @NotNull String invoiCyPK, @NotNull String invoiCyCk, @NotNull String endpoint, @NotNull String operation, @NotNull String action, @NotNull String namespace, @NotNull String parameter, @NotNull Object rootDto, @NotNull Class rootDtoClazz, @NotNull Object signedCkDto, @NotNull Class signedCkDtoClazz, @NotNull CKSetter ckSetter, @NotNull Class returnClazz) {
        this.alias = alias;
        this.invoiCyPK = invoiCyPK;
        this.invoiCyCk = invoiCyCk;
        this.endpoint = endpoint;
        this.operation = operation;
        this.action = action;
        this.namespace = namespace;
        this.parameter = parameter;
        this.rootDto = rootDto;
        this.rootDtoClazz = rootDtoClazz;
        this.signedCkDto = signedCkDto;
        this.signedCkDtoClazz = signedCkDtoClazz;
        this.ckSetter = ckSetter;
        this.returnClazz = returnClazz;
    }

    public InvoiCyWebServiceHandler xmlUsed(XmlUsed xmlUsed) {
        this.xmlUsed = xmlUsed;
        return this;
    }

    public InvoiCyWebServiceHandler tempXMLFilesUsed(TempXMLFilesUsed tempXMLFilesUsed) {
        this.tempXMLFilesUsed = tempXMLFilesUsed;
        return this;
    }

    public Object call() throws JAXBException, IOException, ServiceException {
        AtomicReference signedXmlFile = new AtomicReference();
        String hash = this.generateInvoiCyCKHash(this.alias, this.invoiCyCk, this.signedCkDtoClazz, this.signedCkDto, signedXmlFile::set);
        this.ckSetter.setCKinRootDto(hash);
        AtomicReference rootXMLFile = new AtomicReference();
        String xml = InvoiCyWebServiceHandler.parseXML(this.rootDtoClazz, this.rootDto, "_" + this.alias + "_INVOICY_ROOT_DTO_", ".xml", rootXMLFile::set);
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(new URL(this.endpoint));
        call.setOperationName(this.operation);
        call.setSOAPActionURI(this.action);
        call.addParameter(new QName(this.namespace, this.parameter), XMLType.XSD_STRING, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_STRING);
        String response = (String)call.invoke(new Object[]{xml});
        File responseFile = CFEUtils.getTempFileForCFE("_" + this.alias + "_INVOICY_RESPONSE_", ".xml");
        FileWriter responseWriter = new FileWriter(responseFile);
        PrintWriter pw = new PrintWriter(responseWriter);
        pw.print(response);
        pw.close();
        JAXBContext jaxbContextResponse = JAXBContext.newInstance(this.returnClazz);
        Unmarshaller jaxbUnmarshaller = jaxbContextResponse.createUnmarshaller();
        Object responseObject = jaxbUnmarshaller.unmarshal(responseFile);
        if (this.xmlUsed != null) {
            this.xmlUsed.xmlUsed(xml, response);
        }
        if (this.tempXMLFilesUsed != null) {
            this.tempXMLFilesUsed.tempXMLFilesUsed((File)rootXMLFile.get(), (File)signedXmlFile.get(), responseFile);
        }
        return responseObject;
    }

    public String generateInvoiCyCKHash(String alias, String invoicyCK, Class<Object> clazz, Object dto, FunctionalInterface1Param<File> signedFile) throws IOException, JAXBException {
        Object xml = InvoiCyWebServiceHandler.parseXML(clazz, dto, "_" + alias + "_INVOICY_SIGNED_DTO_", ".xml", signedFile);
        xml = invoicyCK + ((String)xml).replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "").replace(" xmlns=\"http://www.invoicy.com.uy/\"", "");
        String hashXmlCfe = CFEUtils.md5Encrypt((String)xml);
        return hashXmlCfe;
    }

    private static String parseXML(Class<Object> clazz, Object dto, String prefixTempFile, String suffixTempFile, FunctionalInterface1Param<File> parsedFile) throws IOException, JAXBException {
        String line;
        File tagFile = CFEUtils.getTempFileForCFE(prefixTempFile, suffixTempFile);
        JAXBContext jaxbContextCfe = JAXBContext.newInstance(clazz);
        Marshaller jaxbMarshallerCfe = jaxbContextCfe.createMarshaller();
        jaxbMarshallerCfe.setProperty("jaxb.formatted.output", false);
        jaxbMarshallerCfe.marshal(dto, tagFile);
        FileReader frCfe = new FileReader(tagFile);
        BufferedReader brCfe = new BufferedReader(frCfe);
        StringBuilder xml = new StringBuilder();
        while ((line = brCfe.readLine()) != null) {
            xml.append(line);
        }
        xml = new StringBuilder(xml.toString().replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "").replace(" xmlns=\"http://www.invoicy.com.uy/\"", ""));
        if (parsedFile != null) {
            parsedFile.doIt(tagFile);
        }
        return xml.toString();
    }

    @FunctionalInterface
    public static interface TempXMLFilesUsed {
        public void tempXMLFilesUsed(File var1, File var2, File var3);
    }

    @FunctionalInterface
    public static interface XmlUsed {
        public void xmlUsed(String var1, String var2);
    }

    @FunctionalInterface
    public static interface CKSetter {
        public void setCKinRootDto(String var1);
    }
}

