/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.openup.LUY.cfe.dto.generic.cfe.CAEDataType;
import org.openup.LUY.cfe.dto.generic.cfe.CFEDefType;
import org.openup.LUY.model.MInvoiceDiscount;
import org.openup.LUY.model.MLUYCAE;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.LUY.model.MLUYSender;
import org.openup.LUY.model.X_LUY_CFEType;
import org.openup.core.utils.Utils;

public class CFEUtils {
    public static final String CFEBILLINGCRITERIA_Line = "L";
    public static final String CFEBILLINGCRITERIA_ProjectPhase = "PP";
    public static final String CFEBILLINGCRITERIA_Project = "P";
    public static final String CFEBILLINGCRITERIA_Contract = "C";
    public static final String CFEBILLINGCRITERIA_Invoice = "I";
    public static final String CFEBILLINGCRITERIA_Task = "T";
    public static final String DOCUMENTTYPE_RUT = "rut";

    public static CfeBillingCriteria getCfeBillingCriteria(String strCfeBillingCriteria) {
        if (strCfeBillingCriteria == null) {
            return null;
        }
        if (CFEBILLINGCRITERIA_Line.equals(strCfeBillingCriteria)) {
            return CfeBillingCriteria.Line;
        }
        if (CFEBILLINGCRITERIA_ProjectPhase.equals(strCfeBillingCriteria)) {
            return CfeBillingCriteria.ProjectPhase;
        }
        if (CFEBILLINGCRITERIA_Project.equals(strCfeBillingCriteria)) {
            return CfeBillingCriteria.Project;
        }
        if (CFEBILLINGCRITERIA_Contract.equals(strCfeBillingCriteria)) {
            return CfeBillingCriteria.Contract;
        }
        if (CFEBILLINGCRITERIA_Invoice.equals(strCfeBillingCriteria)) {
            return CfeBillingCriteria.Invoice;
        }
        return null;
    }

    public static BiMap<String, CfeType> getCfeTypes() {
        HashBiMap<String, CfeType> ret = HashBiMap.create();
        ret.put("101", CfeType.eTicket);
        ret.put("102", CfeType.eTicket_NC);
        ret.put("103", CfeType.eTicket_ND);
        ret.put("111", CfeType.eFactura);
        ret.put("112", CfeType.eFactura_NC);
        ret.put("113", CfeType.eFactura_ND);
        ret.put("181", CfeType.eRemito);
        ret.put("182", CfeType.eResguardo);
        ret.put("131", CfeType.eTicket_VxCA);
        ret.put("132", CfeType.eTicket_NC_VxCA);
        ret.put("133", CfeType.eTicket_ND_VxCA);
        ret.put("141", CfeType.eFactura_VxCA);
        ret.put("142", CfeType.eFactura_NC_VxCA);
        ret.put("143", CfeType.eFactura_ND_VxCA);
        ret.put("121", CfeType.eFactura_Exp);
        ret.put("122", CfeType.eFactura_NC_Exp);
        ret.put("123", CfeType.eFactura_ND_Exp);
        return ret;
    }

    public static String md5Encrypt(String input2) {
        Object md5 = "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            BigInteger hash = new BigInteger(1, md.digest(input2.getBytes("utf-8")));
            md5 = hash.toString(16);
            while (((String)md5).length() < 32) {
                md5 = "0" + (String)md5;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5;
    }

    public static XMLGregorianCalendar Timestamp_to_XmlGregorianCalendar_OnlyDate(Timestamp timestamp, boolean withTime) {
        try {
            XMLGregorianCalendar xgcal;
            GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance();
            cal.setTime(timestamp);
            if (!withTime) {
                xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE);
            } else {
                xgcal = DatatypeFactory.newInstance().newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE);
                xgcal.setHour(cal.get(11));
                xgcal.setMinute(cal.get(12));
                xgcal.setSecond(cal.get(13));
                xgcal.setMillisecond(cal.get(14));
                xgcal.setTimezone(-180);
            }
            return xgcal;
        }
        catch (DatatypeConfigurationException e) {
            throw new AdempiereException(e);
        }
    }

    public static void loadCAE(String trxName, Properties ctx, MLUYSender mluySender, CFEDefType objCfe, MDocType mDocType, CfeType cfeType, int AD_Client_ID, int AD_Org_ID) {
        CAEDataType caeDataType = new CAEDataType();
        switch (cfeType) {
            case eFactura: 
            case eFactura_NC: 
            case eFactura_ND: 
            case eFactura_VxCA: 
            case eFactura_NC_VxCA: 
            case eFactura_ND_VxCA: {
                objCfe.getEFact().setCAEData(caeDataType);
                break;
            }
            case eTicket: 
            case eTicket_NC: 
            case eTicket_ND: 
            case eTicket_VxCA: 
            case eTicket_NC_VxCA: 
            case eTicket_ND_VxCA: {
                objCfe.getETck().setCAEData(caeDataType);
            }
        }
        MLUYCAE mluycae = (MLUYCAE)new Query(ctx, "LUY_CAE", "CFEType=? AND IsActive=? AND LUY_Sender_ID=?", trxName).setParameters(CFEUtils.getCfeTypes().inverse().get((Object)cfeType), "Y", mluySender.get_ID()).first();
        if (mluycae == null || mluycae.get_ID() <= 0) {
            throw new AdempiereException("CFE Error: El tipo de CFE no es un tipo aceptado por DGI");
        }
        caeDataType.setCAEID(new BigDecimal(mluycae.getDocumentNo()).toBigInteger());
        caeDataType.setDNro(BigInteger.valueOf(mluycae.getStartNo()));
        caeDataType.setHNro(BigInteger.valueOf(mluycae.getEndNo()));
        caeDataType.setFecVenc(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(mluycae.getEndDate(), false));
    }

    public static CfeType getCFETypeFromDoc(Properties ctx, MDocType mDocType, String trxName, int AD_Client_ID, int AD_Org_ID) {
        MLUYCFEType mluycfeType;
        CfeType ret = null;
        if (mDocType != null && mDocType.get_ID() > 0 && (mluycfeType = (MLUYCFEType)new Query(ctx, "LUY_CFEType", "C_DocType_ID=? AND IsActive=? AND AD_Client_ID=? AND AD_Org_ID=?", trxName).setParameters(mDocType.get_ID(), "Y", AD_Client_ID, AD_Org_ID).first()) != null && mluycfeType.get_ID() > 0) {
            ret = (CfeType)((Object)CFEUtils.getCfeTypes().get(mluycfeType.getCFEType()));
        }
        return ret;
    }

    public static boolean isCFEtoSend(Properties ctx, String trxName, PO po) {
        if (po.get_Table_ID() == I_C_Invoice.Table_ID) {
            MInvoice mInvoice = (MInvoice)po;
            MDocType mDocType = (MDocType)mInvoice.getC_DocTypeTarget();
            CfeType cfeType = CFEUtils.getCFETypeFromDoc(ctx, mDocType, trxName, mInvoice.getAD_Client_ID(), mInvoice.getAD_Org_ID());
            if (cfeType == null) {
                return false;
            }
            if (cfeType.is(CfeType.eResguardo)) {
                return true;
            }
            if (cfeType.is(CfeType.eTicket, CfeType.eTicket_NC, CfeType.eTicket_ND, CfeType.eFactura, CfeType.eFactura_NC, CfeType.eFactura_ND, CfeType.eTicket_VxCA, CfeType.eTicket_NC_VxCA, CfeType.eTicket_ND_VxCA, CfeType.eFactura_VxCA, CfeType.eFactura_NC_VxCA, CfeType.eFactura_ND_VxCA) && mInvoice.getReversal_ID() == 0) {
                return true;
            }
        }
        return false;
    }

    public static void setDocType(MInvoice mInvoice, CfeType ... cfeTypes) {
        Optional mLuyCfeType;
        MBPartner mbPartner = (MBPartner)mInvoice.getC_BPartner();
        Properties ctx = mInvoice.getCtx();
        String trxName = mInvoice.get_TrxName();
        if (cfeTypes == null) {
            throw new AdempiereException("@Error@ @CFEType@ @not.found@");
        }
        AtomicBoolean docDetected = new AtomicBoolean(false);
        AtomicBoolean correctionDocDetected = new AtomicBoolean(false);
        Object sqlWhere = "AD_Org_ID=? AND C_TaxGroup_ID=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(mInvoice.getAD_Org_ID());
        params.add(mbPartner.getC_TaxGroup_ID());
        String docWhere = Arrays.stream(cfeTypes).map(cfeType -> {
            if (cfeType.is(CfeType.eFactura, CfeType.eTicket)) {
                docDetected.set(true);
            } else if (cfeType.is(CfeType.eTicket_NC, CfeType.eTicket_ND, CfeType.eFactura_NC, CfeType.eFactura_ND)) {
                correctionDocDetected.set(true);
            }
            params.add(CFEUtils.getCfeTypes().inverse().get(cfeType));
            return "CFEType=?";
        }).collect(Collectors.joining(" OR "));
        if (docDetected.get() && correctionDocDetected.get()) {
            throw new AdempiereException("@Error@ No se puede filtrar e-Ticket y e-Factura con sus notas de correcci\u00f3n");
        }
        if (docWhere != null && !docWhere.isEmpty()) {
            sqlWhere = (String)sqlWhere + " AND (" + docWhere + ")";
        }
        if (!(mLuyCfeType = new Query(ctx, "LUY_CFEType", (String)sqlWhere, trxName).setParameters(params).list().stream().findFirst()).isPresent()) {
            throw new AdempiereException("@Error@ @not.found@ @LUY_CFEType@.@C_TaxGroup_ID@ | @AD_Org_ID@=" + Env.getAD_Org_ID(ctx) + ", @C_TaxGroup_ID@=" + mbPartner.getC_TaxGroup_ID());
        }
        mInvoice.setC_DocTypeTarget_ID(((X_LUY_CFEType)mLuyCfeType.get()).getC_DocType_ID());
    }

    public static String getOrgAliasTmpFile() {
        String orgAliasTemporalFile = "ccoo";
        try {
            orgAliasTemporalFile = MSysConfig.getValue("UY_CFE_Tmp_File_Pattern_ORG", "ccoo", Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgAliasTemporalFile;
    }

    public static File getTempFileForCFE(String prefix, String suffix) throws IOException {
        String fnpTimestamp = "tstm";
        try {
            fnpTimestamp = Utils.getCurrentTimestampFormatted("yyyyMMdd_hhmmssSSS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fnpCliOrg = CFEUtils.getOrgAliasTmpFile();
        File tmpFile = File.createTempFile("SPUY_" + fnpTimestamp + "_" + fnpCliOrg + "_" + prefix, suffix);
        return tmpFile;
    }

    public static List<MInvoiceDiscount> getDiscounts(MInvoice invoice, String taxIndicator) {
        Object sqlQuery = "C_Invoice_ID=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(invoice.get_ID());
        if (taxIndicator != null) {
            sqlQuery = (String)sqlQuery + " AND TaxIndicator=?";
            params.add(taxIndicator);
        }
        List<MInvoiceDiscount> discounts = new ArrayList<MInvoiceDiscount>();
        MLUYSender mluySender = MLUYSender.getSender(invoice.getCtx(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID(), invoice.get_TrxName());
        if (mluySender != null && mluySender.get_ValueAsBoolean("UseGlobalDiscounts")) {
            discounts = new Query(invoice.getCtx(), "C_InvoiceDiscount", (String)sqlQuery, invoice.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).list();
        }
        return discounts;
    }

    public static List<MInvoiceDiscount> getDiscounts(MInvoice invoice) {
        return CFEUtils.getDiscounts(invoice, null);
    }

    public static enum CfeType {
        eTicket,
        eTicket_NC,
        eTicket_ND,
        eFactura,
        eFactura_NC,
        eFactura_ND,
        eRemito,
        eResguardo,
        eTicket_VxCA,
        eTicket_NC_VxCA,
        eTicket_ND_VxCA,
        eFactura_VxCA,
        eFactura_NC_VxCA,
        eFactura_ND_VxCA,
        eFactura_Exp,
        eFactura_NC_Exp,
        eFactura_ND_Exp;


        public boolean is(CfeType ... expected) {
            return Arrays.asList(expected).contains((Object)this);
        }
    }

    public static enum CfeBillingCriteria {
        Line,
        ProjectPhase,
        Project,
        Contract,
        Invoice;

    }
}

