/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.openup.LUY.process.LUYCFE;

public class RegenerateCFDI
extends SvrProcess {
    protected Timestamp pDateFrom;
    protected Timestamp pDateTo;
    protected int pDocTypeId;
    protected int pInvoiceId;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if ("C_Invoice_ID".equals(para.getParameterName())) {
                this.pInvoiceId = para.getParameterAsInt();
                continue;
            }
            if ("DateAcct".equals(para.getParameter_ToAsBoolean())) {
                this.pDateFrom = (Timestamp)para.getParameter();
                this.pDateTo = (Timestamp)para.getParameter_To();
                continue;
            }
            if (!"C_DocType_ID".equals(para.getParameterName())) continue;
            this.pDocTypeId = para.getParameterAsInt();
        }
    }

    @Override
    protected String doIt() throws Exception {
        for (MInvoice invoice : this.getDocuments(this.pInvoiceId, this.pDateFrom, this.pDateTo, this.pDocTypeId)) {
            this.cancelCFDI(invoice);
            this.generateCFDI(invoice);
        }
        return "@OK@";
    }

    private void generateCFDI(PO po) {
        if (po.get_ValueAsBoolean("IsSOTrx")) {
            LUYCFE cdfdi = LUYCFE.get();
            cdfdi.setDocument(po);
            cdfdi.generate();
        }
    }

    private void cancelCFDI(PO po) {
        LUYCFE cdfdi = LUYCFE.get();
        cdfdi.setDocument(po);
        LUYCFE.cancel(po);
    }

    private List<MInvoice> getDocuments(int invoiceId, Timestamp from, Timestamp to, int docTypeId) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (invoiceId > 0) {
            whereClause.append("C_Invoice_ID").append("=?");
            parameters.add(invoiceId);
        } else {
            whereClause.append("DateAcct").append(">= ? AND");
            whereClause.append("DateAcct").append("<=? AND ");
            whereClause.append("C_DocType_ID").append("=?");
            parameters.add(from);
            parameters.add(to);
            parameters.add(docTypeId);
        }
        return new Query(this.getCtx(), "C_Invoice", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).list();
    }
}

