/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.process;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import org.adempiere.exceptions.AdempiereException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPrintable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.openup.LUY.model.MLUYDocument;

public class PMigratePrintCFE
extends SvrProcess {
    private int ad_table_id;
    private int record_id;
    private MLUYDocument mluyDocument;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters = this.getParameter();
        for (int i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("ad_table_id")) {
                this.ad_table_id = Integer.parseInt(parameters[i].getParameter().toString());
                continue;
            }
            if (!name.equalsIgnoreCase("record_id")) continue;
            this.record_id = ((BigDecimal)parameters[i].getParameter()).intValue();
        }
        if (this.ad_table_id != 0 && this.record_id != 0) {
            this.mluyDocument = (MLUYDocument)new Query(this.getCtx(), "LUY_Document", "AD_Table_ID=? AND Record_ID=?", this.get_TrxName()).setParameters(this.ad_table_id, this.record_id).first();
        }
        if (this.mluyDocument == null || this.mluyDocument.get_ID() <= 0) {
            throw new AdempiereException("Representaci\u00f3n Impresa no encontrada");
        }
    }

    @Override
    protected String doIt() throws Exception {
        PrintService defaultPrintService;
        File fileRepImpCFE;
        String urlHtmlPageRepImpCFE = this.mluyDocument.getCFERepImpressa();
        String invoicyEndpoint = null;
        Pattern regexD = Pattern.compile("(https?:\\/\\/)?(?:www\\.)?([^:\\/\\n]+)\\/.*\\/", 8);
        Matcher regexMatcherD = regexD.matcher(this.mluyDocument.getCFERepImpressa());
        if (regexMatcherD.find()) {
            invoicyEndpoint = regexMatcherD.group();
        }
        InputStream is = null;
        Object firstHtmlPage = "";
        try {
            String line;
            URL url = new URL(urlHtmlPageRepImpCFE);
            is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                firstHtmlPage = (String)firstHtmlPage + line;
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        String urlRepImpCFE = null;
        Pattern regex = Pattern.compile("[a-zA-Z\\d/]*.pdf", 8);
        Matcher regexMatcher = regex.matcher((CharSequence)firstHtmlPage);
        if (regexMatcher.find()) {
            urlRepImpCFE = invoicyEndpoint + regexMatcher.group();
        }
        try {
            fileRepImpCFE = File.createTempFile("InvoiCyRepresentacionImpresa_" + this.mluyDocument.getCFETipo() + "_" + this.mluyDocument.getCFESerie() + this.mluyDocument.getCFENro() + "__", ".pdf");
            fileRepImpCFE.deleteOnExit();
            URLConnection connRepImpCFE = new URL(urlRepImpCFE).openConnection();
            InputStream inRepImpCFE = connRepImpCFE.getInputStream();
            FileOutputStream outRepImpCFE = new FileOutputStream(fileRepImpCFE);
            int b = 0;
            while (b != -1) {
                b = inRepImpCFE.read();
                if (b == -1) continue;
                ((OutputStream)outRepImpCFE).write(b);
            }
            ((OutputStream)outRepImpCFE).close();
            inRepImpCFE.close();
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
        PrintService printService = defaultPrintService = PMigratePrintCFE.findPrintService(this.getCtx().getProperty("#Printer"));
        DocPrintJob printJob = printService.createPrintJob();
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = new Paper();
        paper.setImageableArea(-200.0, 0.0, 1000.0, 800.0);
        pageFormat.setPaper(paper);
        PDDocument pdDocument = PDDocument.load(fileRepImpCFE);
        PDFPrintable pdfPrintable = new PDFPrintable(pdDocument);
        Book book = new Book();
        book.append(pdfPrintable, pageFormat);
        SimpleDoc doc = new SimpleDoc(book, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        printJob.print(doc, null);
        return null;
    }

    private static PrintService findPrintService(String printerName) {
        printerName = printerName.toLowerCase();
        PrintService service = null;
        PrintService[] services = PrinterJob.lookupPrintServices();
        for (int index = 0; service == null && index < services.length; ++index) {
            if (services[index].getName().toLowerCase().indexOf(printerName) < 0) continue;
            service = services[index];
        }
        return service;
    }
}

