/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.process;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.Adempiere;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MAttachmentNote;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MImage;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.openup.LUY.engine.LUYVendorEngine;
import org.openup.LUY.engine.LUYVendorInterface;
import org.openup.LUY.model.I_LUY_Vendor;
import org.openup.LUY.model.MLUYAddenda;
import org.openup.LUY.model.MLUYCertificate;
import org.openup.LUY.model.MLUYDocument;
import org.openup.LUY.model.MLUYSender;
import org.openup.LUY.util.CFEDTOManager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class LUYCFE {
    private MLUYCertificate certificate = null;
    private LUYVendorInterface service = null;
    private MLUYSender sender = null;
    private MLUYAddenda addendaInfo = null;
    private String CFE = null;
    private static LUYCFE instance = null;
    private static InputStream CFE_XSLT = null;
    private static InputStream CFE_STRING_XSLT = null;
    private static InputStream CFE_ADDENDA_XSLT = null;
    private static InputStream CFE_SCHEMA = null;
    private static InputStream PKCS12_CER = null;
    private static PO document = null;
    private static MLUYDocument documentCFE = null;
    private static KeyStore keyStore = null;
    private static String stringCFE = "";
    private String wayMethod = "";
    private CFEDTOManager cfedtoManager;
    private static String tmpAddenda = "<cfdi:Addenda/>";
    private static String tmpComplemento = "<cfdi:Complemento/>";

    public static LUYCFE get() {
        instance = new LUYCFE();
        return instance;
    }

    public void setDocument(PO po) {
        try {
            this.certificate = MLUYCertificate.get(po.getAD_Client_ID(), po.getAD_Org_ID());
            document = po;
            MDocType docType = null;
            int docTypeId = document.get_ValueAsInt("C_DocType_ID");
            docType = MDocType.get(document.getCtx(), docTypeId);
            if (docType == null) {
                throw new AdempiereException("El documento no valido");
            }
            this.sender = MLUYSender.getSender(document.getCtx(), document.getAD_Client_ID(), document.getAD_Org_ID(), document.get_TrxName());
            if (this.sender != null && this.sender.get_ID() > 0 && this.sender.isActive()) {
                this.wayMethod = this.sender.get_ValueAsString("WayMethod");
                if (this.wayMethod != null && !"DTO".equals(this.wayMethod)) {
                    MLUYAddenda addInfoCustomer;
                    if (this.addendaInfo == null) {
                        this.addendaInfo = MLUYAddenda.getByBPartnerId(document.getCtx(), document.getAD_Client_ID(), document.getAD_Org_ID(), this.sender.getC_BPartner_ID(), document.get_TrxName());
                    }
                    if ((addInfoCustomer = MLUYAddenda.getByBPartnerId(document.getCtx(), document.getAD_Client_ID(), document.getAD_Org_ID(), document.get_ValueAsInt("C_BPartner_ID"), document.get_TrxName())) != null) {
                        this.addendaInfo = addInfoCustomer;
                    }
                    if (this.addendaInfo == null) {
                        throw new AdempiereException("No hay esquema para comprobante Fiscal Digital");
                    }
                }
                LUYVendorEngine engine = LUYVendorEngine.get();
                I_LUY_Vendor vendor = this.certificate.getVendorService(docType);
                if (vendor != null) {
                    this.service = engine.getLUYVendorFactory(vendor.getClassname());
                    if (this.service == null) {
                        throw new AdempiereException("No existe ningun integrador");
                    }
                    this.service.setDocument(po);
                    if (this.certificate.getPKCS12_ID() > 0) {
                        PKCS12_CER = new ByteArrayInputStream(MImage.get(Env.getCtx(), this.certificate.getPKCS12_ID()).getData());
                        LUYCFE.setKeyStore(PKCS12_CER, this.certificate.getPassword());
                        if (keyStore == null) {
                            throw new AdempiereException("La Llave PKCS12 no corresponde a la Clave del Certificado");
                        }
                    }
                    this.wayMethod = this.sender.get_ValueAsString("WayMethod");
                    if (this.wayMethod != null && "DTO".equals(this.wayMethod)) {
                        this.cfedtoManager = new CFEDTOManager(document, this.certificate, this.service);
                    } else {
                        MAttachment attach;
                        CFE_SCHEMA = new ByteArrayInputStream(MImage.get(Env.getCtx(), this.addendaInfo.getCFDISchema_ID()).getData());
                        CFE_XSLT = new ByteArrayInputStream(MImage.get(Env.getCtx(), this.addendaInfo.getCFDIADTransformer_ID()).getData());
                        CFE_STRING_XSLT = new ByteArrayInputStream(MImage.get(Env.getCtx(), this.addendaInfo.getCFDITransformerString_ID()).getData());
                        CFE_ADDENDA_XSLT = new ByteArrayInputStream(MImage.get(Env.getCtx(), this.addendaInfo.getCFDITransformer_ID()).getData());
                        if (this.addendaInfo.getAttachment() != null && (attach = this.addendaInfo.getAttachment()).getEntries() != null) {
                            MAttachmentEntry[] attents = attach.getEntries();
                            File tmpF = File.createTempFile("opup", "");
                            String dirName = tmpF.getAbsolutePath();
                            tmpF.delete();
                            File tmpDir = new File(dirName);
                            tmpDir.mkdir();
                            tmpDir.deleteOnExit();
                            for (int i = 0; i < attents.length; ++i) {
                                String localFile = dirName + File.separator + attents[i].getName();
                                File file = new File(localFile);
                                File downloadedFile = new File(localFile);
                                attents[i].getFile(downloadedFile);
                            }
                        }
                        if (CFE_ADDENDA_XSLT == null) {
                            throw new AdempiereException("No hay esquema para Comprobante Fiscal Digital");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    public MLUYDocument generate() {
        try {
            if (this.sender != null && this.sender.get_ID() > 0 && this.sender.isActive()) {
                if (this.wayMethod != null && "DTO".equals(this.wayMethod)) {
                    if (this.cfedtoManager != null) {
                        this.cfedtoManager.createCFE();
                    }
                } else {
                    if (document != null && document.get_Table_ID() == MInvoice.Table_ID) {
                        MInvoice invoice = (MInvoice)document;
                        if (invoice.isReversal()) {
                            return this.cancelCFE(this.getReversal(document));
                        }
                        return this.createCFE();
                    }
                    if (document != null && document.get_Table_ID() == MPayment.Table_ID) {
                        MPayment payment = (MPayment)document;
                        if (payment.isReversal()) {
                            return this.cancelCFE(this.getReversal(document));
                        }
                        return this.createCFE();
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage(), e);
        }
    }

    private PO getReversal(PO po) {
        return new MInvoice(po.getCtx(), po.get_ValueAsInt("Reversal_ID"), po.get_TrxName());
    }

    public MLUYDocument cancelCFE(PO reverseInvoice) throws Exception {
        documentCFE = MLUYDocument.get(reverseInvoice);
        this.service.getCancelCFDI(documentCFE);
        MAttachment attachment = new MAttachment(documentCFE.getCtx(), documentCFE.get_Table_ID(), documentCFE.getLUY_Document_ID(), documentCFE.get_TrxName());
        attachment.setTitle("Acuse de Recibo CFE");
        String fileName = "Acuse de Recibo CFE" + reverseInvoice.get_ValueAsString("DocumentNo");
        String CFDName = "CFD" + fileName + ".xml";
        attachment.addEntry(CFDName, documentCFE.getCFDIXML().getBytes("UTF-8"));
        attachment.addTextMsg(documentCFE.getCFDIXML());
        attachment.saveEx();
        MAttachmentNote attachmentNote = new MAttachmentNote(documentCFE.getCtx(), 0, documentCFE.get_TrxName());
        attachmentNote.setAD_Attachment_ID(attachment.get_ID());
        attachmentNote.setAD_User_ID(100);
        attachmentNote.setTextMsg(documentCFE.getCFDIXML());
        attachmentNote.setTitle(document.get_ValueAsString("DocumentNo"));
        attachmentNote.saveEx();
        documentCFE.setIsCancelled(true);
        documentCFE.saveEx();
        return documentCFE;
    }

    public static String getXMLFromReportEngine(PO po, int printFormatId) {
        MClient client = MClient.get(po.getCtx());
        Language language = client.getLanguage();
        MPrintFormat format = MPrintFormat.get(po.getCtx(), printFormatId, false);
        format.setLanguage(language);
        format.setTranslationLanguage(language);
        MQuery query = new MQuery(format.getAD_Table().getTableName());
        query.addRestriction(po.get_TableName() + "_ID", "=", po.get_ID());
        PrintInfo printInfo = new PrintInfo(po.get_ValueAsString("DocumentNo"), format.getAD_Table().getAD_Table_ID(), po.get_ID());
        printInfo.setCopies(1);
        printInfo.setDocumentCopy(false);
        printInfo.setPrinterName(format.getPrinterName());
        ReportEngine reportEngine = new ReportEngine(po.getCtx(), format, query, printInfo, po.get_TrxName());
        if (reportEngine == null) {
            throw new AdempiereException("@NotFound@ @M_PrintFormat_ID@");
        }
        reportEngine.getLayout();
        StringWriter stringWriter = new StringWriter();
        reportEngine.createXML(stringWriter);
        return stringWriter.getBuffer().toString();
    }

    public String getCFE(PO po) throws TransformerException {
        String xmlReport = LUYCFE.getXMLFromReportEngine(po, this.addendaInfo.getAD_PrintFormat_ID());
        String transformedCFE = this.getXMLTransform(xmlReport);
        return transformedCFE;
    }

    public String getXMLTransform(String xmlReport) throws TransformerException {
        StringWriter transformedCFE = new StringWriter();
        this.transform(new StreamSource(CFE_XSLT), new StreamSource(new StringReader(xmlReport)), new StreamResult(transformedCFE));
        return transformedCFE.getBuffer().toString();
    }

    public String getAddendaTransform(String CFE2) throws TransformerException {
        StringWriter transformedCFE = new StringWriter();
        this.transform(new StreamSource(CFE_ADDENDA_XSLT), new StreamSource(new StringReader(CFE2)), new StreamResult(transformedCFE));
        return transformedCFE.getBuffer().toString();
    }

    private MLUYDocument createCFE() throws TransformerException, IOException, SAXException, URISyntaxException {
        documentCFE = MLUYDocument.get(document);
        if (documentCFE != null && documentCFE.getCFDIUUID() != null && !documentCFE.getCFDIUUID().isEmpty()) {
            return documentCFE;
        }
        if (documentCFE == null) {
            documentCFE = new MLUYDocument(document.getCtx(), 0, document.get_TrxName());
            documentCFE.setAD_Table_ID(document.get_Table_ID());
            documentCFE.setRecord_ID(document.get_ID());
            documentCFE.setTaxID(this.getRFC());
            documentCFE.saveEx();
        }
        String xmlCFE = "";
        if (document != null) {
            xmlCFE = this.getCFE(document);
        }
        if (document != null && "C_Invoice".equals(document.get_TableName())) {
            String schemaLang = "http://www.w3.org/2001/XMLSchema";
            SchemaFactory schema_factory = SchemaFactory.newInstance(schemaLang);
            Schema schema = schema_factory.newSchema(new StreamSource(CFE_SCHEMA));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(new StringReader(xmlCFE)));
        }
        if ("".equals(xmlCFE) || xmlCFE == null) {
            throw new AdempiereException("El CFE no es V\u00e1lido");
        }
        stringCFE = this.getOriginalString(xmlCFE);
        documentCFE.setCFDIString(stringCFE);
        documentCFE.setCFDIXML(xmlCFE);
        this.service.getCFDI(documentCFE);
        this.service.getQR(documentCFE);
        MAttachment attachment = new MAttachment(documentCFE.getCtx(), documentCFE.get_Table_ID(), documentCFE.getLUY_Document_ID(), documentCFE.get_TrxName());
        attachment.setTitle("CFD");
        String CFDName = "CFD" + documentCFE.getCFDIUUID() + ".xml";
        attachment.addEntry(CFDName, this.getCFE().getBytes("UTF-8"));
        attachment.addTextMsg(stringCFE);
        attachment.saveEx();
        MAttachmentNote attachmentNote = new MAttachmentNote(documentCFE.getCtx(), 0, documentCFE.get_TrxName());
        attachmentNote.setAD_Attachment_ID(attachment.get_ID());
        attachmentNote.setAD_User_ID(100);
        attachmentNote.setTitle(documentCFE.getCFDIUUID());
        attachmentNote.setTextMsg(this.getCFE());
        attachmentNote.saveEx();
        return documentCFE;
    }

    public static void main(String[] args) throws Exception {
        Ini.setProperty("ApplicationUserID", "SuperUser");
        Ini.setProperty("ApplicationPassword", "System");
        Ini.setProperty("Role", "AHVR admin");
        Ini.setProperty("Client", "Aldo Hugo Vargas Rodr\u00edguez");
        Ini.setProperty("Organization", "Matriz");
        Ini.setProperty("Warehouse", "Est\u00e1ndar");
        Ini.setProperty("Language", "English");
        Adempiere.startup(true);
        Login login = new Login(Env.getCtx());
        login.batchLogin();
        List invoices = new Query(Env.getCtx(), "C_Invoice", "DocumentNo='B1195'", null).setClient_ID().setOrderBy("DateInvoiced").list();
        for (MInvoice invoice : invoices) {
            System.out.println("Factura ... " + invoice.getDocumentNo());
            LUYCFE cdfdi = LUYCFE.get();
            cdfdi.setDocument(invoice);
            cdfdi.generate();
            System.out.println("Factura procesada ... " + invoice.getDocumentNo());
        }
    }

    public static void cancel(PO invoice) {
        try {
            LUYCFE cdfdi = LUYCFE.get();
            cdfdi.setDocument(invoice);
            cdfdi.cancelCFE((MInvoice)cdfdi.getReversal(invoice));
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    public static void regenerate(PO po) throws TransformerException, IOException {
        MAttachment attachment;
        Object fileName = null;
        if ("C_Invoice".equals(document.get_TableName())) {
            fileName = document.get_ValueAsString("DocumentNo");
        }
        if ("C_PaySelectionCheck".equals(document.get_TableName())) {
            String taxId = DB.getSQLValueString(document.get_TrxName(), "SELECT TaxID  FROM C_BPartner bp WHERE C_BPartner_ID", document.get_ValueAsInt("C_BPartner_ID"));
            String documentNo = DB.getSQLValueString(document.get_TrxName(), "SELECT DocumentNo FROM C_Payment p WHERE p.C_Payment_ID = ?", document.get_ValueAsInt("C_Payment_ID"));
            fileName = taxId + documentNo;
        }
        LUYCFE cdfdi = LUYCFE.get();
        cdfdi.setDocument(po);
        cdfdi.getCFDIXML();
        String CFE2 = cdfdi.getCFE();
        if (CFE2 == null) {
            return;
        }
        MImage image = new MImage(documentCFE.getCtx(), documentCFE.getCFDIQR_ID(), null);
        if (image != null) {
            image.deleteEx(true);
        }
        if ((attachment = (MAttachment)new Query(documentCFE.getCtx(), "AD_Attachment", "AD_Table_ID=? AND Record_ID=?", null).setClient_ID().setParameters(documentCFE.get_Table_ID(), documentCFE.getLUY_Document_ID()).first()) != null) {
            for (int i = 0; i <= attachment.getEntries().length; ++i) {
                attachment.deleteEntry(i);
            }
        } else {
            attachment = new MAttachment(documentCFE.getCtx(), documentCFE.get_Table_ID(), documentCFE.getLUY_Document_ID(), documentCFE.get_TrxName());
        }
        attachment.setTitle("CFD");
        String CFDName = "CFD" + (String)fileName + ".xml";
        attachment.addEntry(CFDName, cdfdi.getCFE().getBytes("UTF-8"));
        attachment.addTextMsg(cdfdi.getOriginalString(cdfdi.getCFE()));
        attachment.saveEx();
        MAttachmentNote attachmentNote = (MAttachmentNote)new Query(documentCFE.getCtx(), "AD_AttachmentNote", "AD_Attachment_ID=?", null).setClient_ID().setParameters(attachment.getAD_Attachment_ID()).first();
        if (attachmentNote == null) {
            attachmentNote = new MAttachmentNote(documentCFE.getCtx(), 0, documentCFE.get_TrxName());
        }
        attachmentNote.setAD_Attachment_ID(attachment.get_ID());
        attachmentNote.setAD_User_ID(100);
        attachmentNote.setTitle((String)fileName);
        attachmentNote.saveEx();
    }

    private void getCFDIXML() {
        this.service.getCFDI(documentCFE);
    }

    private void updateDate(String CFE2) {
        try {
            String date = CFE2.substring(CFE2.indexOf("fecha=") + 7, CFE2.indexOf("\" xsi:schemaLocation="));
            date = date.replace("T", " ");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd H:mm:ss");
            Date newDate = formatter.parse(date);
            Timestamp dateDocument = new Timestamp(newDate.getTime());
            if (document instanceof MInvoice) {
                document.set_ValueOfColumn("DateInvoiced", (Object)dateDocument);
                document.set_ValueOfColumn("DateAcct", (Object)dateDocument);
                document.saveEx();
            }
            documentCFE.setCFDISealingDate(date);
            documentCFE.saveEx();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private Document getDocument(String xml) {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = docfactory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getElement(String xml, String key) {
        Document document = this.getDocument(xml);
        return document.getElementsByTagName(key).item(0).getTextContent();
    }

    private String getUUID() {
        String tmpString = this.CFE.substring(this.CFE.indexOf("UUID=") + 6);
        return tmpString.substring(0, tmpString.indexOf("\""));
    }

    private String getSeal() {
        String tmpString = this.CFE.substring(this.CFE.indexOf("sello=") + 7);
        return tmpString.substring(0, tmpString.indexOf("\""));
    }

    private String getCFE() {
        return documentCFE.getCFDIXML();
    }

    private String getSealSAT() {
        String tmpSeal = this.CFE.substring(this.CFE.indexOf("selloSAT=") + 10);
        return tmpSeal.substring(0, tmpSeal.indexOf("\""));
    }

    private String getNoCertificateSAT() {
        String tmpString = this.CFE.substring(this.CFE.indexOf("noCertificadoSAT=") + 18);
        return tmpString.substring(0, tmpString.indexOf("\""));
    }

    private String getDate() {
        String fecha = this.CFE.substring(this.CFE.indexOf("fecha=") + 7);
        fecha = fecha.substring(0, fecha.indexOf("\""));
        fecha = fecha.replace("T", " ");
        return fecha;
    }

    private static String cutAddenda(String xml) {
        if (xml.contains("<cfdi:Addenda>")) {
            tmpAddenda = xml.substring(xml.indexOf("<cfdi:Addenda>"), xml.indexOf("</cfdi:Addenda>") + 15);
            xml = xml.replace(tmpAddenda, "<cfdi:Addenda/>");
        }
        return xml;
    }

    private static String pasteAddenda(String xml) {
        xml = xml.replace("<cfdi:Addenda/>", tmpAddenda);
        return xml;
    }

    private static String cutComplemento(String xml) {
        if (xml.contains("<cfdi:Complemento>")) {
            tmpComplemento = xml.substring(xml.indexOf("<cfdi:Complemento>") + 18, xml.indexOf("</cfdi:Complemento>") + 19);
            xml = xml.replace("<cfdi:Complemento>" + tmpComplemento, "<cfdi:Complemento/>");
        }
        return xml;
    }

    private static String pasteComplemento(String xml) {
        if (!tmpComplemento.equals("<cfdi:Complemento/>")) {
            xml = xml.replace("</cfdi:Complemento>", tmpComplemento);
        }
        return xml;
    }

    public String generateCFEWithStamp(String xml) {
        try {
            int ind = ((String)xml).indexOf("sello=\"") + 7;
            String fp = ((String)xml).substring(0, ind);
            String sp = ((String)xml).substring(ind, ((String)xml).length());
            ind = ((String)xml).indexOf("noCertificado=\"");
            fp = ((String)xml).substring(0, ind);
            sp = ((String)xml).substring(ind, ((String)xml).length());
            xml = fp + " certificado=\"\" " + sp;
            ind = ((String)xml).indexOf("noCertificado=\"") + 15;
            fp = ((String)xml).substring(0, ind);
            sp = ((String)xml).substring(ind, ((String)xml).length());
            xml = fp + this.certificate.getDocumentNo() + sp;
            return xml;
        }
        catch (Exception e) {
            throw new AdempiereException("No se pudo generar el sello para este documento");
        }
    }

    private String getOriginalString(String CFE2) throws TransformerException, IOException {
        StringWriter transformed = new StringWriter();
        this.transform(new StreamSource(CFE_STRING_XSLT), new StreamSource(new StringReader(CFE2)), new StreamResult(transformed));
        return transformed.getBuffer().toString();
    }

    public void transform(StreamSource xslt, StreamSource xml, StreamResult result) throws TransformerException {
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xslt);
        trans.setOutputProperty("encoding", "UTF8");
        StreamResult xmlResult = result;
        trans.transform(xml, xmlResult);
    }

    private MLUYSender getSender() {
        return this.sender;
    }

    private String getRFC() {
        return this.getSender().getC_BPartner().getTaxID();
    }

    private static void setKeyStore(InputStream stream, String password) {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(stream, password.toCharArray());
            keyStore = ks;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] getAliasArray(KeyStore keystore) {
        Enumeration<String> e = null;
        try {
            e = keystore.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            v.addElement(alias);
        }
        Object[] s = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    public static X509Certificate getCertificate(KeyStore ks) {
        try {
            String alias = LUYCFE.getKeyStoreAlias(ks);
            return (X509Certificate)ks.getCertificate(alias);
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public static String getKeyStoreAlias(KeyStore s) {
        String[] aliases = LUYCFE.getAliasArray(s);
        String alias = null;
        for (int i = 0; i < aliases.length; ++i) {
            alias = aliases[i];
        }
        return alias;
    }
}

