/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.process;

import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPayment;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.eevolution.hr.model.MHRPaySelection;
import org.eevolution.hr.model.MHRPaySelectionCheck;
import org.openup.LUY.model.MLUYDocument;
import org.openup.LUY.process.LUYCFE;

public class GeneratePayrollCFDI
extends SvrProcess {
    protected int payrollPaySelectionId;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            if (para.getParameter() == null || !"HR_PaySelection_ID".equals(para.getParameterName())) continue;
            this.payrollPaySelectionId = para.getParameterAsInt();
        }
    }

    @Override
    protected String doIt() throws Exception {
        for (MHRPaySelectionCheck paySelectionCreateCheck : this.getPayments(this.payrollPaySelectionId)) {
            if (paySelectionCreateCheck.getC_Payment_ID() == 0) {
                String employeeName = DB.getSQLValueString(this.get_TrxName(), "SELECT Name FROM C_BPartner WHERE C_BPartner_ID=?", paySelectionCreateCheck.getC_BPartner_ID());
                String employeeValue = DB.getSQLValueString(this.get_TrxName(), "SELECT Value FROM C_BPartner WHERE C_BPartner_ID=?", paySelectionCreateCheck.getC_BPartner_ID());
                MHRPaySelection mhrPaySelection = new MHRPaySelection(paySelectionCreateCheck.getCtx(), paySelectionCreateCheck.getHR_PaySelection_ID(), paySelectionCreateCheck.get_TrxName());
                this.addLog("@C_PaySelection_ID@ : " + mhrPaySelection.getName() + " @Value@ : " + employeeValue + " @HR_Employee_ID@ : " + employeeName + " @C_Payment_ID@  @NotFound@");
                continue;
            }
            Trx.run(new TrxRunnable(){
                private int paymentId;

                public TrxRunnable setParameters(int paymentId) {
                    this.paymentId = paymentId;
                    return this;
                }

                @Override
                public void run(String trxName) {
                    MPayment payment = new MPayment(Env.getCtx(), this.paymentId, trxName);
                    if (payment == null) {
                        throw new AdempiereException("@C_Payment_ID@ @NotFound@");
                    }
                    if (MLUYDocument.isProcessed(payment)) {
                        return;
                    }
                    String employeeName = DB.getSQLValueString(GeneratePayrollCFDI.this.get_TrxName(), "SELECT Name FROM C_BPartner WHERE C_BPartner_ID=?", payment.getC_BPartner_ID());
                    String employeeValue = DB.getSQLValueString(GeneratePayrollCFDI.this.get_TrxName(), "SELECT Value FROM C_BPartner WHERE C_BPartner_ID=?", payment.getC_BPartner_ID());
                    try {
                        LUYCFE cdfdi = LUYCFE.get();
                        cdfdi.setDocument(payment);
                        MLUYDocument document = cdfdi.generate();
                        String uuid = document.getCFDIUUID();
                        GeneratePayrollCFDI.this.addLog("@Value@ : " + employeeValue + " @HR_Employee_ID@ : " + employeeName + " @LUY_Document_ID@ : " + uuid + " @CFDISealingDate@ " + document.getCFDISealingDate());
                    }
                    catch (Exception e) {
                        GeneratePayrollCFDI.this.addLog("@Value@ : " + employeeValue + " @HR_Employee_ID@ : " + employeeName + " @Error@ " + e.getMessage());
                    }
                }
            }.setParameters(paySelectionCreateCheck.getC_Payment_ID()));
        }
        return "@OK@";
    }

    private List<MHRPaySelectionCheck> getPayments(int payrollPaySelectionId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("HR_PaySelection_ID").append("=?");
        return new Query(this.getCtx(), "HR_PaySelectionCheck", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(payrollPaySelectionId).list();
    }
}

