/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.model;

import java.io.StringWriter;
import java.sql.Timestamp;
import javax.xml.transform.TransformerException;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Language;
import org.eevolution.services.dsl.ProcessBuilder;
import org.openup.LUY.model.MLUYSender;
import org.openup.LUY.process.LUYCFE;
import org.openup.LUY.process.PGenerateInvoiceLineCFEAbstract;
import org.openup.LUY.util.CFEUtils;
import org.openup.core.model.MAllocInvoice;

public class LUYModelValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(LUYModelValidator.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addModelChange("C_BPartner", this);
        engine.addModelChange("HR_PaySelectionCheck", this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("C_Invoice")) {
            if (type == 1) {
                boolean specialCfeLineFormat;
                MInvoice mInvoice;
                MInvoice invoice = (MInvoice)po;
                if (invoice.getDocAction() == "CL" && invoice.getDocStatus() == "CO") {
                    invoice.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
                }
                if (invoice.getDocAction() == "" && invoice.getDocStatus() == "") {
                    invoice.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
                }
                if (!(mInvoice = (MInvoice)po).isSOTrx()) return null;
                MLUYSender mluySender = MLUYSender.getSender(mInvoice.getCtx(), mInvoice.getAD_Client_ID(), mInvoice.getAD_Org_ID(), mInvoice.get_TrxName());
                try {
                    specialCfeLineFormat = "S".equals(mluySender.get_ValueAsString("CFELineFormat"));
                }
                catch (Exception e) {
                    specialCfeLineFormat = false;
                }
                if (!specialCfeLineFormat) return null;
                MBPartner mbPartner = (MBPartner)mInvoice.getC_BPartner();
                if (CFEUtils.getCfeBillingCriteria(mbPartner.get_ValueAsString("CFEBillingCriteria")) == null) {
                    throw new AdempiereException("@C_BPartner@.@CFEBillingCriteria@ @not.found@");
                }
                mInvoice.set_ValueOfColumn("CFEBillingCriteria", (Object)mbPartner.get_ValueAsString("CFEBillingCriteria"));
                return null;
            }
        }
        if (!po.get_TableName().equals("UY_AllocInvoice")) return null;
        if (type != 1) return null;
        MAllocInvoice mAllocInvoice = (MAllocInvoice)po;
        int qtyMaxRef = MSysConfig.getIntValue("LUY_CFE_MAX_REF_PER_CFE", 40, mAllocInvoice.getAD_Client_ID(), mAllocInvoice.getAD_Org_ID());
        int qtyRef = new Integer(DB.getSQLValueString(po.get_TrxName(), "SELECT COUNT(*) FROM UY_AllocInvoice WHERE C_Invoice_ID = ?", mAllocInvoice.getC_Invoice_ID()));
        if (qtyRef > qtyMaxRef) {
            throw new AdempiereException("CFE Error: Area Informacion de Referencia - No se permiten referenciar mas de %maxRef% documentos desde una nota de correccion".replace("%maxRef%", String.valueOf(qtyMaxRef)));
        }
        int qtyDesc = new Integer(DB.getSQLValueString(po.get_TrxName(), "SELECT COUNT(*) FROM UY_AllocInvoice WHERE C_Invoice_ID = ? AND Description IS NOT NULL AND Description <> ''", mAllocInvoice.getC_Invoice_ID()));
        if (qtyDesc <= 0) return null;
        throw new AdempiereException("CFE Error: Area Informacion de Referencia - No se permite mas de una linea de referencia con descripci\u00f3n para una nota de correccion");
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInvoice invoice;
        if (timing == 1) {
            MInvoice mInvoice;
            if ("C_Invoice".equals(po.get_TableName()) && (mInvoice = (MInvoice)po).isSOTrx()) {
                boolean specialCfeLineFormat;
                MLUYSender mluySender = MLUYSender.getSender(mInvoice.getCtx(), mInvoice.getAD_Client_ID(), mInvoice.getAD_Org_ID(), mInvoice.get_TrxName());
                try {
                    specialCfeLineFormat = "S".equals(mluySender.get_ValueAsString("CFELineFormat"));
                }
                catch (Exception e) {
                    specialCfeLineFormat = false;
                }
                if (specialCfeLineFormat && !new Query(mInvoice.getCtx(), "C_InvoiceLineCFE", "C_Invoice_ID=?", mInvoice.get_TrxName()).setParameters(mInvoice.get_ID()).match()) {
                    ProcessBuilder.create(mInvoice.getCtx()).process(MProcess.getProcess_ID(PGenerateInvoiceLineCFEAbstract.getProcessValue(), mInvoice.get_TrxName())).withParameter("C_Invoice_ID", mInvoice.getC_Invoice_ID()).withoutTransactionClose().execute(mInvoice.get_TrxName());
                }
            }
        } else if (timing == 9) {
            if ("C_Invoice".equals(po.get_TableName())) {
                MInvoice invoice2 = (MInvoice)po;
                if (CFEUtils.isCFEtoSend(po.getCtx(), po.get_TrxName(), po)) {
                    LUYCFE cdfdi = LUYCFE.get();
                    cdfdi.setDocument(invoice2);
                    cdfdi.generate();
                }
            }
        } else if (timing == 13 && po.get_TableName().equals("C_Invoice") && (invoice = (MInvoice)po).isSOTrx()) {
            MInvoice reversal = new MInvoice(invoice.getCtx(), invoice.getReversal_ID(), po.get_TrxName());
            reversal.setDocumentNo(invoice.getDocumentNo() + "-" + reversal.getC_Invoice_ID());
            invoice.setDocumentNo(invoice.getDocumentNo() + "+" + invoice.getC_Invoice_ID());
            invoice.setDescription("(" + invoice.getDocumentNo() + ") <- (" + reversal.getDocumentNo() + ")");
            invoice.saveEx();
            reversal.setDescription("(" + reversal.getDocumentNo() + ") -> (" + invoice.getDocumentNo() + ")");
            reversal.saveEx();
            MDocType eDocType = MDocType.get(invoice.getCtx(), invoice.getC_DocType_ID());
            MSequence eSeq = new MSequence(invoice.getCtx(), eDocType.getDocNoSequence_ID(), invoice.get_TrxName());
            eSeq.setCurrentNext(eSeq.getCurrentNext() - 1);
            eSeq.save();
            log.info(po.toString());
        }
        return null;
    }

    private String getXML_AUX(MInvoice po, int pfid) throws TransformerException {
        String xmlReport = LUYModelValidator.getXMLFromReportEngine(po, pfid);
        String transformedCFE = this.getXMLTransform(xmlReport);
        return transformedCFE;
    }

    public static String getXMLFromReportEngine(PO po, int printFormatId) {
        MClient client = MClient.get(po.getCtx());
        Language language = client.getLanguage();
        MPrintFormat format = MPrintFormat.get(po.getCtx(), printFormatId, false);
        format.setLanguage(language);
        format.setTranslationLanguage(language);
        MQuery query = new MQuery(format.getAD_Table().getTableName());
        query.addRestriction(po.get_TableName() + "_ID", "=", po.get_ID());
        PrintInfo printInfo = new PrintInfo(po.get_ValueAsString("DocumentNo"), format.getAD_Table().getAD_Table_ID(), po.get_ID());
        printInfo.setCopies(1);
        printInfo.setDocumentCopy(false);
        printInfo.setPrinterName(format.getPrinterName());
        ReportEngine reportEngine = new ReportEngine(po.getCtx(), format, query, printInfo, po.get_TrxName());
        if (reportEngine == null) {
            throw new AdempiereException("@NotFound@ @M_PrintFormat_ID@");
        }
        reportEngine.getLayout();
        StringWriter stringWriter = new StringWriter();
        reportEngine.createXML(stringWriter);
        return stringWriter.getBuffer().toString();
    }

    public String getXMLTransform(String xmlReport) throws TransformerException {
        StringWriter transformedCFE = new StringWriter();
        return transformedCFE.getBuffer().toString();
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        String errorMessage = null;
        if (AD_Org_ID > 0) {
            if (MColumn.getColumn_ID("LUY_VendorInvoicy", "Col_1") <= 0) {
                errorMessage = "@Error@ Redmine #17445 Col_1 @NotFound@";
            }
            if (MColumn.getColumn_ID("LUY_VendorInvoicy", "Col_2") <= 0) {
                errorMessage = "@Error@ Redmine #17445 Col_2 @NotFound@";
            }
            if (MColumn.getColumn_ID("LUY_VendorInvoicy", "Col_3") <= 0) {
                errorMessage = "@Error@ Redmine #17445 Col_3 @NotFound@";
            }
        }
        return errorMessage;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LiberoValidator");
        return sb.toString();
    }
}

