/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.model;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.openup.LUY.model.LUYModelValidator;
import org.openup.LUY.model.MLUYDocument;
import org.openup.LUY.util.CFEUtils;

public class LUYCFEResponseValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(LUYModelValidator.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public int getAD_Client_ID() {
        return 0;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        if ("C_Invoice".equals(po.get_TableName())) {
            MInvoice invoice = (MInvoice)po;
            if (timing == 9 && CFEUtils.isCFEtoSend(invoice.getCtx(), invoice.get_TrxName(), invoice)) {
                Trx.run(trxName -> {
                    String strQuery = "Record_ID=?";
                    MLUYDocument mluyDocuments = (MLUYDocument)new Query(invoice.getCtx(), "LUY_Document", strQuery, trxName).setParameters(invoice.get_ID()).setOrderBy("Created DESC").first();
                    if (mluyDocuments == null || mluyDocuments.get_ID() <= 0) {
                        throw new AdempiereException("CFE Error: Respuesta no encontrada para documento CFE");
                    }
                    String cfeMsgExtraInfo = mluyDocuments.getCFEMsgExtraInfo();
                    if (cfeMsgExtraInfo != null && cfeMsgExtraInfo.contains("902")) {
                        throw new AdempiereException("CFE Error - 902 - CFE/Registro ya existe en la base de datos - " + cfeMsgExtraInfo);
                    }
                });
            }
        }
        return null;
    }
}

