/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.engine.vendor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang.StringEscapeUtils;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.openup.LUY.cfe.dto.generic.cfe.CFEEmpresasType;
import org.openup.LUY.engine.LUYVendorInterface;
import org.openup.LUY.model.MLUYDocument;
import org.openup.LUY.model.MLUYVendor;
import org.openup.LUY.model.MLUYVendorService;
import org.openup.LUY.util.WebServiceConnector;
import org.w3c.dom.NodeList;

public class LUYFoliosDigitalesService
implements LUYVendorInterface {
    public MLUYVendor m_vendor = MLUYVendor.getByClassName(this.getClass().getCanonicalName());

    public LUYFoliosDigitalesService() {
        if (this.m_vendor == null) {
            throw new AdempiereException("Implementaci\u00f3n para este proveedor de servicios no existe: " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public Source execute(MLUYDocument document, String SOAPType) throws Exception {
        MLUYVendorService service = this.m_vendor.getService(SOAPType);
        WebServiceConnector wsc = new WebServiceConnector();
        document.setCFDIXML(document.getCFDIXML().replace("\n", "").replaceAll(" +", " "));
        document.saveEx();
        String request = Env.parseVariable(service.getSOAPRequest(), document, document.get_TrxName(), true);
        request = Env.parseVariable(request, this.m_vendor, this.m_vendor.get_TrxName(), false);
        wsc.setRequest(request);
        wsc.setBinding(service.getSOAPBinding());
        wsc.setEndpointAddress(service.getSOAPEndpointAddress());
        wsc.setServiceName(service.getSOAPServiceName());
        wsc.setPortName(service.getSOAPPort());
        wsc.setTargetNS(service.getSOAPTargetNS());
        wsc.setSoapAction(service.getSOAPAction());
        wsc.executeConnector();
        Source response = wsc.getResponse();
        return response;
    }

    @Override
    public void sendGenericDto(CFEEmpresasType genericDto, PO document, Properties params) {
    }

    @Override
    public MLUYDocument getLUYDocument() {
        return null;
    }

    public String parse(Source response) throws TransformerFactoryConfigurationError, TransformerException, IOException, SOAPException {
        assert (response != null);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF8");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(response, result);
        String respxml = "";
        respxml = this.getXMLSealed(writer.toString());
        return respxml;
    }

    public String getXMLSealed(String respxml) throws AdempiereException, IOException, SOAPException {
        String[] respuesta = null;
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage(new MimeHeaders(), new ByteArrayInputStream(respxml.getBytes(Charset.forName("UTF-8"))));
        SOAPBody body = message.getSOAPBody();
        NodeList returnList = body.getElementsByTagName("TimbrarPruebaCFDIResult");
        NodeList innerRes = returnList.item(0).getChildNodes();
        boolean failed = false;
        respuesta = new String[innerRes.getLength()];
        String messageError = null;
        for (int i = 0; i < innerRes.getLength(); ++i) {
            respuesta[i] = innerRes.item(i).getTextContent();
            if (i >= 3 || respuesta[i].equals("")) continue;
            failed = true;
            messageError = respuesta[i];
        }
        if (failed) {
            throw new AdempiereException(messageError);
        }
        respuesta[3] = StringEscapeUtils.unescapeXml(respuesta[3]);
        return respuesta[3];
    }

    @Override
    public void setDocument(PO document) {
    }

    @Override
    public void getQR(MLUYDocument document) {
    }

    @Override
    public void getToken(MLUYDocument document) {
    }

    @Override
    public void getCFDI(MLUYDocument document) {
    }

    @Override
    public void getCancelCFDI(MLUYDocument document) {
    }
}

