/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.wms.services;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.wms.model.MWMInOutBoundLine;
import org.eevolution.wms.model.MWMInOutBoundLineMA;

public abstract class ExpressReceiptScanBar {
    public static CLogger log = CLogger.getCLogger(ExpressReceiptScanBar.class);
    private LinkedHashMap<MProduct, BigDecimal> scanLines = null;
    protected Boolean isLot = null;
    protected Boolean isSerNo = null;
    protected Boolean isSerNoMandotory = null;
    protected MProduct product = null;
    protected String lotNo = null;
    protected String serNo = null;
    protected int locatorId = 0;
    protected MTable table = null;
    protected MTable tableLine = null;
    protected int recordId = 0;
    protected PO parent = null;
    protected static int ID = 0;
    protected static int PRODUCT_ID = 1;
    protected static int QTY_ORDERED = 2;
    protected static int QTY_PICKED = 3;
    protected static int QTY_DELIVERED = 4;
    public LinkedHashMap<String, Vector> data = null;
    public LinkedHashMap<Integer, ArrayList<Object>> source = null;

    public LinkedHashMap<String, Vector> getData() {
        if (this.data == null) {
            this.loadData();
        }
        return this.data;
    }

    public MProduct getMProduct(String string) {
        MProduct mProduct = this.getProductByUPC(string);
        if (mProduct != null) {
            return mProduct;
        }
        mProduct = this.getProductByValueC(string);
        if (mProduct != null) {
            return mProduct;
        }
        int n = string.toUpperCase().indexOf("P");
        if (n > 0 && n <= 3) {
            mProduct = this.getProductByValueC(string.substring(n + 1));
        }
        return mProduct;
    }

    public MProduct getProductByUPC(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPPER(").append("UPC").append(")=?");
        return (MProduct)new Query(Env.getCtx(), "M_Product", stringBuilder.toString(), null).setClient_ID().setParameters(string.toUpperCase()).first();
    }

    public MProduct getProductByValueC(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPPER(").append("Value").append(")=?");
        return (MProduct)new Query(Env.getCtx(), "M_Product", stringBuilder.toString(), null).setClient_ID().setParameters(string.toUpperCase()).first();
    }

    public LinkedHashMap<MProduct, BigDecimal> getLines() {
        return this.scanLines;
    }

    public boolean findProduct(String string) {
        if (this.scanLines != null) {
            return this.scanLines.containsKey(string);
        }
        return false;
    }

    public BigDecimal getProductQty(String string) {
        return this.scanLines.get(string);
    }

    public Vector<String> getColumnNames() {
        Vector<String> vector = new Vector<String>(5);
        vector.add(Msg.translate(Env.getCtx(), "Value"));
        vector.add(Msg.translate(Env.getCtx(), "Name"));
        vector.add(Msg.translate(Env.getCtx(), "Lot"));
        vector.add(Msg.translate(Env.getCtx(), "SerNo"));
        vector.add(Msg.translate(Env.getCtx(), "QtyEntered"));
        return vector;
    }

    public void setColumnClass(IMiniTable iMiniTable) {
        iMiniTable.setColumnClass(0, String.class, true);
        iMiniTable.setColumnClass(1, String.class, true);
        iMiniTable.setColumnClass(2, String.class, true);
        iMiniTable.setColumnClass(3, String.class, true);
        iMiniTable.setColumnClass(4, BigDecimal.class, true);
        iMiniTable.autoSize();
    }

    public boolean isLot() {
        if (this.isLot == null) {
            MAttributeSet mAttributeSet = null;
            if (this.product.getM_AttributeSet_ID() > 0) {
                mAttributeSet = (MAttributeSet)this.product.getM_AttributeSet();
                this.isLot = mAttributeSet.isLot();
            } else {
                this.isLot = false;
            }
        }
        return this.isLot;
    }

    public boolean isSerNo() {
        if (this.isSerNo == null) {
            MAttributeSet mAttributeSet = null;
            if (this.product.getM_AttributeSet_ID() > 0) {
                mAttributeSet = (MAttributeSet)this.product.getM_AttributeSet();
                this.isSerNo = mAttributeSet.isSerNo();
                this.isSerNoMandotory = mAttributeSet.isSerNoMandatory();
            } else {
                this.isSerNo = false;
            }
        }
        return this.isSerNo;
    }

    public boolean isSerNoMandatory() {
        if (this.isSerNoMandotory != null) {
            return this.isSerNoMandotory;
        }
        this.isSerNo();
        return this.isSerNoMandotory;
    }

    public void setProduct(MProduct mProduct) {
        this.lotNo = null;
        this.serNo = null;
        this.isLot = null;
        this.isSerNo = null;
        if (mProduct == null) {
            this.product = null;
            return;
        }
        this.product = mProduct;
        this.isLot();
        this.isSerNo();
    }

    public String getLotNo() {
        return this.lotNo;
    }

    public String getSerNo() {
        return this.serNo;
    }

    protected void setLotNo(String string) {
        this.lotNo = string;
    }

    protected void setSerNo(String string) {
        this.serNo = string;
    }

    public MProduct getProduct() {
        return this.product;
    }

    protected void setData(LinkedHashMap<String, Vector> linkedHashMap) {
        this.data = linkedHashMap;
    }

    protected Vector<Vector<Object>> getDataModel() {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
        for (Vector vector2 : this.getData().values()) {
            Vector vector3 = new Vector();
            vector3.add(vector2.get(0));
            vector3.add(vector2.get(1));
            vector3.add(vector2.get(2));
            vector3.add(vector2.get(3));
            vector3.add(vector2.get(4));
            vector.add(vector3);
        }
        return vector;
    }

    protected PO getParent() {
        if (this.parent == null) {
            this.parent = this.getTable().getPO(this.getRecord_ID(), null);
        }
        return this.parent;
    }

    protected LinkedHashMap<Integer, ArrayList<Object>> getSource() {
        if (this.source != null) {
            return this.source;
        }
        List list = new Query(Env.getCtx(), "WM_InOutBoundLine", "WM_InOutBound_ID=?", null).setClient_ID().setParameters(this.getRecord_ID()).list();
        this.source = new LinkedHashMap();
        for (MWMInOutBoundLine mWMInOutBoundLine : list) {
            ArrayList<Number> arrayList = new ArrayList<Number>();
            arrayList.add(ID, mWMInOutBoundLine.getC_OrderLine_ID());
            arrayList.add(PRODUCT_ID, mWMInOutBoundLine.getM_Product_ID());
            arrayList.add(QTY_ORDERED, mWMInOutBoundLine.getPickedQty());
            arrayList.add(QTY_PICKED, mWMInOutBoundLine.getPickedQty());
            arrayList.add(QTY_DELIVERED, BigDecimal.ZERO);
            this.source.put(mWMInOutBoundLine.get_ID(), arrayList);
        }
        return this.source;
    }

    protected ArrayList<Object> checkProduct(MProduct mProduct, BigDecimal bigDecimal, boolean bl) {
        for (Map.Entry<Integer, ArrayList<Object>> entry : this.getSource().entrySet()) {
            ArrayList<Object> arrayList = entry.getValue();
            int n = (Integer)arrayList.get(PRODUCT_ID);
            BigDecimal bigDecimal2 = (BigDecimal)arrayList.get(QTY_PICKED);
            if (mProduct.get_ID() != n || bigDecimal2.signum() <= 0) continue;
            Integer n2 = (Integer)arrayList.get(ID);
            BigDecimal bigDecimal3 = (BigDecimal)arrayList.get(QTY_ORDERED);
            if (bigDecimal2 == null || bigDecimal2.signum() < 0) continue;
            if (bigDecimal2.compareTo(bigDecimal) <= 0) {
                arrayList.set(QTY_DELIVERED, bigDecimal2);
                bigDecimal2 = Env.ZERO;
            } else {
                if (bl) {
                    arrayList.set(QTY_DELIVERED, bigDecimal);
                    bigDecimal2 = bigDecimal3.subtract(bigDecimal);
                } else {
                    arrayList.set(QTY_DELIVERED, bigDecimal);
                    bigDecimal2 = bigDecimal2.subtract(bigDecimal);
                }
                if (bigDecimal2.signum() < 0) {
                    return null;
                }
            }
            arrayList.set(QTY_PICKED, bigDecimal2);
            this.source.put(entry.getKey(), arrayList);
            return arrayList;
        }
        return null;
    }

    protected int getM_Locater_ID() {
        return this.locatorId;
    }

    protected int getDefaultWarehouseId() {
        int n = Env.getContextAsInt(Env.getCtx(), this.getWindowNo(), "M_Locator_ID");
        int n2 = DB.getSQLValue(null, "SELECT M_Warehouse_ID FROM M_Locator WHERE M_Locator_ID = ? ", n);
        return n2;
    }

    protected int getRecord_ID() {
        if (this.recordId <= 0) {
            this.recordId = this.getProcessInfo().getRecord_ID();
        }
        return this.recordId;
    }

    protected MTable getTable() {
        if (this.table == null) {
            this.table = MTable.get(Env.getCtx(), this.getProcessInfo().getTable_ID());
        }
        return this.table;
    }

    protected MTable getTableLine() {
        return this.tableLine;
    }

    public void createLines() {
        Object object;
        for (Vector vector : this.getData().values()) {
            int n = (Integer)vector.get(5);
            object = new MWMInOutBoundLine(Env.getCtx(), n, null);
            for (MWMInOutBoundLineMA serializable : this.getLinesMA((MWMInOutBoundLine)object)) {
                serializable.deleteEx(true);
            }
        }
        for (Vector vector : this.getData().values()) {
            String string = (String)vector.get(0);
            object = (String)vector.get(2);
            String string2 = (String)vector.get(3);
            Boolean bl = object != null && ((String)object).length() > 0 || string2 != null && string2.length() > 0;
            BigDecimal bigDecimal = (BigDecimal)vector.get(4);
            int n = (Integer)vector.get(5);
            Integer n2 = (Integer)vector.get(6);
            MWMInOutBoundLine mWMInOutBoundLine = null;
            MAttributeSetInstance mAttributeSetInstance = null;
            MProduct mProduct = (MProduct)new Query(Env.getCtx(), "M_Product", "Value = ? ", null).setClient_ID().setParameters(string).firstOnly();
            Object object2 = null;
            if (n2 > 0) {
                mWMInOutBoundLine = this.getMWMInOutBoundLine(n2, mProduct.get_ID());
            }
            if (mProduct.getM_AttributeSet_ID() > 0 && bl.booleanValue() && (mAttributeSetInstance = this.getASI(mProduct, (String)object, string2)) == null) {
                mAttributeSetInstance = this.getAttributeSetInstance(mProduct, (String)object, string2, this.getM_Locater_ID(), null);
            }
            MWMInOutBoundLineMA mWMInOutBoundLineMA = new MWMInOutBoundLineMA(Env.getCtx(), 0, null);
            if (mAttributeSetInstance == null && bl.booleanValue()) {
                mAttributeSetInstance = new MAttributeSetInstance(Env.getCtx(), 0, mProduct.getM_AttributeSet_ID(), null);
                if (object != null) {
                    mAttributeSetInstance.setLot((String)object);
                    object2 = object;
                }
                if (string2 != null) {
                    mAttributeSetInstance.setSerNo(string2);
                    object2 = object2 != null ? (String)object2 + " - " + (String)string2 : string2;
                }
                mAttributeSetInstance.setDescription((String)object2);
                mAttributeSetInstance.saveEx();
            }
            mWMInOutBoundLineMA.setWM_InOutBoundLine_ID(mWMInOutBoundLine.get_ID());
            mWMInOutBoundLineMA.setM_AttributeSetInstance_ID(mAttributeSetInstance == null ? 0 : mAttributeSetInstance.getM_AttributeSetInstance_ID());
            mWMInOutBoundLineMA.setMovementQty(bigDecimal);
            mWMInOutBoundLineMA.saveEx();
            mWMInOutBoundLine.setMovementQty(mWMInOutBoundLine.getMovementQty().add(bigDecimal));
            mWMInOutBoundLine.saveEx();
        }
    }

    private MWMInOutBoundLine getMWMInOutBoundLine(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WM_InOutBound_ID").append("=? AND ");
        stringBuilder.append("C_OrderLine_ID").append("=? AND ");
        stringBuilder.append("M_Product_ID").append("=? ");
        return (MWMInOutBoundLine)new Query(Env.getCtx(), "WM_InOutBoundLine", stringBuilder.toString(), null).setClient_ID().setParameters(this.getRecord_ID(), n, n2).firstOnly();
    }

    private MAttributeSetInstance getASI(MProduct mProduct, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        stringBuilder.append("M_AttributeSet_ID").append("=? ");
        arrayList.add(mProduct.getM_AttributeSet_ID());
        if (string != null && string.length() > 0) {
            stringBuilder.append(" AND ").append("UPPER(").append("Lot").append(")=? ");
            arrayList.add(string.toUpperCase().trim());
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" AND ").append("UPPER(").append("SerNo").append(")=? ");
            arrayList.add(string2.toUpperCase().trim());
        }
        return (MAttributeSetInstance)new Query(Env.getCtx(), "M_AttributeSetInstance", stringBuilder.toString(), mProduct.get_TrxName()).setClient_ID().setParameters(arrayList).first();
    }

    private MAttributeSetInstance getAttributeSetInstance(MProduct mProduct, String string, String string2, int n, String string3) {
        StringBuilder stringBuilder = new StringBuilder("EXISTS (SELECT 1 FROM M_Storage s WHERE s.M_Product_ID=? AND s.M_Locator_ID=? AND s.M_AttributeSetInstance_ID=M_AttributeSetInstance.M_AttributeSetInstance_ID)");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(mProduct.get_ID());
        arrayList.add(n);
        if (string != null && string.length() > 0) {
            stringBuilder.append(" AND ").append("Lot").append("=?");
            arrayList.add(string);
        }
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(" AND ").append("SerNo").append("=?");
            arrayList.add(string2);
        }
        return (MAttributeSetInstance)new Query(Env.getCtx(), "M_AttributeSetInstance", stringBuilder.toString(), string3).setClient_ID().setParameters(arrayList).first();
    }

    protected void loadData() {
        this.data = new LinkedHashMap();
        for (MWMInOutBoundLine pO : this.getInOutBoundLines()) {
            pO.setMovementQty(Env.ZERO);
            pO.saveEx();
        }
        for (MWMInOutBoundLineMA mWMInOutBoundLineMA : this.getDocumentLines()) {
            MProduct mProduct = null;
            MAttributeSetInstance mAttributeSetInstance = null;
            String string = null;
            String string2 = null;
            Integer n = null;
            BigDecimal bigDecimal = null;
            boolean bl = false;
            MWMInOutBoundLine mWMInOutBoundLine = new MWMInOutBoundLine(mWMInOutBoundLineMA.getCtx(), mWMInOutBoundLineMA.getWM_InOutBoundLine_ID(), mWMInOutBoundLineMA.get_TrxName());
            int n2 = mWMInOutBoundLine.getM_Product_ID();
            int n3 = mWMInOutBoundLineMA.getM_AttributeSetInstance_ID();
            if (n2 <= 0) continue;
            mProduct = MProduct.get(Env.getCtx(), n2);
            if (n3 > 0) {
                mAttributeSetInstance = new MAttributeSetInstance(Env.getCtx(), n3, null);
                string = mAttributeSetInstance.getLot();
                string2 = mAttributeSetInstance.getSerNo();
            } else {
                n3 = 0;
                bl = true;
            }
            bigDecimal = mWMInOutBoundLineMA.getMovementQty();
            ArrayList<Object> arrayList = null;
            while (bigDecimal.signum() != 0) {
                if (this.getSource() != null && this.source.size() > 0 && (arrayList = this.checkProduct(mProduct, bigDecimal, bl)) == null) {
                    throw new AdempiereException("@M_Product_ID@ ; " + mProduct.getName() + " @InValid@");
                }
                n = (Integer)arrayList.get(ID);
                Object object = mProduct.getValue();
                if (string != null && string.length() > 0) {
                    object = (String)object + string;
                }
                if (string2 != null && string2.length() > 0) {
                    object = (String)object + string2;
                }
                if (string2 == null) {
                    object = (String)object + "#" + n;
                }
                Vector<Object> vector = new Vector<Object>(6);
                vector.add(mProduct.getValue());
                vector.add(mProduct.getName());
                vector.add(string);
                vector.add(string2);
                BigDecimal bigDecimal2 = (BigDecimal)arrayList.get(QTY_DELIVERED);
                bigDecimal = bigDecimal.subtract(bigDecimal2);
                vector.add(bigDecimal2);
                vector.add(mWMInOutBoundLine.get_ID());
                vector.add(n != null ? n : 0);
                this.data.put((String)object, vector);
            }
        }
    }

    private List<MWMInOutBoundLineMA> getDocumentLines() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" EXISTS (SELECT 1 FROM WM_InOutBoundLine il ").append(" INNER JOIN WM_InOutBoundLineMA ma ON (ma.WM_InOutBoundLine_ID=il.WM_InOutBoundLine_ID) ").append(" WHERE il.WM_InOutBoundLine_ID=WM_InOutBoundLineMA.WM_InOutBoundLine_ID AND il.WM_InOutBound_ID=? ORDER BY ma.WM_InOutBoundLine_ID,  ma.WM_InOutBoundLineMA_ID) ");
        return new Query(Env.getCtx(), "WM_InOutBoundLineMA", stringBuilder.toString(), null).setClient_ID().setParameters(this.getRecord_ID()).setOrderBy("WM_InOutBoundLine_ID").list();
    }

    private List<MWMInOutBoundLine> getInOutBoundLines() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WM_InOutBound_ID").append("=?");
        return new Query(Env.getCtx(), "WM_InOutBoundLine", stringBuilder.toString(), null).setClient_ID().setParameters(this.getRecord_ID()).list();
    }

    public List<MWMInOutBoundLineMA> getLinesMA(MWMInOutBoundLine mWMInOutBoundLine) {
        StringBuilder stringBuilder = new StringBuilder("WM_InOutBoundLine_ID").append("=?");
        return new Query(mWMInOutBoundLine.getCtx(), "WM_InOutBoundLineMA", stringBuilder.toString(), mWMInOutBoundLine.get_TrxName()).setClient_ID().setParameters(mWMInOutBoundLine.getWM_InOutBoundLine_ID()).list();
    }

    public abstract ProcessInfo getProcessInfo();

    public abstract int getWindowNo();
}

