/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.wms.process;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.eevolution.wms.model.MWMInOutBound;
import org.eevolution.wms.model.MWMInOutBoundLine;
import org.eevolution.wms.process.ProcessingInvoiceSelectionAbstract;

public class ProcessingInvoiceSelection
extends ProcessingInvoiceSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MInvoice> list = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTable_ID() == MWMInOutBound.Table_ID) {
            this.createInboundLineFrom(list);
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.UpdatingInvoiceProperties(list);
        }
        return "";
    }

    private void UpdatingInvoiceProperties(List<MInvoice> list) {
        list.stream().filter(mInvoice -> mInvoice != null).forEach(mInvoice -> {
            int n = mInvoice.get_ColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = mInvoice.get_ColumnName(i);
                Optional.ofNullable(this.getSelection(mInvoice.get_ID(), this.getPrefixAliasForTableSelection() + string)).ifPresent(object -> mInvoice.set_ValueOfColumn(string, object));
            }
            mInvoice.saveEx();
        });
    }

    private void createInboundLineFrom(List<MInvoice> list) {
        MWMInOutBound mWMInOutBound = (MWMInOutBound)this.getInstance(this.get_TrxName());
        AtomicInteger atomicInteger = new AtomicInteger(10);
        list.stream().filter(mInvoice -> mInvoice != null).flatMap(mInvoice -> Arrays.stream(mInvoice.getLines(true))).forEach(mInvoiceLine -> {
            MWMInOutBoundLine mWMInOutBoundLine = MWMInOutBoundLine.getByInvoiceLine(mInvoiceLine);
            if (mWMInOutBoundLine == null) {
                mWMInOutBoundLine = new MWMInOutBoundLine(mWMInOutBound, (MInvoiceLine)mInvoiceLine);
                mWMInOutBoundLine.setLine(atomicInteger.get());
                mWMInOutBoundLine.saveEx();
                atomicInteger.updateAndGet(n -> n + 10);
            }
        });
    }
}

