/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.wms.process;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.adempiere.core.domains.models.I_DD_Order;
import org.adempiere.core.domains.models.X_C_OrderLine;
import org.adempiere.core.domains.models.X_DD_OrderLine;
import org.adempiere.core.domains.models.X_M_InOutLine;
import org.adempiere.core.domains.models.X_PP_Order_BOMLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MStorage;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.distribution.process.MovementGenerate;
import org.eevolution.manufacturing.model.MPPCostCollector;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPOrderBOMLine;
import org.eevolution.services.dsl.ProcessBuilder;
import org.eevolution.wms.model.MWMInOutBound;
import org.eevolution.wms.model.MWMInOutBoundLine;
import org.eevolution.wms.process.GenerateShipmentOutBoundAbstract;

public class GenerateShipmentOutBound
extends GenerateShipmentOutBoundAbstract {
    private Hashtable<Integer, MInOut> shipments = new Hashtable();
    private Hashtable<Integer, I_DD_Order> distributionOrders = new Hashtable();
    private Hashtable<Integer, MPPCostCollector> manufacturingIssues = new Hashtable();
    private int documentCreated = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.getProcessInfo().setTableSelectionId(MWMInOutBoundLine.Table_ID);
        List<?> list = this.getInstancesForSelection(this.get_TrxName());
        list.stream().filter(mWMInOutBoundLine -> mWMInOutBoundLine.getQtyToDeliver().signum() > 0 || this.isIncludeNotAvailable()).forEach(this::createShipment);
        this.processingShipments();
        this.processingMovements();
        this.processingIssues();
        StringBuilder stringBuilder = new StringBuilder();
        this.shipments.forEach((n, mInOut) -> stringBuilder.append(" , ").append(mInOut.getDocumentInfo()));
        return "@Created@ " + this.documentCreated + stringBuilder.toString();
    }

    private void createShipment(MWMInOutBoundLine mWMInOutBoundLine) {
        Object object;
        Serializable serializable;
        MStorage[] mStorageArray;
        PO pO;
        if (mWMInOutBoundLine.getC_OrderLine_ID() > 0) {
            pO = mWMInOutBoundLine.getOrderLine();
            if (((MOrderLine)pO).getQtyToDelivery().subtract(mWMInOutBoundLine.getPickedQty()).signum() < 0 && !this.isIncludeNotAvailable()) {
                return;
            }
            mStorageArray = this.getSalesOrderQtyToDelivery(mWMInOutBoundLine, (MOrderLine)pO);
            serializable = this.getShipment((MOrderLine)pO, mWMInOutBoundLine.getParent());
            object = new MInOutLine(mWMInOutBoundLine.getCtx(), 0, mWMInOutBoundLine.get_TrxName());
            ((X_M_InOutLine)object).setM_InOut_ID(serializable.getM_InOut_ID());
            ((MInOutLine)object).setM_Locator_ID(mWMInOutBoundLine.getM_LocatorTo_ID());
            ((X_M_InOutLine)object).setM_Product_ID(mWMInOutBoundLine.getM_Product_ID());
            ((X_M_InOutLine)object).setDescription(mWMInOutBoundLine.getDescription());
            ((X_M_InOutLine)object).setC_UOM_ID(mWMInOutBoundLine.getC_UOM_ID());
            ((MInOutLine)object).setQtyEntered((BigDecimal)mStorageArray);
            ((MInOutLine)object).setMovementQty((BigDecimal)mStorageArray);
            ((X_M_InOutLine)object).setC_OrderLine_ID(((X_C_OrderLine)pO).getC_OrderLine_ID());
            ((X_M_InOutLine)object).setM_Shipper_ID(mWMInOutBoundLine.getM_Shipper_ID());
            ((X_M_InOutLine)object).setM_FreightCategory_ID(mWMInOutBoundLine.getM_FreightCategory_ID());
            ((X_M_InOutLine)object).setFreightAmt(mWMInOutBoundLine.getFreightAmt());
            ((X_M_InOutLine)object).setM_AttributeSetInstance_ID(mWMInOutBoundLine.getM_AttributeSetInstance_ID());
            ((X_M_InOutLine)object).setWM_InOutBoundLine_ID(mWMInOutBoundLine.getWM_InOutBoundLine_ID());
            ((PO)object).saveEx();
        }
        if (mWMInOutBoundLine.getDD_OrderLine_ID() > 0) {
            pO = new MDDOrderLine(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getDD_OrderLine_ID(), mWMInOutBoundLine.get_TrxName());
            ((X_DD_OrderLine)pO).setDescription(mWMInOutBoundLine.getDescription());
            if (this.distributionOrders.get(((X_DD_OrderLine)pO).getDD_Order_ID()) == null) {
                this.distributionOrders.put(((X_DD_OrderLine)pO).getDD_Order_ID(), ((MDDOrderLine)pO).getParent());
            }
            ((X_DD_OrderLine)pO).setConfirmedQty(this.getDistributionOrderQtyToDelivery(mWMInOutBoundLine, (MDDOrderLine)pO));
            pO.saveEx();
        }
        if (mWMInOutBoundLine.getPP_Order_BOMLine_ID() > 0) {
            pO = (MPPOrderBOMLine)mWMInOutBoundLine.getPP_Order_BOMLine();
            if (mWMInOutBoundLine.getPickedQty().subtract(((X_PP_Order_BOMLine)pO).getQtyDelivered()).signum() < 0 && !this.isIncludeNotAvailable()) {
                return;
            }
            mStorageArray = MStorage.getAll(this.getCtx(), ((X_PP_Order_BOMLine)pO).getM_Product_ID(), mWMInOutBoundLine.getM_LocatorTo_ID(), this.get_TrxName());
            serializable = this.getManufacturingOrderQtyToDelivery(mWMInOutBoundLine, (MPPOrderBOMLine)pO);
            object = MPPOrder.createIssue(((MPPOrderBOMLine)pO).getParent(), (MPPOrderBOMLine)pO, this.getMovementDate(), (BigDecimal)serializable, BigDecimal.ZERO, BigDecimal.ZERO, mStorageArray, true);
            object.forEach(mPPCostCollector -> {
                mPPCostCollector.setDescription(mWMInOutBoundLine.getDescription());
                mPPCostCollector.saveEx();
                if (this.manufacturingIssues.get(mPPCostCollector.getPP_Cost_Collector_ID()) == null) {
                    this.manufacturingIssues.put(mPPCostCollector.getPP_Cost_Collector_ID(), (MPPCostCollector)mPPCostCollector);
                }
            });
        }
    }

    private BigDecimal getSalesOrderQtyToDelivery(MWMInOutBoundLine mWMInOutBoundLine, MOrderLine mOrderLine) {
        BigDecimal bigDecimal;
        if (this.isIncludeNotAvailable()) {
            bigDecimal = mWMInOutBoundLine.getQtyToPick();
        } else {
            BigDecimal bigDecimal2 = mOrderLine.getQtyToDelivery();
            BigDecimal bigDecimal3 = mWMInOutBoundLine.getPickedQty().subtract(mWMInOutBoundLine.getShipmentQtyDelivered());
            bigDecimal = bigDecimal3.compareTo(bigDecimal2) > 0 ? bigDecimal2 : (!"F".equals(mOrderLine.getParent().getDeliveryRule()) && !"M".equals(mOrderLine.getParent().getDeliveryRule()) ? bigDecimal3 : bigDecimal2);
        }
        return bigDecimal;
    }

    private BigDecimal getManufacturingOrderQtyToDelivery(MWMInOutBoundLine mWMInOutBoundLine, MPPOrderBOMLine mPPOrderBOMLine) {
        BigDecimal bigDecimal;
        if (this.isIncludeNotAvailable()) {
            bigDecimal = mWMInOutBoundLine.getQtyToPick();
        } else {
            BigDecimal bigDecimal2 = mPPOrderBOMLine.getQtyRequired().subtract(mPPOrderBOMLine.getQtyRequired());
            BigDecimal bigDecimal3 = mWMInOutBoundLine.getPickedQty().subtract(mWMInOutBoundLine.getManufacturingOrderQtyDelivered());
            bigDecimal = bigDecimal3.compareTo(bigDecimal2) > 0 ? bigDecimal2 : (!"F".equals(mPPOrderBOMLine.getParent().getDeliveryRule()) && !"M".equals(mPPOrderBOMLine.getParent().getDeliveryRule()) ? bigDecimal3 : bigDecimal2);
        }
        return bigDecimal;
    }

    private BigDecimal getDistributionOrderQtyToDelivery(MWMInOutBoundLine mWMInOutBoundLine, MDDOrderLine mDDOrderLine) {
        BigDecimal bigDecimal;
        if (this.isIncludeNotAvailable()) {
            bigDecimal = mWMInOutBoundLine.getQtyToPick();
        } else {
            BigDecimal bigDecimal2 = mDDOrderLine.getQtyToDeliver();
            BigDecimal bigDecimal3 = mWMInOutBoundLine.getPickedQty().subtract(mWMInOutBoundLine.getDistributionOrderQtyDelivered());
            bigDecimal = bigDecimal3.compareTo(bigDecimal2) > 0 ? bigDecimal2 : (!"F".equals(mDDOrderLine.getParent().getDeliveryRule()) && !"M".equals(mDDOrderLine.getParent().getDeliveryRule()) ? bigDecimal3 : bigDecimal2);
        }
        return bigDecimal;
    }

    private void processingIssues() {
        this.manufacturingIssues.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            MPPCostCollector mPPCostCollector = (MPPCostCollector)entry.getValue();
            if ("DR".equals(mPPCostCollector.getDocStatus()) || "IP".equals(mPPCostCollector.getDocStatus())) {
                if (!mPPCostCollector.processIt("CO")) {
                    this.addLog("@ProcessFailed@ : " + mPPCostCollector.getDocumentInfo());
                    this.log.warning("@ProcessFailed@ :" + mPPCostCollector.getDocumentInfo());
                }
                mPPCostCollector.saveEx();
            }
        });
    }

    private void processingShipments() {
        ArrayList<PO> arrayList = new ArrayList<PO>();
        this.shipments.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            MInOut mInOut = (MInOut)entry.getValue();
            if (!mInOut.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + mInOut.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + mInOut.getDocumentInfo());
            }
            mInOut.saveEx();
            ++this.documentCreated;
            this.addLog(mInOut.getDocumentInfo());
            arrayList.add(mInOut);
        });
        this.printDocument(arrayList, true);
    }

    private void processingMovements() {
        this.distributionOrders.entrySet().stream().filter(Objects::nonNull).forEach(entry -> {
            I_DD_Order i_DD_Order = (I_DD_Order)entry.getValue();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(i_DD_Order.getDD_Order_ID());
            ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(MovementGenerate.getProcessId()).withSelectedRecordsIds(MDDOrder.Table_ID, arrayList).withParameter("M_Warehouse_ID", i_DD_Order.getM_Warehouse_ID()).withParameter("MovementDate", this.getMovementDate()).withoutTransactionClose().execute(this.get_TrxName());
            if (processInfo.isError()) {
                throw new AdempiereException(processInfo.getSummary());
            }
            this.addLog(processInfo.getSummary());
            Arrays.stream(processInfo.getIDs()).forEach(n -> {
                Optional<MMovement> optional = Optional.ofNullable(new MMovement(this.getCtx(), n, this.get_TrxName()));
                optional.ifPresent(mMovement -> {
                    ++this.documentCreated;
                    this.printDocument((PO)mMovement, true);
                });
            });
        });
    }

    private MInOut getShipment(MOrderLine mOrderLine, MWMInOutBound mWMInOutBound) {
        MInOut mInOut = this.shipments.get(mOrderLine.getC_Order_ID());
        if (mInOut != null) {
            return mInOut;
        }
        MOrder mOrder = mOrderLine.getParent();
        MDocType mDocType = (MDocType)mOrder.getC_DocType();
        int n = mDocType.getC_DocTypeShipment_ID();
        if (n == 0) {
            n = MDocType.getDocType("MMS", mOrderLine.getAD_Org_ID());
        }
        mInOut = new MInOut(mOrder, n, this.getMovementDate());
        mInOut.setIsSOTrx(true);
        mInOut.setM_Shipper_ID(mWMInOutBound.getM_Shipper_ID());
        mInOut.setDescription(mWMInOutBound.getDescription());
        mInOut.setM_FreightCategory_ID(mWMInOutBound.getM_FreightCategory_ID());
        mInOut.setFreightCostRule(mWMInOutBound.getFreightCostRule());
        mInOut.setFreightAmt(mWMInOutBound.getFreightAmt());
        mInOut.setDocAction("CO");
        mInOut.setDocStatus("DR");
        mInOut.saveEx();
        this.shipments.put(mOrder.getC_Order_ID(), mInOut);
        return mInOut;
    }
}

