/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.wms.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.X_WM_InOutBoundLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.wms.model.MWMInOutBound;

public class MWMInOutBoundLine
extends X_WM_InOutBoundLine {
    private static final long serialVersionUID = 8397162302198048638L;
    private static CLogger s_log = CLogger.getCLogger(MWMInOutBoundLine.class);
    private MWMInOutBound parent = null;
    private MProduct product = null;
    private MOrderLine orderLine = null;
    private MInvoiceLine invoiceLine = null;
    private MBPartner partner = null;

    public static MWMInOutBoundLine getByInvoiceLine(MInvoiceLine mInvoiceLine) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("C_InvoiceLine_ID").append("=?");
        return (MWMInOutBoundLine)new Query(mInvoiceLine.getCtx(), "WM_InOutBoundLine", stringBuilder.toString(), mInvoiceLine.get_TrxName()).setClient_ID().setParameters(mInvoiceLine.getC_InvoiceLine_ID()).first();
    }

    public static MWMInOutBoundLine getByOrderLine(MOrderLine mOrderLine) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("C_OrderLine_ID").append("=?");
        return (MWMInOutBoundLine)new Query(mOrderLine.getCtx(), "WM_InOutBoundLine", stringBuilder.toString(), mOrderLine.get_TrxName()).setClient_ID().setParameters(mOrderLine.getC_OrderLine_ID()).first();
    }

    public BigDecimal getShipmentQtyDelivered() {
        return new Query(this.getCtx(), "M_InOutLine", "WM_InOutBoundLine_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getWM_InOutBoundLine_ID()).sum("MovementQty");
    }

    public BigDecimal getManufacturingOrderQtyDelivered() {
        return new Query(this.getCtx(), "PP_Cost_Collector", "WM_InOutBoundLine_ID=?", this.get_TrxName()).setClient_ID().setParameters(this.getWM_InOutBoundLine_ID()).sum("MovementQty");
    }

    public BigDecimal getDistributionOrderQtyDelivered() {
        return new Query(this.getCtx(), "M_MovementLine", "WM_InOutBoundLine_ID=? AND M_Locator_ID=? ", this.get_TrxName()).setClient_ID().setParameters(this.getWM_InOutBoundLine_ID(), this.getM_LocatorTo_ID()).sum("MovementQty");
    }

    public MWMInOutBoundLine(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setProcessed(false);
        }
    }

    public MWMInOutBoundLine(Properties properties, int n) {
        this(properties, n, null);
    }

    public MWMInOutBoundLine(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MWMInOutBoundLine(MWMInOutBound mWMInOutBound) {
        this(mWMInOutBound.getCtx(), 0, mWMInOutBound.get_TrxName());
        this.setWM_InOutBound_ID(mWMInOutBound.getWM_InOutBound_ID());
    }

    public MWMInOutBoundLine(MWMInOutBound mWMInOutBound, MInvoiceLine mInvoiceLine) {
        this(mWMInOutBound.getCtx(), 0, mWMInOutBound.get_TrxName());
        this.setWM_InOutBound_ID(mWMInOutBound.get_ID());
        this.setC_Invoice_ID(mInvoiceLine.getC_Invoice_ID());
        this.setC_InvoiceLine_ID(mInvoiceLine.getC_InvoiceLine_ID());
        this.setMovementQty(mInvoiceLine.getQtyInvoiced());
        this.setM_Product_ID(mInvoiceLine.getM_Product_ID());
        this.setC_Charge_ID(mInvoiceLine.getC_Charge_ID());
        this.setC_UOM_ID(mInvoiceLine.getC_UOM_ID());
        this.setDescription(mInvoiceLine.getDescription());
    }

    public MWMInOutBoundLine(MWMInOutBound mWMInOutBound, MOrderLine mOrderLine) {
        this(mWMInOutBound.getCtx(), 0, mWMInOutBound.get_TrxName());
        this.setWM_InOutBound_ID(mWMInOutBound.get_ID());
        this.setC_Order_ID(mOrderLine.getC_Order_ID());
        this.setC_OrderLine_ID(mOrderLine.getC_OrderLine_ID());
        this.setMovementQty(this.getQtyToDeliver());
        this.setM_Product_ID(mOrderLine.getM_Product_ID());
        this.setC_Charge_ID(mOrderLine.getC_Charge_ID());
        this.setC_UOM_ID(mOrderLine.getC_UOM_ID());
        this.setDescription(mOrderLine.getDescription());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MInOutBoundLine[").append(this.get_ID()).append("-").append("").append("]");
        return stringBuffer.toString();
    }

    public MWMInOutBound getParent() {
        return Optional.ofNullable(this.parent).orElseGet(() -> new MWMInOutBound(this.getCtx(), this.getWM_InOutBound_ID(), this.get_TrxName()));
    }

    public MProduct getProduct() {
        return Optional.ofNullable(this.product).orElseGet(() -> MProduct.get(this.getCtx(), this.getM_Product_ID()));
    }

    public MOrderLine getOrderLine() {
        return Optional.ofNullable(this.orderLine).orElseGet(() -> new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName()));
    }

    public MInvoiceLine getInvoiceLine() {
        return Optional.ofNullable(this.invoiceLine).orElseGet(() -> new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName()));
    }

    public MBPartner getBPartner() {
        return Optional.ofNullable(this.partner).orElseGet(() -> (MBPartner)this.getOrderLine().getC_BPartner());
    }

    public BigDecimal getQtyToPick() {
        return this.getMovementQty().subtract(this.getPickedQty());
    }

    public BigDecimal getQtyToDeliver() {
        if (this.getC_OrderLine_ID() > 0) {
            Optional<MOrderLine> optional = Optional.ofNullable(this.getOrderLine());
            AtomicReference<BigDecimal> atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            optional.ifPresent(i_C_OrderLine -> {
                BigDecimal bigDecimal = MUOMConversion.convertProductFrom(this.getCtx(), i_C_OrderLine.getM_Product_ID(), i_C_OrderLine.getC_UOM_ID(), i_C_OrderLine.getQtyOrdered().subtract(i_C_OrderLine.getQtyDelivered()));
                atomicReference.set(bigDecimal);
            });
            return atomicReference.get();
        }
        if (this.getDD_OrderLine_ID() != 0) {
            AtomicReference<BigDecimal> atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            if (this.getDD_OrderLine_ID() > 0) {
                MDDOrderLine mDDOrderLine = new MDDOrderLine(this.getCtx(), this.getDD_OrderLine_ID(), this.get_TrxName());
                BigDecimal bigDecimal = MUOMConversion.convertProductFrom(this.getCtx(), mDDOrderLine.getM_Product_ID(), mDDOrderLine.getC_UOM_ID(), mDDOrderLine.getQtyOrdered().subtract(mDDOrderLine.getQtyDelivered()));
                atomicReference.set(bigDecimal);
            }
            return atomicReference.get();
        }
        return Env.ZERO;
    }

    public int getM_Warehouse_ID() {
        return this.getParent().getM_Warehouse_ID();
    }
}

