/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPayment;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.Env;

public class ProjectModelValidator
implements ModelValidator {
    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        engine.addDocValidate("C_Payment", this);
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_InvoiceLine", this);
        engine.addModelChange("C_Payment", this);
        engine.addModelChange("C_ProjectPhase", this);
        engine.addModelChange("C_ProjectTask", this);
    }

    @Override
    public int getAD_Client_ID() {
        return Env.getAD_Client_ID(Env.getCtx());
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return "";
    }

    @Override
    public String modelChange(PO entity, int type) {
        MProjectTask pTask;
        MProjectPhase pPhase;
        MProjectPhase pPhase2;
        MProject project;
        if (2 == type) {
            MProjectTask pTask2;
            BigDecimal diffAmt;
            Object oldAmt;
            Integer projectId = entity.get_ValueAsInt("C_Project_ID");
            if (projectId > 0) {
                project = new MProject(entity.getCtx(), projectId, entity.get_TrxName());
                if (entity.get_ColumnIndex("C_Campaign_ID") > 0 && entity.get_ValueAsInt("C_Campaign_ID") <= 0 && project.getC_Campaign_ID() > 0) {
                    entity.set_ValueOfColumn("C_Campaign_ID", (Object)project.getC_Campaign_ID());
                }
                if (entity.get_ColumnIndex("C_Activity_ID") > 0 && entity.get_ValueAsInt("C_Activity_ID") <= 0 && project.getC_Activity_ID() > 0) {
                    entity.set_ValueOfColumn("C_Activity_ID", (Object)project.getC_Activity_ID());
                }
                if (entity.get_ColumnIndex("User1_ID") > 0 && entity.get_ValueAsInt("User1_ID") <= 0 && project.getUser1_ID() > 0) {
                    entity.set_ValueOfColumn("User1_ID", (Object)project.getUser1_ID());
                }
                if (entity.get_ColumnIndex("User2_ID") > 0 && entity.get_ValueAsInt("User2_ID") <= 0 && project.getUser2_ID() > 0) {
                    entity.set_ValueOfColumn("User2_ID", (Object)project.getUser2_ID());
                }
                if (entity.get_ColumnIndex("User3_ID") > 0 && entity.get_ValueAsInt("User3_ID") <= 0 && project.getUser3_ID() > 0) {
                    entity.set_ValueOfColumn("User3_ID", (Object)project.getUser3_ID());
                }
                if (entity.get_ColumnIndex("User4_ID") > 0 && entity.get_ValueAsInt("User4_ID") <= 0 && project.getUser4_ID() > 0) {
                    entity.set_ValueOfColumn("User4_ID", (Object)project.getUser4_ID());
                }
            }
            if (entity.get_Table_ID() == MProjectPhase.Table_ID && entity.is_ValueChanged("PlannedAmt")) {
                pPhase2 = (MProjectPhase)entity;
                if (pPhase2.getC_ProjectPhase_ID() != 0) {
                    MProject project2;
                    oldAmt = Env.ZERO;
                    diffAmt = Env.ZERO;
                    if (pPhase2.get_ValueOld("PlannedAmt") != null && pPhase2.getLines().size() == 0) {
                        oldAmt = (BigDecimal)pPhase2.get_ValueOld("PlannedAmt");
                        diffAmt = pPhase2.getPlannedAmt().subtract((BigDecimal)oldAmt);
                    }
                    if ((project2 = (MProject)pPhase2.getC_Project()).getC_Project_ID() != 0 && !diffAmt.equals(Env.ZERO)) {
                        project2.setPlannedAmt(project2.getPlannedAmt().add(diffAmt));
                        project2.saveEx();
                    }
                }
            } else if (entity.get_Table_ID() == MProjectTask.Table_ID && entity.is_ValueChanged("PlannedAmt") && (pTask2 = (MProjectTask)entity).getC_ProjectTask_ID() != 0) {
                MProjectPhase pPhase3;
                oldAmt = Env.ZERO;
                diffAmt = Env.ZERO;
                if (pTask2.get_ValueOld("PlannedAmt") != null && pTask2.getLines().length == 0) {
                    oldAmt = (BigDecimal)pTask2.get_ValueOld("PlannedAmt");
                    diffAmt = pTask2.getPlannedAmt().subtract((BigDecimal)oldAmt);
                }
                if ((pPhase3 = (MProjectPhase)pTask2.getC_ProjectPhase()).getC_ProjectPhase_ID() != 0 && !diffAmt.equals(Env.ZERO)) {
                    pPhase3.setPlannedAmt(pPhase3.getPlannedAmt().add(diffAmt));
                    pPhase3.saveEx();
                }
            }
        }
        if (4 == type) {
            if (entity.get_Table_ID() == MProjectPhase.Table_ID) {
                pPhase = (MProjectPhase)entity;
                if (pPhase.getC_ProjectPhase_ID() != 0 && (project = (MProject)pPhase.getC_Project()).getC_Project_ID() != 0) {
                    project.setPlannedAmt(project.getPlannedAmt().add(pPhase.getPlannedAmt()));
                    project.saveEx();
                }
            } else if (entity.get_Table_ID() == MProjectTask.Table_ID && (pTask = (MProjectTask)entity).getC_ProjectTask_ID() != 0 && (pPhase2 = (MProjectPhase)pTask.getC_ProjectPhase()).getC_Project_ID() != 0) {
                pPhase2.setPlannedAmt(pPhase2.getPlannedAmt().add(pTask.getPlannedAmt()));
                pPhase2.saveEx();
            }
        }
        if (3 == type) {
            MProjectLine[] pLines;
            if (entity.get_Table_ID() == MProjectPhase.Table_ID) {
                pPhase = (MProjectPhase)entity;
                if (pPhase.getC_ProjectPhase_ID() != 0) {
                    pLines = pPhase.getLines();
                    if (pLines.size() > 0) {
                        for (MProjectLine mProjectLine : pLines) {
                            mProjectLine.delete(true);
                        }
                    } else {
                        MProjectLine[] project3 = (MProjectLine[])pPhase.getC_Project();
                        if (project3.getC_Project_ID() != 0) {
                            project3.setPlannedAmt(project3.getPlannedAmt().subtract(pPhase.getPlannedAmt()));
                            project3.saveEx();
                        }
                    }
                }
            } else if (entity.get_Table_ID() == MProjectTask.Table_ID && (pTask = (MProjectTask)entity).getC_ProjectTask_ID() != 0) {
                pLines = pTask.getLines();
                if (pLines.length > 0) {
                    for (MProjectLine mProjectLine : pLines) {
                        mProjectLine.delete(true);
                    }
                } else {
                    MProjectPhase pPhase4 = (MProjectPhase)pTask.getC_ProjectPhase();
                    if (pPhase4.getC_ProjectPhase_ID() != 0) {
                        pPhase4.setPlannedAmt(pPhase4.getPlannedAmt().subtract(pTask.getPlannedAmt()));
                        pPhase4.saveEx();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO entity, int timing) {
        if (MPayment.Table_ID == entity.get_Table_ID() && entity.get_ValueAsInt("C_Project_ID") > 0) {
            MPayment payment = (MPayment)entity;
            MProject project = (MProject)payment.getC_Project();
            BigDecimal paymentAmount = payment.getPayAmt();
            if (payment.getC_Currency_ID() != project.getC_Currency_ID()) {
                paymentAmount = MConversionRate.convert(entity.getCtx(), paymentAmount, project.getC_Currency_ID(), payment.getC_Currency_ID(), payment.getDateAcct(), payment.getC_ConversionType_ID(), this.getAD_Client_ID(), payment.getAD_Org_ID());
            }
            if (9 == timing && payment.getReversal_ID() <= 0) {
                if (payment.isReceipt()) {
                    project.setProjectBalanceAmt(project.getProjectBalanceAmt().add(paymentAmount));
                } else {
                    project.setProjectBalanceAmt(project.getProjectBalanceAmt().subtract(paymentAmount));
                }
                project.saveEx();
            }
            if (payment.getReversal_ID() > 0 && (13 == timing || 14 == timing)) {
                if (payment.isReceipt()) {
                    project.setProjectBalanceAmt(project.getProjectBalanceAmt().subtract(paymentAmount));
                } else {
                    project.setProjectBalanceAmt(project.getProjectBalanceAmt().add(paymentAmount));
                }
                project.saveEx();
            }
        }
        return null;
    }
}

