/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.util.Trx;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPOrderBOMLine;
import org.eevolution.manufacturing.process.ValidateOrderedAndReservedQuantityAbstract;

public class ValidateOrderedAndReservedQuantity
extends ValidateOrderedAndReservedQuantityAbstract {
    List<Integer> organizationList = new ArrayList<Integer>();
    List<Integer> warehouseList = new ArrayList<Integer>();
    List<Integer> productList = new ArrayList<Integer>();

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getOrgId() > 0) {
            this.organizationList.add(this.getOrgId());
        } else {
            this.organizationList.addAll(this.getOrganizations(this.getAD_Client_ID()));
        }
        if (this.getWarehouseId() > 0) {
            this.warehouseList.add(this.getWarehouseId());
        } else {
            this.organizationList.forEach(organizationId -> Arrays.stream(MWarehouse.getForOrg(this.getCtx(), organizationId)).forEach(warehouse -> this.warehouseList.add(warehouse.getM_Warehouse_ID())));
        }
        if (this.getProductId() > 0) {
            this.productList.add(this.getProductId());
        } else {
            this.warehouseList.forEach(warehouseId -> {
                StringBuilder whereClause = new StringBuilder("(AD_Org_ID=0 OR AD_Org_ID=" + this.getOrgId()).append(")");
                if (this.getProductCategoryId() > 0) {
                    whereClause.append(" AND M_Product_Category_ID=").append(this.getProductCategoryId());
                }
                if (this.getProductGroupId() > 0) {
                    whereClause.append(" AND M_Product_Group_ID=").append(this.getProductGroupId());
                }
                if (this.getProductClassId() > 0) {
                    whereClause.append(" AND M_Product_Class_ID=").append(this.getProductClassId());
                }
                if (this.getProductClassificationId() > 0) {
                    whereClause.append(" AND M_Product_Classification_ID=").append(this.getProductClassificationId());
                }
                this.productList.addAll(Arrays.stream(Objects.requireNonNull(MProduct.getAllIDs("M_Product", whereClause.toString(), this.get_TrxName()))).boxed().collect(Collectors.toList()));
            });
        }
        this.warehouseList.forEach(warehouseId -> {
            MWarehouse warehouse = MWarehouse.get(this.getCtx(), warehouseId);
            this.addLog(" @M_Warehouse_ID@ :  " + warehouse.getValue() + " - " + warehouse.getName());
            this.productList.forEach(productId -> {
                MProduct product = MProduct.get(this.getCtx(), productId);
                this.addLog(" -> @M_Product_ID@ : " + product.getValue() + " - " + product.getName());
                Trx.run(trxName -> {
                    List<MStorage> storageList = this.getStorage((int)warehouseId, (int)productId, trxName);
                    storageList.stream().filter(storage -> storage.getQtyOrdered().signum() != 0 || storage.getQtyReserved().signum() != 0).forEach(storage -> {
                        if (storage.getQtyOrdered().signum() != 0) {
                            storage.setQtyOrdered(BigDecimal.ZERO);
                        }
                        if (storage.getQtyReserved().signum() != 0) {
                            storage.setQtyReserved(BigDecimal.ZERO);
                        }
                        storage.saveEx();
                    });
                    this.checkOrderStock((Integer)warehouseId, (Integer)productId, trxName);
                    this.checkDistributionOrderStock((Integer)warehouseId, (Integer)productId, trxName);
                    this.checkManufacturingOrderStock((Integer)warehouseId, (Integer)productId, trxName);
                });
            });
        });
        return "";
    }

    private List<Integer> getOrganizations(int clientId) {
        return new Query(this.getCtx(), "AD_Org", "AD_Client_ID=?", this.get_TrxName()).setParameters(clientId).getIDsAsList();
    }

    private List<MStorage> getStorage(int warehouseId, int productId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_Product_ID").append("=? AND ").append(" ( ").append("QtyReserved").append(" <> 0 OR ").append("QtyOrdered").append(" <> 0 ) AND ");
        whereClause.append("EXISTS (SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = M_Storage.M_Locator_ID AND l.M_Warehouse_ID = ? )");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(productId);
        parameters.add(warehouseId);
        List<MStorage> storageList = new Query(this.getCtx(), "M_Storage", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).list();
        return storageList;
    }

    private void checkManufacturingOrderStock(Integer warehouseId, Integer productId, String trxName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_Warehouse_ID").append("=? AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("DocStatus IN ('IP','CO')");
        parameters.add(warehouseId);
        parameters.add(productId);
        List<MPPOrder> manufacturingOrderList = new Query(this.getCtx(), "PP_Order", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).list();
        manufacturingOrderList.forEach(order -> {
            order.setQtyReserved(BigDecimal.ZERO);
            order.orderedStock();
            order.saveEx();
            String message = " --> @QtyOrdered@ : " + order.getQtyReserved() + " - " + order.getDocumentInfo();
            this.addLog(message);
        });
        parameters = new ArrayList();
        whereClause = new StringBuilder();
        whereClause.append("M_Warehouse_ID").append("=? AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("EXISTS (SELECT 1 FROM PP_Order o WHERE o.PP_Order_ID = PP_Order_BOMLine.PP_Order_ID AND o.DocStatus IN ('IP','CO'))");
        parameters.add(warehouseId);
        parameters.add(productId);
        List<MPPOrderBOMLine> manufacturingOrderLineList = new Query(this.getCtx(), "PP_Order_BOMLine", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).list();
        manufacturingOrderLineList.forEach(orderBOMLine -> {
            orderBOMLine.setQtyReserved(BigDecimal.ZERO);
            orderBOMLine.reservedStock();
            orderBOMLine.saveEx();
            String message = " --> @QtyReserved@ : " + orderBOMLine.getQtyReserved() + " - " + orderBOMLine.getParent().getDocumentInfo();
            this.addLog(message);
        });
    }

    private void checkDistributionOrderStock(Integer warehouseId, Integer productId, String trxName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append(" EXISTS (SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = DD_OrderLine.M_LocatorTo_ID AND l.M_Warehouse_ID=?) ").append(" AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("QtyReserved").append(" <> 0 AND ");
        whereClause.append("EXISTS (SELECT 1 FROM DD_Order o WHERE o.DD_Order_ID = DD_OrderLine.DD_Order_ID AND o.DocStatus IN ('IP','CO'))");
        parameters.add(warehouseId);
        parameters.add(productId);
        List<MDDOrderLine> distributionOrderOrderedLines = new Query(this.getCtx(), "DD_OrderLine", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).list();
        distributionOrderOrderedLines.forEach(orderLine -> {
            orderLine.setQtyReserved(BigDecimal.ZERO);
            orderLine.orderedStock();
            orderLine.saveEx();
            String message = " --> @QtyOrdered@ : " + orderLine.getQtyReserved() + " - " + orderLine.getParent().getDocumentInfo();
            this.addLog(message);
        });
        parameters = new ArrayList();
        whereClause = new StringBuilder();
        whereClause.append(" EXISTS (SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID = DD_OrderLine.M_Locator_ID AND l.M_Warehouse_ID=?) ").append(" AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("QtyReserved").append(" <> 0 AND ");
        whereClause.append("EXISTS (SELECT 1 FROM DD_Order o WHERE o.DD_Order_ID = DD_OrderLine.DD_Order_ID AND o.DocStatus IN ('IP','CO'))");
        parameters.add(warehouseId);
        parameters.add(productId);
        List<MDDOrderLine> distributionOrderReservedLines = new Query(this.getCtx(), "DD_OrderLine", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).list();
        distributionOrderReservedLines.forEach(orderLine -> {
            orderLine.setQtyReserved(BigDecimal.ZERO);
            orderLine.reserveStock();
            orderLine.saveEx();
            String message = " --> @QtyReserved@ : " + orderLine.getQtyReserved() + " - " + orderLine.getParent().getDocumentInfo();
            this.addLog(message);
        });
    }

    private void checkOrderStock(Integer warehouseId, Integer productId, String trxName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_Warehouse_ID").append("=? AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("QtyReserved").append(" <> 0 AND ");
        whereClause.append("EXISTS (SELECT 1 FROM C_Order o WHERE o.C_Order_ID = C_OrderLine.C_Order_ID AND o.DocStatus IN ('IP','CO'))");
        parameters.add(warehouseId);
        parameters.add(productId);
        List<MOrderLine> orderLines = new Query(this.getCtx(), "C_OrderLine", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).list();
        orderLines.forEach(orderLine -> {
            orderLine.setQtyReserved(BigDecimal.ZERO);
            orderLine.reserveStock();
            orderLine.saveEx();
            String message = orderLine.isSOTrx() ? " --> @QtyReserved@ : " + orderLine.getQtyReserved() + " - " + orderLine.getParent().getDocumentInfo() : " --> @QtyOrdered@ : " + orderLine.getQtyReserved() + " - " + orderLine.getParent().getDocumentInfo();
            this.addLog(message);
        });
    }
}

