/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.I_AD_WF_Node;
import org.adempiere.engine.CostDimension;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.CostEngineFactory;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.eevolution.manufacturing.model.MPPProductPlanning;
import org.eevolution.manufacturing.process.RollupWorkflowAbstract;
import org.eevolution.manufacturing.services.StandardCostCollector;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;

public class RollupWorkflow
extends RollupWorkflowAbstract {
    private RoutingService routingService;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MAcctSchema accountSchema = MAcctSchema.get(this.getCtx(), this.getAcctSchemaId());
        MCostType costType = MCostType.get(this.getCtx(), this.getCostTypeId());
        final List<MCostElement> costElements = this.getCostElementId() > 0 ? Arrays.asList(MCostElement.get(this.getCtx(), this.getCostElementId())) : MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        this.routingService = RoutingServiceFactory.get().getRoutingService(this.getAD_Client_ID());
        Arrays.stream(this.getProductIds()).filter(productId -> productId > 0).forEach(productId -> {
            MProduct product = MProduct.get(this.getCtx(), productId);
            this.log.info("Product: " + product);
            int workflowId = 0;
            MPPProductPlanning productPlanning = null;
            if (workflowId <= 0) {
                workflowId = MWorkflow.getWorkflowSearchKey(product);
            }
            if (workflowId <= 0) {
                productPlanning = MPPProductPlanning.find(this.getCtx(), this.getOrgId(), this.getWarehouseId(), this.getResourceId(), product.get_ID(), this.get_TrxName());
                if (productPlanning != null) {
                    workflowId = productPlanning.getAD_Workflow_ID();
                } else {
                    this.createNotice(product, "@NotFound@ @PP_Product_Planning_ID@");
                }
            }
            if (workflowId <= 0) {
                this.createNotice(product, "@NotFound@ @AD_Workflow_ID@");
            } else {
                Trx.run(new TrxRunnable(){
                    MAcctSchema accountSchema;
                    MCostType costType;
                    MProduct product;
                    MPPProductPlanning productPlanning;
                    int workflowId;

                    public TrxRunnable setParameters(MAcctSchema accountSchema, MCostType costType, MProduct product, MPPProductPlanning productPlanning, int workflowId) {
                        this.accountSchema = accountSchema;
                        this.costType = costType;
                        this.product = product;
                        this.productPlanning = productPlanning;
                        this.workflowId = workflowId;
                        return this;
                    }

                    @Override
                    public void run(String trxName) {
                        MWorkflow workflow = new MWorkflow(RollupWorkflow.this.getCtx(), this.workflowId, trxName);
                        costElements.stream().filter(costElement -> costElement != null && CostEngine.isActivityControlElement(costElement)).forEach(costElement -> RollupWorkflow.this.rollup(this.accountSchema, this.costType, (MCostElement)costElement, this.product, workflow, trxName));
                        if (this.productPlanning != null) {
                            this.productPlanning.load(trxName);
                            this.productPlanning.setYield(workflow.getYield());
                            this.productPlanning.saveEx();
                        }
                    }
                }.setParameters(accountSchema, costType, product, productPlanning, workflowId));
            }
        });
        return "@OK@";
    }

    private int[] getProductIds() {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND (").append("ProductType").append("=?");
        params.add("I");
        whereClause.append(" OR ").append("ProductType").append("=?");
        params.add("R");
        whereClause.append(") AND ").append("IsBOM").append("=?");
        params.add(true);
        if (this.getProductId() > 0) {
            whereClause.append(" AND ").append("M_Product_ID").append("=?");
            params.add(this.getProductId());
        }
        if (this.getProductCategoryId() > 0) {
            whereClause.append(" AND ").append("M_Product_Category_ID").append("=?");
            params.add(this.getProductCategoryId());
        }
        if (this.getProductClassId() > 0) {
            whereClause.append(" AND ").append("M_Product_Class_ID").append("=?");
            params.add(this.getProductClassId());
        }
        if (this.getProductGroupId() > 0) {
            whereClause.append(" AND ").append("M_Product_Group_ID").append("=?");
            params.add(this.getProductGroupId());
        }
        if (this.getProductClassificationId() > 0) {
            whereClause.append(" AND ").append("M_Product_Classification_ID").append("=?");
            params.add(this.getProductClassificationId());
        }
        return new Query(this.getCtx(), "M_Product", whereClause.toString(), this.get_TrxName()).setOrderBy("LowLevel").setParameters(params).getIDs();
    }

    protected void rollup(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, MProduct product, MWorkflow workflow, String trxName) {
        MWFNode[] nodes;
        this.log.info("Workflow: " + workflow);
        workflow.setCost(Env.ZERO);
        double yield = 1.0;
        int queuingTime = 0;
        int setupTime = 0;
        int duration = 0;
        int waitingTime = 0;
        int movingTime = 0;
        int workingTime = 0;
        for (MWFNode node2 : nodes = workflow.getNodes(false, this.getAD_Client_ID())) {
            node2.setCost(Env.ZERO);
            if (node2.getYield() != 0) {
                yield *= (double)node2.getYield() / 100.0;
            }
            long nodeDuration = node2.getDuration();
            queuingTime += node2.getQueuingTime();
            setupTime += node2.getSetupTime();
            duration = (int)((long)duration + nodeDuration);
            waitingTime += node2.getWaitingTime();
            movingTime += node2.getMovingTime();
            workingTime += node2.getWorkingTime();
        }
        workflow.setCost(Env.ZERO);
        workflow.setYield((int)(yield * 100.0));
        workflow.setQueuingTime(queuingTime);
        workflow.setSetupTime(setupTime);
        workflow.setDuration(duration);
        workflow.setWaitingTime(waitingTime);
        workflow.setMovingTime(movingTime);
        workflow.setWorkingTime(workingTime);
        CostDimension costDimension = new CostDimension(product, accountSchema, costType.getM_CostType_ID(), this.getOrgId(), this.getWarehouseId(), 0, costElement.get_ID());
        MCost cost = MCost.getOrCreate(product, 0, accountSchema, this.getOrgId(), this.getWarehouseId(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID());
        cost.setFutureCostPrice(BigDecimal.ZERO);
        if (!cost.isCostFrozen()) {
            cost.setCurrentCostPrice(BigDecimal.ZERO);
        }
        AtomicReference<BigDecimal> segmentCost = new AtomicReference<BigDecimal>(Env.ZERO);
        Arrays.stream(nodes).filter(node -> node != null).forEach(node -> {
            CostEngineFactory.getCostEngine(node.getAD_Client_ID());
            BigDecimal rate = StandardCostCollector.getResourceActualCostRate(node.getS_Resource_ID(), costDimension, trxName);
            BigDecimal baseValue = this.routingService.getResourceBaseValue(node.getS_Resource_ID(), (I_AD_WF_Node)node);
            BigDecimal nodeCostPrecision = baseValue.multiply(rate);
            BigDecimal nodeCost = nodeCostPrecision.scale() > accountSchema.getCostingPrecision() ? nodeCostPrecision.setScale(accountSchema.getCostingPrecision(), RoundingMode.HALF_UP) : nodeCostPrecision;
            segmentCost.updateAndGet(costAmt -> costAmt.add(nodeCost));
            this.log.info(Msg.parseTranslation(this.getCtx(), " @M_CostElement_ID@ : ") + costElement.getName() + ", Node=" + node + ", BaseValue=" + baseValue + ", rate=" + rate + ", nodeCost=" + nodeCost + " => Cost=" + segmentCost);
            node.setCost(node.getCost().add(nodeCost));
        });
        cost.setFutureCostPrice(segmentCost.get());
        if (!cost.isCostFrozen()) {
            cost.setCurrentCostPrice(segmentCost.get());
        }
        cost.saveEx();
        workflow.setCost(workflow.getCost().add(segmentCost.get()));
        Arrays.stream(nodes).filter(node -> node != null).forEach(node -> node.saveEx());
        workflow.saveEx();
        this.log.info("Product: " + product.getName() + " WFCost: " + workflow.getCost());
    }

    private void createNotice(MProduct product, String msg) {
        String productValue = product != null ? product.getValue() : "-";
        this.addLog("WARNING: Product " + productValue + ": " + msg);
    }
}

