/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.util.LinkedHashMap;
import java.util.Map;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.core.domains.models.X_C_OrderLine;
import org.adempiere.core.domains.models.X_DD_Order;
import org.adempiere.core.domains.models.X_DD_OrderLine;
import org.compiere.model.MForecastLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisition;
import org.compiere.model.PO;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.manufacturing.model.MPPMRP;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.process.MRPScheduleAbstract;

public class MRPSchedule
extends MRPScheduleAbstract {
    protected Integer lineNo = null;
    protected String DEMAND = "DEMAND";
    protected String SUPPLY = "SUPPLY";
    protected Integer processRecords = 0;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.getSelectionKeys().stream().filter(mrpId -> mrpId > 0).forEach(mrpId -> {
            MPPMRP mrp = new MPPMRP(this.getCtx(), (int)mrpId, this.get_TrxName());
            if ("D".equals(mrp.getTypeMRP())) {
                this.saveBrowseValues(mrp, this.DEMAND);
            } else if ("S".equals(mrp.getTypeMRP())) {
                this.saveBrowseValues(mrp, this.SUPPLY);
            }
            if (this.getPriority() != null) {
                mrp.setPriority(this.getPriority());
            }
            if (this.getPlannerId() > 0) {
                mrp.setPlanner_ID(this.getPlannerId());
            }
            this.schedule(mrp);
        });
        return "@DocProcessed@ " + this.processRecords;
    }

    private void schedule(MPPMRP mrp) {
        PO order;
        PO orderLine;
        if (!mrp.is_Changed()) {
            return;
        }
        Integer n = this.processRecords;
        Integer n2 = this.processRecords = Integer.valueOf(this.processRecords + 1);
        if ("FCT".equals(mrp.getOrderType())) {
            MForecastLine forecastLine = (MForecastLine)mrp.getM_ForecastLine();
            if (forecastLine != null) {
                forecastLine.setDatePromised(mrp.getDatePromised());
                forecastLine.setSalesRep_ID(mrp.getPlanner_ID());
                forecastLine.saveEx();
            }
        } else if ("POR".equals(mrp.getOrderType())) {
            MRequisition requisition = (MRequisition)mrp.getM_Requisition();
            if (requisition != null) {
                requisition.setDateDoc(mrp.getDateStartSchedule());
                requisition.setDateRequired(mrp.getDatePromised());
                requisition.setAD_User_ID(mrp.getPlanner_ID());
                requisition.setPriorityRule(mrp.getPriority());
                requisition.saveEx();
            }
        } else if ("MOP".equals(mrp.getOrderType())) {
            MPPOrder order2 = (MPPOrder)mrp.getPP_Order();
            if (order2 != null) {
                order2.setDateStartSchedule(mrp.getDateStartSchedule());
                order2.setDateFinishSchedule(mrp.getDateFinishSchedule());
                order2.setDatePromised(mrp.getDatePromised());
                order2.setPlanner_ID(mrp.getPlanner_ID());
                if (mrp.getPriority() != null) {
                    order2.setPriorityRule(mrp.getPriority());
                }
                order2.setLine(this.lineNo);
                order2.saveEx();
            }
        } else if ("DOO".equals(mrp.getOrderType())) {
            orderLine = new MDDOrderLine(mrp.getCtx(), mrp.getDD_OrderLine_ID(), mrp.get_TrxName());
            if (orderLine != null) {
                ((X_DD_OrderLine)orderLine).setDateOrdered(mrp.getDateStartSchedule());
                ((X_DD_OrderLine)orderLine).setDatePromised(mrp.getDatePromised());
                orderLine.saveEx();
                order = ((MDDOrderLine)orderLine).getParent();
                ((X_DD_Order)order).setSalesRep_ID(mrp.getPlanner_ID());
                ((X_DD_Order)order).setPriorityRule(mrp.getPriority());
                order.saveEx();
            }
        } else if ("SOO".equals(mrp.getOrderType())) {
            orderLine = (MOrderLine)mrp.getC_OrderLine();
            if (orderLine != null) {
                ((X_C_OrderLine)orderLine).setDateOrdered(mrp.getDateStartSchedule());
                ((X_C_OrderLine)orderLine).setDatePromised(mrp.getDatePromised());
                orderLine.saveEx();
                order = ((MOrderLine)orderLine).getParent();
                ((X_C_Order)order).setSalesRep_ID(mrp.getPlanner_ID());
                ((X_C_Order)order).setPriorityRule(mrp.getPriority());
                order.saveEx();
            }
        } else if ("POO".equals(mrp.getOrderType()) && (orderLine = (MOrderLine)mrp.getC_OrderLine()) != null) {
            ((X_C_OrderLine)orderLine).setDateOrdered(mrp.getDateStartSchedule());
            ((X_C_OrderLine)orderLine).setDatePromised(mrp.getDatePromised());
            orderLine.saveEx();
            order = ((MOrderLine)orderLine).getParent();
            ((X_C_Order)order).setSalesRep_ID(mrp.getPlanner_ID());
            ((X_C_Order)order).setPriorityRule(mrp.getPriority());
            order.saveEx();
        }
    }

    private void saveBrowseValues(PO po, String alias) {
        LinkedHashMap<String, Object> values = this.getSelectionValues().get(po.get_ID());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String columnName = entry.getKey();
            if (!columnName.contains(alias.toUpperCase() + "_")) continue;
            columnName = columnName.substring(columnName.indexOf("_") + 1);
            po.set_ValueOfColumn(columnName, entry.getValue());
        }
    }
}

